/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.http;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDescriptor;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;

public class HttpAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(HttpAudioTrack.class);
    private final MediaContainerDescriptor containerTrackFactory;
    private final HttpAudioSourceManager sourceManager;

    public HttpAudioTrack(AudioTrackInfo trackInfo, MediaContainerDescriptor containerTrackFactory, HttpAudioSourceManager sourceManager) {
        super(trackInfo);
        this.containerTrackFactory = containerTrackFactory;
        this.sourceManager = sourceManager;
    }

    public MediaContainerDescriptor getContainerTrackFactory() {
        return this.containerTrackFactory;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            log.debug("Starting http track from URL: {}", (Object)this.trackInfo.identifier);
            try (PersistentHttpStream inputStream = new PersistentHttpStream(httpInterface, new URI(this.trackInfo.identifier), Long.MAX_VALUE);){
                this.processDelegate((InternalAudioTrack)this.containerTrackFactory.createTrack(this.trackInfo, inputStream), localExecutor);
            }
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new HttpAudioTrack(this.trackInfo, this.containerTrackFactory, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

