/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.local;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDescriptor;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerRegistry;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.ProbingAudioSourceManager;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.local.LocalAudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.local.LocalSeekableInputStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;

public class LocalAudioSourceManager
extends ProbingAudioSourceManager {
    public LocalAudioSourceManager() {
        this(MediaContainerRegistry.DEFAULT_REGISTRY);
    }

    public LocalAudioSourceManager(MediaContainerRegistry containerRegistry) {
        super(containerRegistry);
    }

    @Override
    public String getSourceName() {
        return "local";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        File file = new File(reference.identifier);
        if (file.exists() && file.isFile() && file.canRead()) {
            return this.handleLoadResult(this.detectContainerForFile(reference, file));
        }
        return null;
    }

    @Override
    protected AudioTrack createTrack(AudioTrackInfo trackInfo, MediaContainerDescriptor containerTrackFactory) {
        return new LocalAudioTrack(trackInfo, containerTrackFactory, this);
    }

    private MediaContainerDetectionResult detectContainerForFile(AudioReference reference, File file) {
        MediaContainerDetectionResult mediaContainerDetectionResult;
        LocalSeekableInputStream inputStream = new LocalSeekableInputStream(file);
        try {
            int lastDotIndex = file.getName().lastIndexOf(46);
            String fileExtension = lastDotIndex >= 0 ? file.getName().substring(lastDotIndex + 1) : null;
            mediaContainerDetectionResult = new MediaContainerDetection(this.containerRegistry, reference, inputStream, MediaContainerHints.from(null, fileExtension)).detectContainer();
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FriendlyException("Failed to open file for reading.", FriendlyException.Severity.SUSPICIOUS, e);
            }
        }
        inputStream.close();
        return mediaContainerDetectionResult;
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
        this.encodeTrackFactory(((LocalAudioTrack)track).getContainerTrackFactory(), output);
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        MediaContainerDescriptor containerTrackFactory = this.decodeTrackFactory(input);
        if (containerTrackFactory != null) {
            return new LocalAudioTrack(trackInfo, containerTrackFactory, this);
        }
        return null;
    }

    @Override
    public void shutdown() {
    }
}

