/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.soundcloud;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudDataLoader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.CloseableHttpResponse;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.HttpGet;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.utils.URIBuilder;
import su.plo.voice.lavaplayer.libs.org.apache.http.util.EntityUtils;

public class DefaultSoundCloudDataLoader
implements SoundCloudDataLoader {
    @Override
    public JsonBrowser load(HttpInterface httpInterface, String url) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(this.buildUri(url)));){
            if (response.getStatusLine().getStatusCode() == 404) {
                JsonBrowser jsonBrowser = JsonBrowser.NULL_BROWSER;
                return jsonBrowser;
            }
            HttpClientTools.assertSuccessWithContent(response, "video page response");
            String json = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            JsonBrowser jsonBrowser = JsonBrowser.parse(json);
            return jsonBrowser;
        }
    }

    private URI buildUri(String url) {
        try {
            return new URIBuilder("https://api-v2.soundcloud.com/resolve").addParameter("url", url).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

