/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.soundcloud;

import java.io.IOException;
import java.util.function.Supplier;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackBlueprint;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackLoader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudSegmentDecoder;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;

public class SoundCloudOpusSegmentDecoder
implements SoundCloudSegmentDecoder {
    private final Supplier<SeekableInputStream> nextStreamProvider;
    private OggPacketInputStream lastJoinedStream;
    private OggTrackBlueprint blueprint;

    public SoundCloudOpusSegmentDecoder(Supplier<SeekableInputStream> nextStreamProvider) {
        this.nextStreamProvider = nextStreamProvider;
    }

    @Override
    public void prepareStream(boolean beginning) throws IOException {
        OggPacketInputStream stream = this.obtainStream();
        if (beginning) {
            OggTrackBlueprint newBlueprint = OggTrackLoader.loadTrackBlueprint(stream);
            if (this.blueprint == null) {
                if (newBlueprint == null) {
                    throw new IOException("No OGG track detected in the stream.");
                }
                this.blueprint = newBlueprint;
            }
        } else {
            stream.startNewTrack();
        }
    }

    @Override
    public void resetStream() throws IOException {
        if (this.lastJoinedStream != null) {
            this.lastJoinedStream.close();
            this.lastJoinedStream = null;
        }
    }

    @Override
    public void playStream(AudioProcessingContext context, long startPosition, long desiredPosition) throws InterruptedException, IOException {
        try (OggTrackHandler handler = this.blueprint.loadTrackHandler(this.obtainStream());){
            handler.initialise(context, startPosition, desiredPosition);
            handler.provideFrames();
        }
    }

    @Override
    public void close() throws Exception {
        this.resetStream();
    }

    private OggPacketInputStream obtainStream() {
        if (this.lastJoinedStream == null) {
            this.lastJoinedStream = new OggPacketInputStream(this.nextStreamProvider.get(), true);
        }
        return this.lastJoinedStream;
    }
}

