/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.vimeo;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.playlists.ExtendedM3uParser;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.playlists.HlsStreamTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import su.plo.voice.lavaplayer.libs.org.apache.commons.io.IOUtils;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.CloseableHttpResponse;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.HttpGet;

public class VimeoAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(VimeoAudioTrack.class);
    private final VimeoAudioSourceManager sourceManager;

    public VimeoAudioTrack(AudioTrackInfo trackInfo, VimeoAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        block12: {
            try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
                JsonBrowser videoData = this.sourceManager.getVideoFromApi(httpInterface, this.trackInfo.identifier);
                VimeoAudioSourceManager.PlaybackFormat playbackFormat = this.sourceManager.getPlaybackFormat(httpInterface, videoData.get("config_url").text());
                log.debug("Starting Vimeo track. HLS: {}, URL: {}", (Object)playbackFormat.isHls, (Object)playbackFormat.url);
                if (playbackFormat.isHls) {
                    this.processDelegate(new HlsStreamTrack(this.trackInfo, this.extractHlsAudioPlaylistUrl(httpInterface, playbackFormat.url), this.sourceManager.getHttpInterfaceManager(), true), localExecutor);
                    break block12;
                }
                try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(playbackFormat.url), null);){
                    this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
                }
            }
        }
    }

    protected String resolveRelativeUrl(String baseUrl, String url) {
        while (url.startsWith("../")) {
            url = url.substring(3);
            baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf(47));
        }
        return baseUrl + (String)(url.startsWith("/") ? url : "/" + url);
    }

    private String extractHlsAudioPlaylistUrl(HttpInterface httpInterface, String videoPlaylistUrl) throws IOException {
        String url = null;
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(videoPlaylistUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code for track access info is " + statusCode));
            }
            String bodyString = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
            for (String rawLine : bodyString.split("\n")) {
                ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(rawLine);
                if (!Objects.equals(line.directiveName, "EXT-X-MEDIA") || !Objects.equals(line.directiveArguments.get("TYPE"), "AUDIO")) continue;
                url = line.directiveArguments.get("URI");
                break;
            }
        }
        if (url == null) {
            throw new FriendlyException("Failed to find audio playlist URL.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Valid audio directive was not found"));
        }
        return this.resolveRelativeUrl(videoPlaylistUrl.substring(0, videoPlaylistUrl.lastIndexOf(47)), url);
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new VimeoAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

