/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.yamusic;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.yamusic.AbstractYandexMusicApiLoader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.yamusic.YandexMusicDirectUrlLoader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import su.plo.voice.lavaplayer.libs.org.apache.commons.codec.digest.DigestUtils;
import su.plo.voice.lavaplayer.libs.org.apache.commons.io.IOUtils;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.CloseableHttpResponse;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.HttpGet;

public class DefaultYandexMusicDirectUrlLoader
extends AbstractYandexMusicApiLoader
implements YandexMusicDirectUrlLoader {
    private static final String TRACK_DOWNLOAD_INFO = "https://api.music.yandex.net/tracks/%s/download-info";
    private static final String DIRECT_URL_FORMAT = "https://%s/get-%s/%s/%s%s";
    private static final String MP3_SALT = "XGRlBW9FXlekgbPrRHuSiA";

    @Override
    public String getDirectUrl(String trackId, String codec) {
        return this.extractFromApi(String.format(TRACK_DOWNLOAD_INFO, trackId), (httpClient, codecsList) -> {
            JsonBrowser codecResult = codecsList.values().stream().filter(e -> codec.equals(e.get("codec").text())).findFirst().orElse(null);
            if (codecResult == null) {
                throw new FriendlyException("Couldn't find supported track format.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            String storageUrl = codecResult.get("downloadInfoUrl").text();
            DownloadInfo info = this.extractDownloadInfo(storageUrl);
            String sign = DigestUtils.md5Hex(MP3_SALT + info.path.substring(1) + info.s);
            return String.format(DIRECT_URL_FORMAT, info.host, codec, sign, info.ts, info.path);
        });
    }

    private DownloadInfo extractDownloadInfo(String storageUrl) throws IOException {
        DownloadInfo downloadInfo;
        block16: {
            HttpInterface httpInterface = this.httpInterfaceManager.getInterface();
            try {
                String responseText;
                try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(storageUrl));){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        throw new IOException("Invalid status code for track storage info: " + statusCode);
                    }
                    responseText = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
                }
                DownloadInfo info = new DownloadInfo();
                info.host = DataFormatTools.extractBetween(responseText, "<host>", "</host>");
                info.path = DataFormatTools.extractBetween(responseText, "<path>", "</path>");
                info.ts = DataFormatTools.extractBetween(responseText, "<ts>", "</ts>");
                info.region = DataFormatTools.extractBetween(responseText, "<region>", "</region>");
                info.s = DataFormatTools.extractBetween(responseText, "<s>", "</s>");
                downloadInfo = info;
                if (httpInterface == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (httpInterface != null) {
                        try {
                            httpInterface.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionTools.wrapUnfriendlyExceptions("Loading information for a Yandex Music track failed.", FriendlyException.Severity.FAULT, e);
                }
            }
            httpInterface.close();
        }
        return downloadInfo;
    }

    private class DownloadInfo {
        String host;
        String path;
        String ts;
        String region;
        String s;

        private DownloadInfo() {
        }
    }
}

