/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.youtube;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeClientConfig;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSearchMusicResultLoader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.ThumbnailTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpConfigurable;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.CloseableHttpResponse;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.HttpPost;
import su.plo.voice.lavaplayer.libs.org.apache.http.entity.StringEntity;
import su.plo.voice.lavaplayer.libs.org.apache.http.util.EntityUtils;

public class YoutubeSearchMusicProvider
implements YoutubeSearchMusicResultLoader {
    private static final Logger log = LoggerFactory.getLogger(YoutubeSearchMusicProvider.class);
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createCookielessThreadLocalManager();

    @Override
    public ExtendedHttpConfigurable getHttpConfiguration() {
        return this.httpInterfaceManager;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public AudioItem loadSearchMusicResult(String query, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        log.debug("Performing a search music with query {}", (Object)query);
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            AudioItem audioItem;
            block14: {
                HttpPost post = new HttpPost("https://music.youtube.com/youtubei/v1/search?key=AIzaSyC9XL3ZjWddXya6X74dJoCTL-WEYFDNX30");
                YoutubeClientConfig clientConfig = YoutubeClientConfig.MUSIC.copy().withRootField("query", query).withRootField("params", "Eg-KAQwIARAAGAAgACgAMABqChADEAQQCRAFEAo=").setAttribute(httpInterface);
                StringEntity payload = new StringEntity(clientConfig.toJsonString(), "UTF-8");
                post.setHeader("Referer", "music.youtube.com");
                post.setEntity(payload);
                CloseableHttpResponse response = httpInterface.execute(post);
                try {
                    HttpClientTools.assertSuccessWithContent(response, "search music response");
                    String responseText = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                    JsonBrowser jsonBrowser = JsonBrowser.parse(responseText);
                    audioItem = this.extractSearchResults(jsonBrowser, query, trackFactory);
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return audioItem;
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions(e);
        }
    }

    private AudioItem extractSearchResults(JsonBrowser jsonBrowser, String query, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        List<AudioTrack> tracks;
        log.debug("Attempting to parse results from music search page");
        try {
            tracks = this.extractMusicSearchPage(jsonBrowser, trackFactory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Search results for: " + query, tracks, null, true);
    }

    private List<AudioTrack> extractMusicSearchPage(JsonBrowser jsonBrowser, Function<AudioTrackInfo, AudioTrack> trackFactory) throws IOException {
        ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
        JsonBrowser tracks = jsonBrowser.get("contents").get("tabbedSearchResultsRenderer").get("tabs").index(0).get("tabRenderer").get("content").get("sectionListRenderer").get("contents").index(0).get("musicShelfRenderer").get("contents");
        if (tracks == JsonBrowser.NULL_BROWSER) {
            tracks = jsonBrowser.get("contents").get("tabbedSearchResultsRenderer").get("tabs").index(0).get("tabRenderer").get("content").get("sectionListRenderer").get("contents").index(1).get("musicShelfRenderer").get("contents");
        }
        tracks.values().forEach(jsonTrack -> {
            AudioTrack track = this.extractMusicTrack((JsonBrowser)jsonTrack, trackFactory);
            if (track != null) {
                list.add(track);
            }
        });
        return list;
    }

    private AudioTrack extractMusicTrack(JsonBrowser jsonBrowser, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        JsonBrowser thumbnail = jsonBrowser.get("musicResponsiveListItemRenderer").get("thumbnail").get("musicThumbnailRenderer");
        JsonBrowser columns = jsonBrowser.get("musicResponsiveListItemRenderer").get("flexColumns");
        if (columns.isNull()) {
            return null;
        }
        JsonBrowser firstColumn = columns.index(0).get("musicResponsiveListItemFlexColumnRenderer").get("text").get("runs").index(0);
        String title = firstColumn.get("text").text();
        String videoId = firstColumn.get("navigationEndpoint").get("watchEndpoint").get("videoId").text();
        if (videoId == null) {
            return null;
        }
        List<JsonBrowser> secondColumn = columns.index(1).get("musicResponsiveListItemFlexColumnRenderer").get("text").get("runs").values();
        String author = secondColumn.get(0).get("text").text();
        JsonBrowser lastElement = secondColumn.get(secondColumn.size() - 1);
        if (!lastElement.get("navigationEndpoint").isNull()) {
            return null;
        }
        long duration = DataFormatTools.durationTextToMillis(lastElement.get("text").text());
        AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, false, "https://www.youtube.com/watch?v=" + videoId, ThumbnailTools.getYouTubeMusicThumbnail(thumbnail, videoId), null);
        return trackFactory.apply(info);
    }
}

