/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.youtube;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeClientConfig;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSearchResultLoader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.ThumbnailTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpConfigurable;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.CloseableHttpResponse;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.HttpPost;
import su.plo.voice.lavaplayer.libs.org.apache.http.entity.StringEntity;
import su.plo.voice.lavaplayer.libs.org.apache.http.util.EntityUtils;

public class YoutubeSearchProvider
implements YoutubeSearchResultLoader {
    private static final Logger log = LoggerFactory.getLogger(YoutubeSearchProvider.class);
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createCookielessThreadLocalManager();

    @Override
    public ExtendedHttpConfigurable getHttpConfiguration() {
        return this.httpInterfaceManager;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public AudioItem loadSearchResult(String query, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        log.debug("Performing a search with query {}", (Object)query);
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            AudioItem audioItem;
            block14: {
                HttpPost post = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/search?key=AIzaSyA8eiZmM1FaDVjRy-df2KTyQ_vz_yYM39w");
                YoutubeClientConfig clientConfig = YoutubeClientConfig.ANDROID.copy().withRootField("query", query).withRootField("params", "EgIQAUICCAE=").setAttribute(httpInterface);
                StringEntity payload = new StringEntity(clientConfig.toJsonString(), "UTF-8");
                post.setEntity(payload);
                CloseableHttpResponse response = httpInterface.execute(post);
                try {
                    HttpClientTools.assertSuccessWithContent(response, "search response");
                    String responseText = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                    JsonBrowser jsonBrowser = JsonBrowser.parse(responseText);
                    audioItem = this.extractSearchResults(jsonBrowser, query, trackFactory);
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return audioItem;
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions(e);
        }
    }

    private AudioItem extractSearchResults(JsonBrowser jsonBrowser, String query, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        List<AudioTrack> tracks;
        log.debug("Attempting to parse results from search page");
        try {
            tracks = this.extractSearchPage(jsonBrowser, trackFactory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Search results for: " + query, tracks, null, true);
    }

    private List<AudioTrack> extractSearchPage(JsonBrowser jsonBrowser, Function<AudioTrackInfo, AudioTrack> trackFactory) throws IOException {
        ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
        jsonBrowser.get("contents").get("sectionListRenderer").get("contents").values().forEach(content -> content.get("itemSectionRenderer").get("contents").values().forEach(jsonTrack -> {
            AudioTrack track = this.extractPolymerData((JsonBrowser)jsonTrack, trackFactory);
            if (track != null) {
                list.add(track);
            }
        }));
        return list;
    }

    private AudioTrack extractPolymerData(JsonBrowser json, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        if ((json = json.get("compactVideoRenderer")).isNull()) {
            return null;
        }
        String title = json.get("title").get("runs").index(0).get("text").text();
        String author = json.get("longBylineText").get("runs").index(0).get("text").text();
        if (json.get("lengthText").isNull()) {
            return null;
        }
        long duration = DataFormatTools.durationTextToMillis(json.get("lengthText").get("runs").index(0).get("text").text());
        String videoId = json.get("videoId").text();
        AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, false, "https://www.youtube.com/watch?v=" + videoId, ThumbnailTools.getYouTubeThumbnail(json, videoId), null);
        return trackFactory.apply(info);
    }
}

