/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.youtube.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackJsonData;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.youtube.format.OfflineYoutubeTrackFormatExtractor;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import su.plo.voice.lavaplayer.libs.org.apache.http.entity.ContentType;

public class LegacyAdaptiveFormatsExtractor
implements OfflineYoutubeTrackFormatExtractor {
    @Override
    public List<YoutubeTrackFormat> extract(YoutubeTrackJsonData data) {
        String adaptiveFormats = data.polymerArguments.get("adaptive_fmts").text();
        if (adaptiveFormats == null) {
            return Collections.emptyList();
        }
        return this.loadTrackFormatsFromAdaptive(adaptiveFormats);
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromAdaptive(String adaptiveFormats) {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        for (String formatString : adaptiveFormats.split(",")) {
            Map<String, String> format = DataFormatTools.decodeUrlEncodedItems(formatString, false);
            tracks.add(new YoutubeTrackFormat(ContentType.parse(format.get("type")), Long.parseLong(format.get("bitrate")), Long.parseLong(format.get("clen")), 2L, format.get("url"), "", format.get("s"), format.getOrDefault("sp", "signature"), true));
        }
        return tracks;
    }
}

