/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] array, int offset, int length) throws IOException {
        if (this.buffer.hasRemaining()) {
            int chunk = Math.min(this.buffer.remaining(), length);
            this.buffer.get(array, offset, length);
            return chunk;
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }
}

