/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackState;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.TrackMarkerTracker;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBuffer;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;

public class PrimordialAudioTrackExecutor
implements AudioTrackExecutor {
    private static final Logger log = LoggerFactory.getLogger(LocalAudioTrackExecutor.class);
    private final AudioTrackInfo trackInfo;
    private final TrackMarkerTracker markerTracker;
    private volatile long position;

    public PrimordialAudioTrackExecutor(AudioTrackInfo trackInfo) {
        this.trackInfo = trackInfo;
        this.markerTracker = new TrackMarkerTracker();
    }

    @Override
    public AudioFrameBuffer getAudioBuffer() {
        return null;
    }

    @Override
    public void execute(TrackStateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop() {
        log.info("Tried to stop track {} which is not playing.", (Object)this.trackInfo.identifier);
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(long timecode) {
        this.position = timecode;
        this.markerTracker.checkSeekTimecode(timecode);
    }

    @Override
    public AudioTrackState getState() {
        return AudioTrackState.INACTIVE;
    }

    @Override
    public void setMarker(TrackMarker marker) {
        this.markerTracker.set(marker, this.position);
    }

    @Override
    public void addMarker(TrackMarker marker) {
        this.markerTracker.add(marker, this.getPosition());
    }

    @Override
    public void removeMarker(TrackMarker marker) {
        this.markerTracker.remove(marker);
    }

    @Override
    public boolean failedBeforeLoad() {
        return false;
    }

    @Override
    public AudioFrame provide() {
        return this.provide(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) {
        return null;
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame) {
        return false;
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        return false;
    }

    public void applyStateToExecutor(AudioTrackExecutor executor) {
        if (this.position != 0L) {
            executor.setPosition(this.position);
        }
        for (TrackMarker marker : this.markerTracker.getMarkers()) {
            executor.addMarker(marker);
        }
        this.markerTracker.clear();
    }
}

