/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.lava.common.tools;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(DaemonThreadFactory.class);
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final Runnable exitCallback;

    public DaemonThreadFactory(String name) {
        this(name, null);
    }

    public DaemonThreadFactory(String name, Runnable exitCallback) {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "lava-daemon-pool-" + name + "-" + poolNumber.getAndIncrement() + "-thread-";
        this.exitCallback = exitCallback;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.group, this.getThreadRunnable(runnable), this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        thread.setDaemon(true);
        thread.setPriority(5);
        return thread;
    }

    private Runnable getThreadRunnable(Runnable target) {
        if (this.exitCallback == null) {
            return target;
        }
        return new ExitCallbackRunnable(target);
    }

    private class ExitCallbackRunnable
    implements Runnable {
        private final Runnable original;

        private ExitCallbackRunnable(Runnable original) {
            this.original = original;
        }

        @Override
        public void run() {
            try {
                if (this.original != null) {
                    this.original.run();
                }
            }
            finally {
                this.wrapExitCallback();
            }
        }

        private void wrapExitCallback() {
            boolean wasInterrupted = Thread.interrupted();
            try {
                DaemonThreadFactory.this.exitCallback.run();
            }
            catch (Throwable throwable) {
                log.error("Thread exit notification threw an exception.", throwable);
            }
            finally {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

