/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.cipher;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.grack.nanojson.JsonStringWriter;
import su.plo.voice.lavaplayer.libs.com.grack.nanojson.JsonWriter;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.ExceptionWithResponseBody;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.cipher.CipherManager;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.track.format.StreamFormat;
import su.plo.voice.lavaplayer.libs.org.apache.http.HttpEntity;
import su.plo.voice.lavaplayer.libs.org.apache.http.HttpResponse;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.CloseableHttpResponse;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.HttpPost;
import su.plo.voice.lavaplayer.libs.org.apache.http.entity.ContentType;
import su.plo.voice.lavaplayer.libs.org.apache.http.entity.StringEntity;
import su.plo.voice.lavaplayer.libs.org.apache.http.util.EntityUtils;
import su.plo.voice.lavaplayer.libs.org.jetbrains.annotations.NotNull;

public class RemoteCipherManager
implements CipherManager {
    private static final Logger log = LoggerFactory.getLogger(RemoteCipherManager.class);
    @NotNull
    private final String remoteUrl;
    protected volatile CipherManager.CachedPlayerScript cachedPlayerScript;

    public RemoteCipherManager(@NotNull String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    @NotNull
    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    @Override
    @NotNull
    public URI resolveFormatUrl(@NotNull HttpInterface httpInterface, @NotNull String playerScript, @NotNull StreamFormat format) throws IOException {
        return this.resolveUrl(httpInterface, format.getUrl(), playerScript, format.getSignature(), format.getNParameter(), format.getSignatureKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CipherManager.CachedPlayerScript getCachedPlayerScript(@NotNull HttpInterface httpInterface) {
        if (this.cachedPlayerScript == null || System.currentTimeMillis() >= this.cachedPlayerScript.expireTimestampMs) {
            RemoteCipherManager remoteCipherManager = this;
            synchronized (remoteCipherManager) {
                if (this.cachedPlayerScript == null || System.currentTimeMillis() >= this.cachedPlayerScript.expireTimestampMs) {
                    try {
                        this.cachedPlayerScript = this.getPlayerScript(httpInterface);
                        return this.cachedPlayerScript;
                    }
                    catch (RuntimeException e) {
                        if (e instanceof ExceptionWithResponseBody) {
                            throw ExceptionTools.throwWithDebugInfo(log, null, e.getMessage(), "html", ((ExceptionWithResponseBody)e).getResponseBody());
                        }
                        throw e;
                    }
                }
            }
        }
        return this.cachedPlayerScript;
    }

    @Override
    public String getTimestamp(HttpInterface httpInterface, String sourceUrl) throws IOException {
        RemoteCipherManager remoteCipherManager = this;
        synchronized (remoteCipherManager) {
            String string;
            block9: {
                HttpPost request = new HttpPost(this.getRemoteEndpoint("get_sts"));
                log.debug("Getting timestamp for script: {}", (Object)sourceUrl);
                String requestBody = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("player_url", sourceUrl)).end()).done();
                request.setEntity(new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                CloseableHttpResponse response = this.configureHttpInterface(httpInterface).execute(request);
                try {
                    String responseBody = this.validateAndGetResponseBody(response);
                    log.debug("Received response from remote cipher service: {}", (Object)responseBody);
                    JsonBrowser json = JsonBrowser.parse(responseBody);
                    string = json.get("sts").text();
                    if (response == null) break block9;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    private String getRemoteEndpoint(String path) {
        return this.remoteUrl.endsWith("/") ? this.remoteUrl + path : this.remoteUrl + "/" + path;
    }

    public HttpInterface configureHttpInterface(HttpInterface httpInterface) {
        httpInterface.getContext().setAttribute("remoteCipherRequest", true);
        return httpInterface;
    }

    private URI resolveUrl(HttpInterface httpInterface, URI baseUrl, String playerScript, String signature, String nParam, String sigKey) throws IOException {
        URI uRI;
        block12: {
            HttpPost request = new HttpPost(this.getRemoteEndpoint("resolve_url"));
            log.debug("Resolving stream url {} with player script {}", (Object)baseUrl, (Object)playerScript);
            JsonStringWriter writer = (JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("stream_url", baseUrl.toString())).value("player_url", playerScript);
            if (signature != null) {
                writer.value("encrypted_signature", signature);
            }
            if (nParam != null) {
                writer.value("n_param", nParam);
            }
            if (sigKey != null) {
                writer.value("signature_key", sigKey);
            }
            String requestBody = ((JsonStringWriter)writer.end()).done();
            request.setEntity(new StringEntity(requestBody, ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = this.configureHttpInterface(httpInterface).execute(request);
            try {
                String responseBody = this.validateAndGetResponseBody(response);
                JsonBrowser json = JsonBrowser.parse(responseBody);
                String resolvedUrl = json.get("resolved_url").text();
                if (resolvedUrl == null || resolvedUrl.isEmpty()) {
                    throw new IOException("Remote cipher service did not return a resolved URL.");
                }
                uRI = new URI(resolvedUrl);
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return uRI;
    }

    @NotNull
    public String validateAndGetResponseBody(@NotNull HttpResponse response) throws IOException {
        String responseBody;
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String string = responseBody = entity != null ? EntityUtils.toString(entity, StandardCharsets.UTF_8) : null;
        if (!HttpClientTools.isSuccessWithContent(statusCode)) {
            throw new IOException("Remote cipher service request to resolve URL failed with status code: " + statusCode + ". Response: " + responseBody);
        }
        if (DataFormatTools.isNullOrEmpty(responseBody)) {
            throw new IOException("Received empty successful response from remote cipher service.");
        }
        return responseBody;
    }
}

