/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.clients.skeleton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.OptionDisabledException;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.YoutubeAudioSourceManager;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.clients.ClientConfig;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.clients.skeleton.Client;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.track.format.TrackFormats;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.CloseableHttpResponse;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.HttpPost;
import su.plo.voice.lavaplayer.libs.org.apache.http.entity.StringEntity;
import su.plo.voice.lavaplayer.libs.org.jetbrains.annotations.NotNull;
import su.plo.voice.lavaplayer.libs.org.jetbrains.annotations.Nullable;

public abstract class MusicClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(MusicClient.class);

    @NotNull
    protected abstract ClientConfig getBaseClientConfig(@NotNull HttpInterface var1);

    protected JsonBrowser getMusicSearchResult(@NotNull HttpInterface httpInterface, @NotNull String searchQuery) {
        JsonBrowser jsonBrowser;
        block8: {
            ClientConfig config = this.getBaseClientConfig(httpInterface).withRootField("query", searchQuery).withRootField("params", "Eg-KAQwIARAAGAAgACgAMABqChADEAQQCRAFEAo=").setAttributes(httpInterface);
            HttpPost request = new HttpPost("https://music.youtube.com/youtubei/v1/search?prettyPrint=false");
            request.setEntity(new StringEntity(config.toJsonString(), "UTF-8"));
            request.setHeader("Referer", "music.youtube.com");
            CloseableHttpResponse response = httpInterface.execute(request);
            try {
                HttpClientTools.assertSuccessWithContent(response, "search music response");
                jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ExceptionTools.toRuntimeException(e);
                }
            }
            response.close();
        }
        return jsonBrowser;
    }

    protected JsonBrowser extractSearchResultTrackJson(@NotNull JsonBrowser json) {
        return json.get("contents").get("tabbedSearchResultsRenderer").get("tabs").index(0).get("tabRenderer").get("content").get("sectionListRenderer").get("contents").values().stream().filter(item -> !item.get("musicShelfRenderer").isNull()).findFirst().map(item -> item.get("musicShelfRenderer").get("contents")).orElse(JsonBrowser.NULL_BROWSER);
    }

    @NotNull
    protected List<AudioTrack> extractSearchResultTracks(@NotNull YoutubeAudioSourceManager source, @NotNull JsonBrowser json) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser track : json.values()) {
            JsonBrowser lastElement;
            JsonBrowser columns = track.get("musicResponsiveListItemRenderer").get("flexColumns");
            if (columns.isNull()) continue;
            JsonBrowser metadata = columns.index(0).get("musicResponsiveListItemFlexColumnRenderer").get("text").get("runs").index(0);
            String title = metadata.get("text").text();
            String videoId = metadata.get("navigationEndpoint").get("watchEndpoint").get("videoId").text();
            if (videoId == null) continue;
            List<JsonBrowser> runs = columns.index(1).get("musicResponsiveListItemFlexColumnRenderer").get("text").get("runs").values();
            String author = runs.get(0).get("text").text();
            if (author == null) {
                log.debug("Author field is null, client: {}, json: {}", (Object)this.getIdentifier(), (Object)json.format());
                author = "Unknown artist";
            }
            if (!(lastElement = runs.get(runs.size() - 1)).get("navigationEndpoint").isNull()) continue;
            long duration = DataFormatTools.durationTextToMillis(lastElement.get("text").text());
            tracks.add(this.buildAudioTrack(source, track, title, author, duration, videoId, false));
        }
        return tracks;
    }

    @Override
    public boolean canHandleRequest(@NotNull String identifier) {
        return identifier.startsWith("ytmsearch:") && this.getOptions().getSearching();
    }

    @Override
    public void setPlaylistPageCount(int count) {
    }

    @Override
    public boolean supportsFormatLoading() {
        return false;
    }

    @Override
    public AudioItem loadSearchMusic(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String searchQuery) {
        if (!this.getOptions().getSearching()) {
            throw new OptionDisabledException("Searching is disabled for this client");
        }
        JsonBrowser json = this.getMusicSearchResult(httpInterface, searchQuery);
        JsonBrowser trackJson = this.extractSearchResultTrackJson(json);
        List<AudioTrack> tracks = this.extractSearchResultTracks(source, trackJson);
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Search music results for: " + searchQuery, tracks, null, true);
    }

    @Override
    public TrackFormats loadFormats(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String videoId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AudioItem loadVideo(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String videoId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AudioItem loadSearch(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String searchQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AudioItem loadMix(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String mixId, @Nullable String selectedVideoId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AudioItem loadPlaylist(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String playlistId, @Nullable String selectedVideoId) {
        throw new UnsupportedOperationException();
    }
}

