/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.http.HttpContextRetryCounter;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.http.BaseYoutubeHttpContextFilter;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.http.YoutubeAccessTokenTracker;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.http.YoutubeOauth2Handler;
import su.plo.voice.lavaplayer.libs.org.apache.http.HttpResponse;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.CookieStore;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.methods.HttpUriRequest;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.protocol.HttpClientContext;
import su.plo.voice.lavaplayer.libs.org.apache.http.impl.client.BasicCookieStore;
import su.plo.voice.lavaplayer.libs.org.jetbrains.annotations.NotNull;
import su.plo.voice.lavaplayer.libs.org.jetbrains.annotations.Nullable;

public class YoutubeHttpContextFilter
extends BaseYoutubeHttpContextFilter {
    private static final Logger log = LoggerFactory.getLogger(YoutubeHttpContextFilter.class);
    private static final String ATTRIBUTE_RESET_RETRY = "isResetRetry";
    public static final String ATTRIBUTE_USER_AGENT_SPECIFIED = "clientUserAgent";
    public static final String ATTRIBUTE_VISITOR_DATA_SPECIFIED = "clientVisitorData";
    public static final String ATTRIBUTE_CIPHER_REQUEST_SPECIFIED = "remoteCipherRequest";
    private static final HttpContextRetryCounter retryCounter = new HttpContextRetryCounter("yt-token-retry");
    private YoutubeAccessTokenTracker tokenTracker;
    private YoutubeOauth2Handler oauth2Handler;
    private String remoteCipherPass;
    private String remoteCipherUserAgent;
    private String pluginVersion;

    public void setTokenTracker(@NotNull YoutubeAccessTokenTracker tokenTracker) {
        this.tokenTracker = tokenTracker;
    }

    public void setOauth2Handler(@NotNull YoutubeOauth2Handler oauth2Handler) {
        this.oauth2Handler = oauth2Handler;
    }

    public void setCipherConfig(@Nullable String remotePass, @Nullable String userAgent, @NotNull String pluginVersion) {
        this.remoteCipherPass = remotePass;
        this.remoteCipherUserAgent = userAgent;
        this.pluginVersion = pluginVersion;
    }

    @Override
    public void onContextOpen(HttpClientContext context) {
        CookieStore cookieStore = context.getCookieStore();
        if (cookieStore == null) {
            cookieStore = new BasicCookieStore();
            context.setCookieStore(cookieStore);
        }
        cookieStore.clear();
    }

    @Override
    public void onRequest(HttpClientContext context, HttpUriRequest request, boolean isRepetition) {
        if (!isRepetition) {
            context.removeAttribute(ATTRIBUTE_RESET_RETRY);
        }
        retryCounter.handleUpdate(context, isRepetition);
        if (this.tokenTracker.isTokenFetchContext(context)) {
            return;
        }
        if (this.oauth2Handler.isOauthFetchContext(context)) {
            return;
        }
        String userAgent = context.getAttribute(ATTRIBUTE_USER_AGENT_SPECIFIED, String.class);
        if (this.isRemoteCipherRequest(context)) {
            if (!DataFormatTools.isNullOrEmpty(this.remoteCipherPass)) {
                request.addHeader("Authorization", this.remoteCipherPass);
            }
            if (!DataFormatTools.isNullOrEmpty(this.remoteCipherUserAgent)) {
                request.addHeader("User-Agent", this.remoteCipherUserAgent);
            }
            request.addHeader("Plugin-Version", this.pluginVersion);
        } else if (!request.getURI().getHost().contains("googlevideo")) {
            boolean isRequestFromOauthedClient;
            if (userAgent != null) {
                request.setHeader("User-Agent", userAgent);
                String visitorData = context.getAttribute(ATTRIBUTE_VISITOR_DATA_SPECIFIED, String.class);
                request.setHeader("X-Goog-Visitor-Id", visitorData != null ? visitorData : this.tokenTracker.getVisitorId());
                context.removeAttribute(ATTRIBUTE_VISITOR_DATA_SPECIFIED);
                context.removeAttribute(ATTRIBUTE_USER_AGENT_SPECIFIED);
            }
            boolean bl = isRequestFromOauthedClient = context.removeAttribute("yt-oauth-enabled-client") == Boolean.TRUE;
            if (isRequestFromOauthedClient && "https://youtubei.googleapis.com/youtubei/v1/player?prettyPrint=false".equals(request.getURI().toString())) {
                String oauthToken = context.getAttribute("yt-oauth-token", String.class);
                if (oauthToken != null && !oauthToken.isEmpty()) {
                    this.oauth2Handler.applyToken(request, oauthToken);
                } else {
                    this.oauth2Handler.applyToken(request);
                }
            }
        }
    }

    @Override
    public boolean onRequestResponse(HttpClientContext context, HttpUriRequest request, HttpResponse response) {
        return false;
    }

    @Override
    public boolean onRequestException(HttpClientContext context, HttpUriRequest request, Throwable error) {
        if (HttpClientTools.isConnectionResetException(error) && context.getAttribute(ATTRIBUTE_RESET_RETRY) == null) {
            context.setAttribute(ATTRIBUTE_RESET_RETRY, true);
            return true;
        }
        return false;
    }

    private boolean isRemoteCipherRequest(HttpClientContext context) {
        return context.removeAttribute(ATTRIBUTE_CIPHER_REQUEST_SPECIFIED) == Boolean.TRUE;
    }
}

