/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.track.format;

import su.plo.voice.lavaplayer.libs.org.apache.http.entity.ContentType;
import su.plo.voice.lavaplayer.libs.org.jetbrains.annotations.NotNull;
import su.plo.voice.lavaplayer.libs.org.jetbrains.annotations.Nullable;

public enum FormatInfo {
    WEBM_OPUS("audio/webm", "opus"),
    WEBM_VORBIS("audio/webm", "vorbis"),
    MP4_AAC_LC("audio/mp4", "mp4a.40.2"),
    WEBM_VIDEO_VORBIS("video/webm", "vorbis"),
    MP4_VIDEO_AAC_LC("video/mp4", "mp4a.40.2");

    public final String mimeType;
    public final String codec;

    private FormatInfo(String mimeType, String codec) {
        this.mimeType = mimeType;
        this.codec = codec;
    }

    @Nullable
    public static FormatInfo get(@NotNull ContentType contentType) {
        String mimeType = contentType.getMimeType();
        String codec = contentType.getParameter("codecs");
        for (FormatInfo formatInfo : FormatInfo.values()) {
            if (!formatInfo.mimeType.equals(mimeType) || !formatInfo.codec.equals(codec)) continue;
            return formatInfo;
        }
        for (FormatInfo formatInfo : FormatInfo.values()) {
            if (!formatInfo.mimeType.equals(mimeType) || !codec.contains(formatInfo.codec)) continue;
            return formatInfo;
        }
        return null;
    }
}

