/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.track.format;

import java.net.URI;
import java.net.URISyntaxException;
import su.plo.voice.lavaplayer.libs.dev.lavalink.youtube.track.format.FormatInfo;
import su.plo.voice.lavaplayer.libs.org.apache.http.entity.ContentType;
import su.plo.voice.lavaplayer.libs.org.jetbrains.annotations.NotNull;
import su.plo.voice.lavaplayer.libs.org.jetbrains.annotations.Nullable;

public class StreamFormat {
    private final FormatInfo info;
    private final ContentType type;
    private final int itag;
    private final long bitrate;
    private final long contentLength;
    private final long audioChannels;
    private final String url;
    private final String nParameter;
    private final String signature;
    private final String signatureKey;
    private final boolean defaultAudioTrack;
    private final boolean isDrc;

    public StreamFormat(ContentType type, int itag, long bitrate, long contentLength, long audioChannels, String url, String nParameter, String signature, String signatureKey, boolean isDefaultAudioTrack, boolean isDrc) {
        this.info = FormatInfo.get(type);
        this.type = type;
        this.itag = itag;
        this.bitrate = bitrate;
        this.contentLength = contentLength;
        this.audioChannels = audioChannels;
        this.url = url;
        this.nParameter = nParameter;
        this.signature = signature;
        this.signatureKey = signatureKey;
        this.defaultAudioTrack = isDefaultAudioTrack;
        this.isDrc = isDrc;
    }

    @Nullable
    public FormatInfo getInfo() {
        return this.info;
    }

    @NotNull
    public ContentType getType() {
        return this.type;
    }

    public int getItag() {
        return this.itag;
    }

    public long getBitrate() {
        return this.bitrate;
    }

    public long getAudioChannels() {
        return this.audioChannels;
    }

    @NotNull
    public URI getUrl() {
        try {
            return new URI(this.url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    @Nullable
    public String getNParameter() {
        return this.nParameter;
    }

    @Nullable
    public String getSignature() {
        return this.signature;
    }

    @Nullable
    public String getSignatureKey() {
        return this.signatureKey;
    }

    public boolean isDefaultAudioTrack() {
        return this.defaultAudioTrack;
    }

    public boolean isDrc() {
        return this.isDrc;
    }

    public String toString() {
        return "YoutubeStreamFormat{itag=" + this.itag + ", type=" + this.type + ", bitrate=" + this.bitrate + ", audioChannels=" + this.audioChannels + ", isDrc=" + this.isDrc + ", nParam=" + this.nParameter + ", sigKey=" + this.signatureKey + ", sig=" + this.signature + '}';
    }
}

