/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.org.apache.http.impl.conn;

import java.net.InetAddress;
import su.plo.voice.lavaplayer.libs.org.apache.http.HttpException;
import su.plo.voice.lavaplayer.libs.org.apache.http.HttpHost;
import su.plo.voice.lavaplayer.libs.org.apache.http.HttpRequest;
import su.plo.voice.lavaplayer.libs.org.apache.http.ProtocolException;
import su.plo.voice.lavaplayer.libs.org.apache.http.annotation.Contract;
import su.plo.voice.lavaplayer.libs.org.apache.http.annotation.ThreadingBehavior;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.config.RequestConfig;
import su.plo.voice.lavaplayer.libs.org.apache.http.client.protocol.HttpClientContext;
import su.plo.voice.lavaplayer.libs.org.apache.http.conn.SchemePortResolver;
import su.plo.voice.lavaplayer.libs.org.apache.http.conn.UnsupportedSchemeException;
import su.plo.voice.lavaplayer.libs.org.apache.http.conn.routing.HttpRoute;
import su.plo.voice.lavaplayer.libs.org.apache.http.conn.routing.HttpRoutePlanner;
import su.plo.voice.lavaplayer.libs.org.apache.http.impl.conn.DefaultSchemePortResolver;
import su.plo.voice.lavaplayer.libs.org.apache.http.protocol.HttpContext;
import su.plo.voice.lavaplayer.libs.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        return proxy == null ? new HttpRoute(target, local, secure) : new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

