/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.org.jsoup.nodes;

import java.io.IOException;
import javax.annotation.Nullable;
import su.plo.voice.lavaplayer.libs.org.jsoup.nodes.Document;
import su.plo.voice.lavaplayer.libs.org.jsoup.nodes.Element;
import su.plo.voice.lavaplayer.libs.org.jsoup.nodes.LeafNode;
import su.plo.voice.lavaplayer.libs.org.jsoup.nodes.NodeUtils;
import su.plo.voice.lavaplayer.libs.org.jsoup.nodes.XmlDeclaration;
import su.plo.voice.lavaplayer.libs.org.jsoup.parser.ParseSettings;
import su.plo.voice.lavaplayer.libs.org.jsoup.parser.Parser;

public class Comment
extends LeafNode {
    public Comment(String data) {
        this.value = data;
    }

    @Override
    public String nodeName() {
        return "#comment";
    }

    public String getData() {
        return this.coreValue();
    }

    public Comment setData(String data) {
        this.coreValue(data);
        return this;
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (out.prettyPrint() && (this.isEffectivelyFirst() && this.parentNode instanceof Element && ((Element)this.parentNode).tag().formatAsBlock() || out.outline())) {
            this.indent(accum, depth, out);
        }
        accum.append("<!--").append(this.getData()).append("-->");
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public Comment clone() {
        return (Comment)super.clone();
    }

    public boolean isXmlDeclaration() {
        String data = this.getData();
        return Comment.isXmlDeclarationData(data);
    }

    private static boolean isXmlDeclarationData(String data) {
        return data.length() > 1 && (data.startsWith("!") || data.startsWith("?"));
    }

    @Nullable
    public XmlDeclaration asXmlDeclaration() {
        String data = this.getData();
        XmlDeclaration decl = null;
        String declContent = data.substring(1, data.length() - 1);
        if (Comment.isXmlDeclarationData(declContent)) {
            return null;
        }
        String fragment = "<" + declContent + ">";
        Document doc = Parser.htmlParser().settings(ParseSettings.preserveCase).parseInput(fragment, this.baseUri());
        if (doc.body().children().size() > 0) {
            Element el = doc.body().child(0);
            decl = new XmlDeclaration(NodeUtils.parser(doc).settings().normalizeTag(el.tagName()), data.startsWith("!"));
            decl.attributes().addAll(el.attributes());
        }
        return decl;
    }
}

