/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_447;
import org.texboobcat.beautiful_statistics_screen.Beautiful_statistics_screen;
import org.texboobcat.beautiful_statistics_screen.backup.StatBackupManager;
import org.texboobcat.beautiful_statistics_screen.client.KeyBindings;
import org.texboobcat.beautiful_statistics_screen.client.gui.ImprovedStatsScreen;
import org.texboobcat.beautiful_statistics_screen.client.hud.StatHudRenderer;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatTracker;
import org.texboobcat.beautiful_statistics_screen.custom.StatNotificationManager;
import org.texboobcat.beautiful_statistics_screen.history.HistoryManager;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;

public class ClientEvents {
    private static int tickCounter = 0;
    private static int historyTickCounter = 0;
    private static int statSaveCounter = 0;
    private static int backupCounter = 0;
    private static final int STAT_REFRESH_INTERVAL = 100;
    private static boolean hasCheckedForStatReset = false;

    public static void register() {
        ClientGuiEvent.RENDER_HUD.register(ClientEvents::onRenderHud);
        ClientTickEvent.CLIENT_POST.register(ClientEvents::onClientTick);
        ClientGuiEvent.SET_SCREEN.register(ClientEvents::onSetScreen);
    }

    private static CompoundEventResult<class_437> onSetScreen(class_437 screen) {
        if (screen instanceof class_447) {
            class_310 mc = class_310.method_1551();
            class_437 parent = mc.field_1755;
            return CompoundEventResult.interruptTrue((Object)((Object)new ImprovedStatsScreen(parent)));
        }
        return CompoundEventResult.pass();
    }

    private static void onRenderHud(class_332 graphics, float tickDelta) {
        StatHudRenderer.render(graphics, tickDelta);
    }

    private static void onClientTick(class_310 minecraft) {
        int backupInterval;
        int autosaveInterval;
        int historyInterval;
        if (minecraft.field_1724 != null && minecraft.field_1755 == null) {
            boolean success;
            if (KeyBindings.OPEN_STATS.method_1436()) {
                minecraft.method_1507((class_437)new ImprovedStatsScreen(null));
            }
            if (KeyBindings.TOGGLE_HUD.method_1436()) {
                StatHudRenderer.toggleVisibility();
                minecraft.field_1724.method_43496((class_2561)class_2561.method_43471((String)("message.beautiful_statistics_screen.hud_" + (StatHudRenderer.isVisible() ? "enabled" : "disabled"))));
            }
            if (KeyBindings.QUICK_EXPORT.method_1436() && (success = SnapshotManager.exportSnapshot(null, true))) {
                minecraft.field_1724.method_43496((class_2561)class_2561.method_43471((String)"message.beautiful_statistics_screen.snapshot_exported"));
            }
        }
        if (minecraft.field_1724 != null && !StatDataManager.isInitialized()) {
            StatDataManager.refresh();
            statSaveCounter = 0;
            backupCounter = 0;
            hasCheckedForStatReset = false;
        }
        if (minecraft.field_1724 != null && StatDataManager.isInitialized() && !hasCheckedForStatReset && ModConfig.getClient().autoDetectStatReset) {
            hasCheckedForStatReset = true;
            new Thread(() -> {
                try {
                    Thread.sleep(5000L);
                    StatBackupManager.detectAndRestoreIfNeeded();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, "StatResetDetector").start();
        }
        if (minecraft.field_1724 == null && StatDataManager.isInitialized()) {
            statSaveCounter = 0;
            backupCounter = 0;
            hasCheckedForStatReset = false;
        }
        if (ModConfig.getClient().enableSmoothStatUpdates && minecraft.field_1724 != null && StatHudRenderer.isVisible()) {
            StatDataManager.updateClientSideStats();
        }
        if (minecraft.field_1724 != null) {
            CustomStatTracker.onTick();
        }
        StatNotificationManager.tick();
        int refreshInterval = ModConfig.getClient().statRefreshInterval;
        if (++tickCounter >= refreshInterval) {
            tickCounter = 0;
            if (minecraft.field_1724 != null && (StatHudRenderer.isVisible() || !ModConfig.getClient().enableSmoothStatUpdates)) {
                StatDataManager.refresh();
            }
        }
        if (minecraft.field_1724 != null && ModConfig.getClient().enableHistoryTracking && ++historyTickCounter >= (historyInterval = ModConfig.getClient().historyLogInterval * 20)) {
            historyTickCounter = 0;
            new Thread(() -> {
                try {
                    HistoryManager.logCurrentStats();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, "HistoryLogger").start();
        }
        if (minecraft.field_1724 != null && ModConfig.getClient().enableStatsAutosave && ++statSaveCounter >= (autosaveInterval = ModConfig.getClient().statsAutosaveInterval * 20)) {
            statSaveCounter = 0;
            ClientEvents.savePlayerStats(minecraft);
        }
        if (minecraft.field_1724 != null && ModConfig.getClient().enableStatsBackups && ++backupCounter >= (backupInterval = ModConfig.getClient().statsBackupInterval * 20)) {
            backupCounter = 0;
            new Thread(() -> {
                try {
                    boolean success = StatBackupManager.createBackup();
                    if (success) {
                        Beautiful_statistics_screen.LOGGER.info("Created stat backup for player " + minecraft.field_1724.method_5477().getString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, "BackupCreator").start();
        }
    }

    private static void savePlayerStats(class_310 minecraft) {
        try {
            class_1132 server;
            class_3222 serverPlayer;
            if (minecraft.method_1496() && minecraft.method_1576() != null && (serverPlayer = (server = minecraft.method_1576()).method_3760().method_14602(minecraft.field_1724.method_5667())) != null) {
                serverPlayer.method_14248().method_14912();
                server.method_3723(false, false, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

