/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.client.gui.chart.ChartDataset;
import org.texboobcat.beautiful_statistics_screen.client.gui.chart.ChartRenderer;
import org.texboobcat.beautiful_statistics_screen.client.gui.widgets.DatasetSelectorWidget;
import org.texboobcat.beautiful_statistics_screen.client.gui.widgets.StatisticsPanel;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;
import org.texboobcat.beautiful_statistics_screen.history.HistoryManager;

public class AdvancedChartScreen
extends class_437 {
    private static final int[] COLORS = new int[]{-16733441, -38037, -11613327, -6547, -30841, -9675545, -16723245, -165464, -9127425, -6120450, -11145276, -347744};
    private final class_437 parent;
    private final List<ChartDataset> datasets = new ArrayList<ChartDataset>();
    private ChartRenderer chartRenderer;
    private DatasetSelectorWidget datasetSelector;
    private StatisticsPanel statisticsPanel;
    private TimeRange timeRange = TimeRange.ALL;
    private ChartDataset.ChartStyle currentChartType = ChartDataset.ChartStyle.LINE;
    private class_4185 addDatasetButton;
    private class_4185 timeRangeButton;
    private class_4185 chartTypeButton;
    private class_4185 analyzeButton;
    private boolean showStatistics = false;

    public AdvancedChartScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Advanced Chart Analytics"));
        this.parent = parent;
    }

    public AdvancedChartScreen(class_437 parent, class_2960 initialStat, class_2561 statName) {
        this(parent);
        this.addDataset(initialStat, statName);
    }

    protected void method_25426() {
        super.method_25426();
        int buttonY = 10;
        int buttonX = 10;
        int buttonW = 100;
        int spacing = 5;
        this.addDatasetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+ Add Dataset"), b -> this.openDatasetPicker()).method_46434(buttonX, buttonY, buttonW, 20).method_46431();
        this.method_37063((class_364)this.addDatasetButton);
        this.timeRangeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Range: " + this.timeRange.label)), b -> {
            this.timeRange = this.timeRange.next();
            this.timeRangeButton.method_25355((class_2561)class_2561.method_43470((String)("Range: " + this.timeRange.label)));
            this.reloadData();
        }).method_46434(buttonX += buttonW + spacing, buttonY, buttonW + 20, 20).method_46431();
        this.method_37063((class_364)this.timeRangeButton);
        this.chartTypeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Type: " + this.formatChartType(this.currentChartType))), b -> {
            this.currentChartType = this.getNextChartType(this.currentChartType);
            for (ChartDataset dataset : this.datasets) {
                dataset.setStyle(this.currentChartType);
            }
            this.chartTypeButton.method_25355((class_2561)class_2561.method_43470((String)("Type: " + this.formatChartType(this.currentChartType))));
        }).method_46434(buttonX += buttonW + 20 + spacing, buttonY, buttonW, 20).method_46431();
        this.method_37063((class_364)this.chartTypeButton);
        class_4185 trendButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2610 Trends"), b -> {
            boolean allEnabled = this.datasets.stream().allMatch(ChartDataset::isShowTrendLine);
            for (ChartDataset dataset : this.datasets) {
                dataset.setShowTrendLine(!allEnabled);
            }
            b.method_25355((class_2561)class_2561.method_43470((String)((!allEnabled ? "\u2611" : "\u2610") + " Trends")));
        }).method_46434(buttonX += buttonW + spacing, buttonY, buttonW - 20, 20).method_46431();
        this.method_37063((class_364)trendButton);
        class_4185 statsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcca Stats"), b -> {
            boolean bl = this.showStatistics = !this.showStatistics;
            if (this.statisticsPanel != null) {
                this.statisticsPanel.field_22764 = this.showStatistics;
            }
        }).method_46434(buttonX += buttonW - 20 + spacing, buttonY, buttonW - 30, 20).method_46431();
        this.method_37063((class_364)statsButton);
        this.analyzeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd0d Analyze"), b -> this.openAnalysis()).method_46434(buttonX += buttonW - 30 + spacing, buttonY, buttonW - 20, 20).method_46431();
        this.method_37063((class_364)this.analyzeButton);
        class_4185 back = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.method_25419()).method_46434((this.field_22789 - 200) / 2, this.field_22790 - 28, 200, 20).method_46431();
        this.method_37063((class_364)back);
        int selectorWidth = 200;
        this.datasetSelector = new DatasetSelectorWidget(this.field_22787, this.field_22789 - selectorWidth - 10, 40, selectorWidth, this.field_22790 - 80, this.datasets, this::onDatasetChanged);
        this.method_37063((class_364)this.datasetSelector);
        this.statisticsPanel = new StatisticsPanel(this.field_22787, 10, 40, 250, this.field_22790 - 80, this.datasets);
        this.statisticsPanel.field_22764 = false;
        this.method_37063((class_364)this.statisticsPanel);
        int chartX = this.showStatistics ? 270 : 10;
        int chartW = this.field_22789 - chartX - selectorWidth - 30;
        this.chartRenderer = new ChartRenderer(this.field_22793, chartX, 40, chartW, this.field_22790 - 80);
        this.reloadData();
    }

    private void addDataset(class_2960 statId, class_2561 displayName) {
        List<HistoryManager.DataPoint> history = HistoryManager.getHistory(statId);
        if (history.isEmpty()) {
            return;
        }
        long cutoffTime = System.currentTimeMillis() - this.timeRange.milliseconds;
        ArrayList<ChartDataset.DataPoint> filteredData = new ArrayList<ChartDataset.DataPoint>();
        for (HistoryManager.DataPoint dp : history) {
            if (this.timeRange != TimeRange.ALL && dp.timestamp < cutoffTime) continue;
            filteredData.add(new ChartDataset.DataPoint(dp.timestamp, dp.value));
        }
        if (filteredData.isEmpty()) {
            return;
        }
        int color = COLORS[this.datasets.size() % COLORS.length];
        ChartDataset dataset = new ChartDataset(statId, displayName, filteredData, color);
        dataset.setStyle(this.currentChartType);
        this.datasets.add(dataset);
    }

    private void openDatasetPicker() {
        this.field_22787.method_1507((class_437)new DatasetPickerScreen(this, this::onDatasetPicked));
    }

    private void onDatasetPicked(class_2960 statId, class_2561 displayName) {
        this.addDataset(statId, displayName);
        if (this.datasetSelector != null) {
            this.datasetSelector.refresh();
        }
        this.field_22787.method_1507((class_437)this);
    }

    private void onDatasetChanged() {
    }

    private void reloadData() {
        List<class_2960> statIds = this.datasets.stream().map(ChartDataset::getStatId).toList();
        List<class_2561> names = this.datasets.stream().map(ChartDataset::getDisplayName).toList();
        this.datasets.clear();
        if (!statIds.isEmpty()) {
            Map<class_2960, List<HistoryManager.DataPoint>> historyBatch = HistoryManager.getHistoryBatch(statIds);
            long cutoffTime = System.currentTimeMillis() - this.timeRange.milliseconds;
            for (int i = 0; i < statIds.size(); ++i) {
                class_2960 statId = statIds.get(i);
                class_2561 displayName = names.get(i);
                List history = historyBatch.getOrDefault(statId, new ArrayList());
                if (history.isEmpty()) continue;
                ArrayList<ChartDataset.DataPoint> filteredData = new ArrayList<ChartDataset.DataPoint>();
                for (HistoryManager.DataPoint dp : history) {
                    if (this.timeRange != TimeRange.ALL && dp.timestamp < cutoffTime) continue;
                    filteredData.add(new ChartDataset.DataPoint(dp.timestamp, dp.value));
                }
                if (filteredData.isEmpty()) continue;
                int color = COLORS[this.datasets.size() % COLORS.length];
                ChartDataset dataset = new ChartDataset(statId, displayName, filteredData, color);
                dataset.setStyle(this.currentChartType);
                this.datasets.add(dataset);
            }
        }
        if (this.datasetSelector != null) {
            this.datasetSelector.refresh();
        }
    }

    private void openAnalysis() {
        if (this.datasets.isEmpty()) {
            return;
        }
        this.field_22787.method_1507((class_437)new AnalysisScreen(this, this.datasets));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        if (this.chartRenderer != null) {
            int chartX = this.showStatistics && this.statisticsPanel != null && this.statisticsPanel.field_22764 ? 270 : 10;
            int chartW = this.field_22789 - chartX - 220;
            this.chartRenderer = new ChartRenderer(this.field_22793, chartX, 40, chartW, this.field_22790 - 80);
            this.chartRenderer.render(graphics, this.datasets, mouseX, mouseY);
        }
        if (!this.datasets.isEmpty()) {
            String info = this.datasets.size() + " dataset" + (this.datasets.size() > 1 ? "s" : "") + " | " + this.datasets.stream().mapToInt(d -> d.getData().size()).sum() + " data points";
            graphics.method_25303(this.field_22793, info, 10, this.field_22790 - 40, 0x888888);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private String formatChartType(ChartDataset.ChartStyle style) {
        return switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case ChartDataset.ChartStyle.LINE -> "Line";
            case ChartDataset.ChartStyle.BAR -> "Bar";
            case ChartDataset.ChartStyle.AREA -> "Area";
            case ChartDataset.ChartStyle.SCATTER -> "Scatter";
            case ChartDataset.ChartStyle.STEP -> "Step";
        };
    }

    private ChartDataset.ChartStyle getNextChartType(ChartDataset.ChartStyle current) {
        ChartDataset.ChartStyle[] values = ChartDataset.ChartStyle.values();
        int nextIndex = (current.ordinal() + 1) % values.length;
        return values[nextIndex];
    }

    private static enum TimeRange {
        HOUR("1 Hour", 3600000L),
        DAY("24 Hours", 86400000L),
        WEEK("7 Days", 604800000L),
        MONTH("30 Days", 2592000000L),
        ALL("All Time", Long.MAX_VALUE);

        final String label;
        final long milliseconds;

        private TimeRange(String label, long milliseconds) {
            this.label = label;
            this.milliseconds = milliseconds;
        }

        TimeRange next() {
            return TimeRange.values()[(this.ordinal() + 1) % TimeRange.values().length];
        }
    }

    private static class DatasetPickerScreen
    extends class_437 {
        private final class_437 parent;
        private final BiConsumer<class_2960, class_2561> onPick;
        private StatPickerListWidget listWidget;

        protected DatasetPickerScreen(class_437 parent, BiConsumer<class_2960, class_2561> onPick) {
            super((class_2561)class_2561.method_43471((String)"screen.beautiful_statistics_screen.select_dataset"));
            this.parent = parent;
            this.onPick = onPick;
        }

        protected void method_25426() {
            super.method_25426();
            List<class_2960> statsWithHistory = HistoryManager.getStatsWithHistory();
            this.listWidget = new StatPickerListWidget(this.field_22787, this.field_22789, this.field_22790 - 80, 40, this.field_22790 - 40, 25);
            for (class_2960 statId : statsWithHistory) {
                StatEntry entry = StatDataManager.getStatEntry(statId);
                if (entry == null) continue;
                this.listWidget.addStat(statId, entry);
            }
            this.method_37063((class_364)this.listWidget);
            class_4185 cancel = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.cancel"), b -> {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(this.parent);
                }
            }).method_46434((this.field_22789 - 200) / 2, this.field_22790 - 30, 200, 20).method_46431();
            this.method_37063((class_364)cancel);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            this.method_25420(graphics);
            graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
            super.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        private class StatPickerListWidget
        extends class_4280<StatEntry> {
            public StatPickerListWidget(class_310 minecraft, int width, int height, int y0, int y1, int itemHeight) {
                super(minecraft, width, height, y0, y1, itemHeight);
            }

            public void addStat(class_2960 statId, org.texboobcat.beautiful_statistics_screen.api.StatEntry entry) {
                this.method_25321((class_350.class_351)new StatEntry(statId, entry));
            }

            public class StatEntry
            extends class_4280.class_4281<StatEntry> {
                private final class_2960 statId;
                private final org.texboobcat.beautiful_statistics_screen.api.StatEntry entry;

                public StatEntry(class_2960 statId, org.texboobcat.beautiful_statistics_screen.api.StatEntry entry) {
                    this.statId = statId;
                    this.entry = entry;
                }

                public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                    if (isHovering) {
                        graphics.method_25294(left, top, left + width, top + height, 0x40FFFFFF);
                    }
                    class_2561 displayName = this.entry.getDisplayName();
                    graphics.method_27535(DatasetPickerScreen.this.field_22793, displayName, left + 5, top + (height - 8) / 2, 0xFFFFFF);
                }

                public boolean method_25402(double mouseX, double mouseY, int button) {
                    DatasetPickerScreen.this.onPick.accept(this.statId, this.entry.getDisplayName());
                    return true;
                }

                public class_2561 method_37006() {
                    return this.entry.getDisplayName();
                }
            }
        }
    }

    private static class AnalysisScreen
    extends class_437 {
        private final class_437 parent;
        private final List<ChartDataset> datasets;

        protected AnalysisScreen(class_437 parent, List<ChartDataset> datasets) {
            super((class_2561)class_2561.method_43470((String)"Statistical Analysis"));
            this.parent = parent;
            this.datasets = datasets;
        }

        protected void method_25426() {
            super.method_25426();
            class_4185 back = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), b -> {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(this.parent);
                }
            }).method_46434((this.field_22789 - 200) / 2, this.field_22790 - 30, 200, 20).method_46431();
            this.method_37063((class_364)back);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            this.method_25420(graphics);
            graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
            int y = 50;
            for (ChartDataset dataset : this.datasets) {
                if (!dataset.isVisible()) continue;
                ChartDataset.DatasetStatistics stats = dataset.getStatistics();
                ChartDataset.TrendLine trend = dataset.calculateTrendLine();
                graphics.method_25303(this.field_22793, dataset.getDisplayName().getString(), 20, y, dataset.getColor());
                graphics.method_25303(this.field_22793, "  Min: " + stats.min(), 30, y += 15, 0xCCCCCC);
                graphics.method_25303(this.field_22793, "  Max: " + stats.max(), 30, y += 12, 0xCCCCCC);
                graphics.method_25303(this.field_22793, "  Mean: " + String.format("%.2f", stats.mean()), 30, y += 12, 0xCCCCCC);
                graphics.method_25303(this.field_22793, "  Median: " + stats.median(), 30, y += 12, 0xCCCCCC);
                graphics.method_25303(this.field_22793, "  Std Dev: " + String.format("%.2f", stats.standardDeviation()), 30, y += 12, 0xCCCCCC);
                graphics.method_25303(this.field_22793, "  Range: " + stats.getRange(), 30, y += 12, 0xCCCCCC);
                y += 12;
                if (trend != null) {
                    String trendDirection = trend.slope() > 0.0 ? "\u2191 Increasing" : (trend.slope() < 0.0 ? "\u2193 Decreasing" : "\u2192 Stable");
                    graphics.method_25303(this.field_22793, "  Trend: " + trendDirection, 30, y, 0xFFAA00);
                    graphics.method_25303(this.field_22793, "  Slope: " + String.format("%.4f", trend.slope()), 30, y += 12, 0xCCCCCC);
                    y += 12;
                }
                y += 10;
            }
            super.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }
}

