/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.BlockEvaluator;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;

public class ConditionDebuggerPanel {
    private final class_310 minecraft;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean visible = true;
    private ConditionalBlock rootBlock;
    private boolean lastResult = false;
    private List<EvaluationResult> blockResults = new ArrayList<EvaluationResult>();

    public ConditionDebuggerPanel(class_310 minecraft, int x, int y, int width, int height) {
        this.minecraft = minecraft;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setRootBlock(ConditionalBlock block) {
        this.rootBlock = block;
        this.evaluateBlocks();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    private void evaluateBlocks() {
        this.blockResults.clear();
        if (this.rootBlock == null || this.minecraft.field_1724 == null) {
            this.lastResult = false;
            return;
        }
        BlockEvaluator.EvaluationTrace trace = BlockEvaluator.evaluateWithTrace(this.rootBlock, (class_1657)this.minecraft.field_1724);
        this.lastResult = trace.getFinalResult();
        for (BlockEvaluator.TraceStep step : trace.getSteps()) {
            this.blockResults.add(new EvaluationResult(this.extractBlockType(step.description), step.description, step.result, step.depth));
        }
    }

    private String extractBlockType(String description) {
        int colonIndex = description.indexOf(58);
        if (colonIndex > 0) {
            return description.substring(0, colonIndex);
        }
        return description;
    }

    public void render(class_332 graphics, class_327 font, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        this.evaluateBlocks();
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -300279270);
        graphics.method_49601(this.x, this.y, this.width, this.height, -11184811);
        graphics.method_25303(font, class_2561.method_43471((String)"gui.beautiful_statistics_screen.debugger.title").getString(), this.x + 10, this.y + 10, 0x55FF55);
        int currentY = this.y + 25;
        class_746 player = this.minecraft.field_1724;
        if (player != null && player.method_37908() != null) {
            graphics.method_25303(font, class_2561.method_43471((String)"gui.beautiful_statistics_screen.debugger.current_state").getString(), this.x + 10, currentY, 0xFFFFFF);
            String biome = this.getCurrentBiome(player);
            graphics.method_25303(font, class_2561.method_43469((String)"gui.beautiful_statistics_screen.debugger.biome", (Object[])new Object[]{biome}).getString(), this.x + 15, currentY += 12, 0xAAAAAA);
            String dimension = this.getCurrentDimension(player);
            graphics.method_25303(font, class_2561.method_43469((String)"gui.beautiful_statistics_screen.debugger.dimension", (Object[])new Object[]{dimension}).getString(), this.x + 15, currentY += 11, 0xAAAAAA);
            int yLevel = player.method_24515().method_10264();
            graphics.method_25303(font, class_2561.method_43469((String)"gui.beautiful_statistics_screen.debugger.y_level", (Object[])new Object[]{yLevel}).getString(), this.x + 15, currentY += 11, 0xAAAAAA);
            int light = player.method_37908().method_22339(player.method_24515());
            graphics.method_25303(font, class_2561.method_43469((String)"gui.beautiful_statistics_screen.debugger.light", (Object[])new Object[]{light}).getString(), this.x + 15, currentY += 11, 0xAAAAAA);
            String time = this.getCurrentTime(player.method_37908());
            graphics.method_25303(font, class_2561.method_43469((String)"gui.beautiful_statistics_screen.debugger.time", (Object[])new Object[]{time}).getString(), this.x + 15, currentY += 11, 0xAAAAAA);
            String weather = this.getCurrentWeather(player.method_37908());
            graphics.method_25303(font, class_2561.method_43469((String)"gui.beautiful_statistics_screen.debugger.weather", (Object[])new Object[]{weather}).getString(), this.x + 15, currentY += 11, 0xAAAAAA);
            currentY += 15;
        }
        String resultText = this.lastResult ? class_2561.method_43471((String)"gui.beautiful_statistics_screen.debugger.true_track").getString() : class_2561.method_43471((String)"gui.beautiful_statistics_screen.debugger.false_no_track").getString();
        int resultColor = this.lastResult ? 0x55FF55 : 0xFF5555;
        graphics.method_25303(font, class_2561.method_43471((String)"gui.beautiful_statistics_screen.debugger.result").getString(), this.x + 10, currentY, 0xFFFFFF);
        graphics.method_25303(font, resultText, this.x + 15, currentY += 12, resultColor);
        currentY += 15;
        if (!this.blockResults.isEmpty()) {
            graphics.method_25303(font, class_2561.method_43471((String)"gui.beautiful_statistics_screen.debugger.block_by_block").getString(), this.x + 10, currentY, 0xFFFFFF);
            currentY += 12;
            for (EvaluationResult result : this.blockResults) {
                if (currentY + 11 > this.y + this.height - 10) {
                    graphics.method_25303(font, "\u00a77...", this.x + 15, currentY, 0x888888);
                    break;
                }
                String icon = result.result ? "\u2713" : "\u2717";
                int color = result.result ? 0x55FF55 : 0xFF5555;
                int indent = this.x + 15 + result.depth * 10;
                String text = icon + " " + result.blockType + ": " + result.conditionText;
                if (font.method_1727(text) > this.width - 30) {
                    text = text.substring(0, Math.min(text.length(), 30)) + "...";
                }
                graphics.method_25303(font, text, indent, currentY, color);
                currentY += 11;
            }
        }
        if (this.rootBlock == null || this.rootBlock.getChildren().isEmpty()) {
            graphics.method_25303(font, class_2561.method_43471((String)"gui.beautiful_statistics_screen.debugger.no_blocks").getString(), this.x + 15, currentY, 0x888888);
        }
    }

    private String getCurrentBiome(class_746 player) {
        try {
            class_2338 pos = player.method_24515();
            class_6880 biomeHolder = player.method_37908().method_23753(pos);
            class_2960 biomeId = biomeHolder.method_40230().map(key -> key.method_29177()).orElse(new class_2960("minecraft", "unknown"));
            return biomeId.toString();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private String getCurrentDimension(class_746 player) {
        try {
            return player.method_37908().method_27983().method_29177().toString();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private String getCurrentTime(class_1937 level) {
        long time = level.method_8532() % 24000L;
        if (time >= 0L && time < 6000L) {
            return "morning";
        }
        if (time >= 6000L && time < 12000L) {
            return "day";
        }
        if (time >= 12000L && time < 18000L) {
            return "evening";
        }
        return "night";
    }

    private String getCurrentWeather(class_1937 level) {
        if (level.method_8546()) {
            return "thunder";
        }
        if (level.method_8419()) {
            return "rain";
        }
        return "clear";
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    private static class EvaluationResult {
        final String blockType;
        final String conditionText;
        final boolean result;
        final int depth;

        EvaluationResult(String blockType, String conditionText, boolean result, int depth) {
            this.blockType = blockType;
            this.conditionText = conditionText;
            this.result = result;
            this.depth = depth;
        }
    }
}

