/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConditionDetailScreen;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ComparisonOperator;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionType;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.LogicMode;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class ConditionEditorScreen
extends class_437 {
    private final class_437 parent;
    private final ConditionGroup conditionGroup;
    private final Consumer<ConditionGroup> onSave;
    private ConditionListWidget conditionList;
    private class_5676<LogicMode> logicModeButton;
    private class_4185 addButton;
    private class_4185 doneButton;
    private class_4185 cancelButton;
    private StatCondition selectedCondition;

    public ConditionEditorScreen(class_437 parent, ConditionGroup conditionGroup, Consumer<ConditionGroup> onSave) {
        super((class_2561)class_2561.method_43470((String)"Edit Conditions"));
        this.parent = parent;
        this.conditionGroup = conditionGroup != null ? conditionGroup : new ConditionGroup();
        this.onSave = onSave;
    }

    protected void method_25426() {
        super.method_25426();
        int topY = 40;
        int centerX = this.field_22789 / 2;
        this.logicModeButton = class_5676.method_32606(mode -> class_2561.method_43470((String)mode.getDisplayName())).method_32624((Object[])LogicMode.values()).method_32619((Object)this.conditionGroup.getLogicMode()).method_32617(centerX - 100, topY, 200, 20, (class_2561)class_2561.method_43470((String)"Logic Mode"), (btn, value) -> this.conditionGroup.setLogicMode((LogicMode)((Object)value)));
        this.method_37063((class_364)this.logicModeButton);
        int listTop = topY + 30;
        int listHeight = this.field_22790 - listTop - 70;
        this.conditionList = new ConditionListWidget(this.field_22787, this.field_22789 - 40, listHeight, listTop, this.field_22790 - 70, 35);
        this.conditionList.setConditions(this.conditionGroup.getConditions());
        this.method_37063((class_364)this.conditionList);
        int bottomY = this.field_22790 - 35;
        int buttonWidth = 100;
        this.addButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add Condition"), btn -> this.addNewCondition()).method_46434(centerX - buttonWidth * 2 - 10, bottomY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.addButton);
        class_4185 editButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit"), btn -> this.editSelectedCondition()).method_46434(centerX - buttonWidth - 5, bottomY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)editButton);
        class_4185 removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Remove"), btn -> this.removeSelectedCondition()).method_46434(centerX + 5, bottomY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)removeButton);
        this.doneButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), btn -> this.save()).method_46434(centerX + buttonWidth + 10, bottomY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.doneButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 - 110, 10, 100, 20).method_46431();
        this.method_37063((class_364)this.cancelButton);
    }

    private void addNewCondition() {
        StatCondition newCondition = new StatCondition(ConditionType.BIOME, ComparisonOperator.EQUALS, "minecraft:plains");
        this.field_22787.method_1507((class_437)new ConditionDetailScreen(this, newCondition, condition -> {
            this.conditionGroup.addCondition((StatCondition)condition);
            this.refreshList();
        }));
    }

    private void editSelectedCondition() {
        StatCondition selected = this.conditionList.getSelectedCondition();
        if (selected != null) {
            this.field_22787.method_1507((class_437)new ConditionDetailScreen(this, selected, condition -> this.refreshList()));
        }
    }

    private void removeSelectedCondition() {
        int index;
        StatCondition selected = this.conditionList.getSelectedCondition();
        if (selected != null && (index = this.conditionGroup.getConditions().indexOf(selected)) >= 0) {
            this.conditionGroup.removeCondition(index);
            this.refreshList();
        }
    }

    private void refreshList() {
        this.conditionList.setConditions(this.conditionGroup.getConditions());
    }

    private void save() {
        this.onSave.accept(this.conditionGroup);
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        String instructions = "Configure when this stat should track";
        graphics.method_25300(this.field_22793, instructions, this.field_22789 / 2, 65, 0x888888);
        int count = this.conditionGroup.getConditions().size();
        String countText = count + " condition" + (count == 1 ? "" : "s");
        graphics.method_25303(this.field_22793, countText, 20, 75, 0xAAAAAA);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private class ConditionListWidget
    extends class_4280<ConditionEntry> {
        private StatCondition selectedCondition;

        public ConditionListWidget(class_310 minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
        }

        public void setConditions(List<StatCondition> conditions) {
            this.method_25339();
            for (StatCondition condition : conditions) {
                this.method_25321((class_350.class_351)new ConditionEntry(condition));
            }
        }

        public StatCondition getSelectedCondition() {
            return this.selectedCondition;
        }

        public class ConditionEntry
        extends class_4280.class_4281<ConditionEntry> {
            private final StatCondition condition;

            public ConditionEntry(StatCondition condition) {
                this.condition = condition;
            }

            public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                boolean selected;
                boolean bl = selected = this.condition == ConditionListWidget.this.selectedCondition;
                int bgColor = selected ? -2141891243 : (isHovering ? 0x40FFFFFF : 0x20000000);
                graphics.method_25294(left, top, left + width, top + height, bgColor);
                int textX = left + 5;
                if (this.condition.isNegated()) {
                    graphics.method_25303(((ConditionListWidget)ConditionListWidget.this).field_22740.field_1772, "\u00a7cNOT", textX, top + 5, 0xFFFFFF);
                    textX += 30;
                }
                String typeText = this.condition.getType().getDisplayName();
                graphics.method_25303(((ConditionListWidget)ConditionListWidget.this).field_22740.field_1772, typeText, textX, top + 5, 0xFFFF55);
                String opText = this.condition.getOperator().getSymbol() + " " + this.condition.getValue();
                graphics.method_25303(((ConditionListWidget)ConditionListWidget.this).field_22740.field_1772, opText, textX, top + 18, 0xAAAAAA);
                Object desc = this.condition.getType().getDescription();
                if (((String)desc).length() > 60) {
                    desc = ((String)desc).substring(0, 57) + "...";
                }
                graphics.method_25303(((ConditionListWidget)ConditionListWidget.this).field_22740.field_1772, "\u00a77" + (String)desc, left + width - ((ConditionListWidget)ConditionListWidget.this).field_22740.field_1772.method_1727((String)desc) - 5, top + 5, 0xAAAAAA);
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)this.condition.toString());
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                ConditionListWidget.this.selectedCondition = this.condition;
                return true;
            }
        }
    }
}

