/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConditionEditorScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.IconPickerScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.ScratchBlockEditorScreenV2;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatImportExportScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatPreviewScreen;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class CustomStatEditorScreen
extends class_437 {
    private final class_437 parent;
    private final CustomStatDefinition stat;
    private final boolean isNew;
    private String pendingIconValue = null;
    private class_342 nameField;
    private class_342 descriptionField;
    private class_342 iconField;
    private class_342 categoryField;
    private class_342 targetsField;
    private class_5676<CustomStatDefinition.TrackingType> trackingTypeButton;
    private class_5676<CustomStatDefinition.AggregationType> aggregationTypeButton;
    private class_5676<CustomStatDefinition.FormatType> formatTypeButton;
    private class_4185 saveButton;
    private class_4185 cancelButton;
    private class_4185 addConditionButton;
    private class_4185 previewButton;
    private int scrollOffset = 0;
    private static final int CONTENT_HEIGHT = 550;
    private static final int SCROLL_SPEED = 10;
    private String errorMessage = null;
    private long errorMessageTime = 0L;
    private static final long ERROR_DISPLAY_DURATION = 3000L;

    public CustomStatEditorScreen(class_437 parent, CustomStatDefinition stat) {
        super((class_2561)class_2561.method_43471((String)"screen.beautiful_statistics_screen.custom_stat_editor"));
        this.parent = parent;
        this.isNew = stat == null;
        this.stat = stat != null ? stat : new CustomStatDefinition();
    }

    protected void method_25426() {
        int leftX = this.field_22789 / 2 - 150;
        int rightX = this.field_22789 / 2 + 10;
        int labelWidth = 140;
        int fieldWidth = 140;
        int currentY = 40 - this.scrollOffset;
        int lineHeight = 30;
        this.nameField = new class_342(this.field_22793, rightX, currentY, fieldWidth, 20, (class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.name"));
        this.nameField.method_1880(50);
        this.nameField.method_1852(this.stat.getName() != null ? this.stat.getName() : "");
        this.method_37063((class_364)this.nameField);
        this.descriptionField = new class_342(this.field_22793, rightX, currentY += lineHeight, fieldWidth, 20, (class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.description"));
        this.descriptionField.method_1880(200);
        this.descriptionField.method_1852(this.stat.getDescription() != null ? this.stat.getDescription() : "");
        this.method_37063((class_364)this.descriptionField);
        this.categoryField = new class_342(this.field_22793, rightX, currentY += lineHeight, fieldWidth, 20, (class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.category"));
        this.categoryField.method_1880(30);
        this.categoryField.method_1852(this.stat.getCategory() != null ? this.stat.getCategory() : class_2561.method_43471((String)"gui.beautiful_statistics_screen.default_category").getString());
        this.method_37063((class_364)this.categoryField);
        int iconFieldWidth = fieldWidth - 25;
        this.iconField = new class_342(this.field_22793, rightX, currentY += lineHeight, iconFieldWidth, 20, (class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.icon"));
        this.iconField.method_1880(100);
        String iconValue = this.pendingIconValue != null ? this.pendingIconValue : (this.stat.getIcon() != null ? this.stat.getIcon() : class_2561.method_43471((String)"gui.beautiful_statistics_screen.icon_hint").getString());
        this.iconField.method_1852(iconValue);
        this.iconField.method_47404((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.icon_hint"));
        this.method_37063((class_364)this.iconField);
        System.out.println("CustomStatEditorScreen.init(): Icon field set to: " + iconValue);
        class_4185 iconPickerButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.ellipsis"), button -> this.openIconPicker()).method_46434(rightX + iconFieldWidth + 5, currentY, 20, 20).method_46431();
        this.method_37063((class_364)iconPickerButton);
        this.trackingTypeButton = class_5676.method_32606(type -> class_2561.method_43470((String)type.getDisplayName())).method_32624((Object[])CustomStatDefinition.TrackingType.values()).method_32619((Object)(this.stat.getTrackingType() != null ? this.stat.getTrackingType() : CustomStatDefinition.TrackingType.BLOCK_MINED)).method_35723(rightX, currentY += lineHeight, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Tracking Type"));
        this.method_37063((class_364)this.trackingTypeButton);
        this.targetsField = new class_342(this.field_22793, rightX, currentY += lineHeight, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Targets"));
        this.targetsField.method_1880(500);
        this.targetsField.method_1852(String.join((CharSequence)", ", this.stat.getTargets()));
        this.targetsField.method_47404((class_2561)class_2561.method_43470((String)"minecraft:stone, minecraft:dirt"));
        this.method_37063((class_364)this.targetsField);
        this.aggregationTypeButton = class_5676.method_32606(type -> class_2561.method_43470((String)type.getDisplayName())).method_32624((Object[])CustomStatDefinition.AggregationType.values()).method_32619((Object)(this.stat.getAggregationType() != null ? this.stat.getAggregationType() : CustomStatDefinition.AggregationType.SUM)).method_35723(rightX, currentY += lineHeight, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Aggregation"));
        this.method_37063((class_364)this.aggregationTypeButton);
        this.formatTypeButton = class_5676.method_32606(type -> class_2561.method_43470((String)type.getDisplayName())).method_32624((Object[])CustomStatDefinition.FormatType.values()).method_32619((Object)(this.stat.getFormatType() != null ? this.stat.getFormatType() : CustomStatDefinition.FormatType.NUMBER)).method_35723(rightX, currentY += lineHeight, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Format"));
        this.method_37063((class_364)this.formatTypeButton);
        int condButtonWidth = (fieldWidth - 5) / 2;
        this.addConditionButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.conditions"), button -> this.addCondition()).method_46434(rightX, currentY += lineHeight + 10, condButtonWidth, 20).method_46431();
        this.method_37063((class_364)this.addConditionButton);
        class_4185 scratchButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch_blocks"), button -> this.openScratchEditor()).method_46434(rightX + condButtonWidth + 5, currentY, condButtonWidth, 20).method_46431();
        this.method_37063((class_364)scratchButton);
        currentY += lineHeight;
        int buttonY = this.field_22790 - 40;
        int buttonWidth = 100;
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.save"), button -> this.saveStat()).method_46434(this.field_22789 / 2 - buttonWidth - 5, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.cancel"), button -> this.cancel()).method_46434(this.field_22789 / 2 + 5, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.cancelButton);
        class_4185 exportButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.import_export"), button -> this.exportStat()).method_46434(this.field_22789 - 220, 10, 100, 20).method_46431();
        this.method_37063((class_364)exportButton);
        this.previewButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.preview"), button -> this.previewStat()).method_46434(this.field_22789 - 110, 10, 100, 20).method_46431();
        this.method_37063((class_364)this.previewButton);
    }

    private void addCondition() {
        if (this.stat.getConditionGroup() == null) {
            this.stat.setConditionGroup(new ConditionGroup());
        }
        this.field_22787.method_1507((class_437)new ConditionEditorScreen(this, this.stat.getConditionGroup(), group -> this.stat.setConditionGroup((ConditionGroup)group)));
    }

    private void openScratchEditor() {
        ConditionalBlock block = this.stat.getConditionalBlock();
        if (block == null) {
            block = this.stat.getConditionGroup() != null ? ConditionalBlock.fromConditionGroup(this.stat.getConditionGroup()) : new ConditionalBlock();
        }
        this.field_22787.method_1507((class_437)new ScratchBlockEditorScreenV2(this, block, resultBlock -> this.stat.setConditionalBlock((ConditionalBlock)resultBlock)));
    }

    private void saveStat() {
        String name = this.nameField.method_1882().trim();
        if (name.isEmpty()) {
            this.showError("Stat name cannot be empty!");
            return;
        }
        this.stat.setName(name);
        this.stat.setDescription(this.descriptionField.method_1882().trim());
        this.stat.setIcon(this.iconField.method_1882().trim());
        this.stat.setCategory(this.categoryField.method_1882().trim());
        this.stat.setTrackingType((CustomStatDefinition.TrackingType)((Object)this.trackingTypeButton.method_32603()));
        this.stat.setAggregationType((CustomStatDefinition.AggregationType)((Object)this.aggregationTypeButton.method_32603()));
        this.stat.setFormatType((CustomStatDefinition.FormatType)((Object)this.formatTypeButton.method_32603()));
        String targetsStr = this.targetsField.method_1882().trim();
        if (!targetsStr.isEmpty()) {
            ArrayList<String> targets = new ArrayList<String>(Arrays.asList(targetsStr.split("\\s*,\\s*")));
            this.stat.setTargets(targets);
        }
        if (this.isNew) {
            CustomStatManager.updateCustomStat(this.stat);
        } else {
            CustomStatManager.updateCustomStat(this.stat);
        }
        this.pendingIconValue = null;
        this.field_22787.method_1507(this.parent);
    }

    private void cancel() {
        this.pendingIconValue = null;
        this.field_22787.method_1507(this.parent);
    }

    private void exportStat() {
        this.field_22787.method_1507((class_437)new StatImportExportScreen(this, this.stat));
    }

    private void previewStat() {
        CustomStatDefinition previewStat = new CustomStatDefinition();
        previewStat.setName(this.nameField.method_1882());
        previewStat.setDescription(this.descriptionField.method_1882());
        previewStat.setIcon(this.iconField.method_1882());
        previewStat.setCategory(this.categoryField.method_1882());
        previewStat.setTrackingType((CustomStatDefinition.TrackingType)((Object)this.trackingTypeButton.method_32603()));
        previewStat.setAggregationType((CustomStatDefinition.AggregationType)((Object)this.aggregationTypeButton.method_32603()));
        previewStat.setFormatType((CustomStatDefinition.FormatType)((Object)this.formatTypeButton.method_32603()));
        this.field_22787.method_1507((class_437)new StatPreviewScreen(this, previewStat));
    }

    private void openIconPicker() {
        this.field_22787.method_1507((class_437)new IconPickerScreen(this, this.iconField.method_1882(), this::onIconSelected));
    }

    private void onIconSelected(String icon) {
        System.out.println("CustomStatEditorScreen: onIconSelected called with: " + icon);
        this.pendingIconValue = icon;
        if (this.iconField != null) {
            this.iconField.method_1852(icon);
            System.out.println("CustomStatEditorScreen: Set iconField to: " + icon);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        graphics.method_44379(0, 30, this.field_22789, this.field_22790 - 50);
        int leftX = this.field_22789 / 2 - 150;
        int rightX = this.field_22789 / 2 + 10;
        int currentY = 40 - this.scrollOffset;
        int lineHeight = 30;
        graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.name").getString(), leftX, currentY + 6, 0xFFFFFF);
        graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.description").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.category").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.icon").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.tracking_type").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.targets").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.aggregation").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.format").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.conditions").getString(), leftX, (currentY += lineHeight + 10) + 6, 0xFFFFFF);
        int conditionY = currentY += lineHeight;
        if (this.stat.getConditionalBlock() != null) {
            ConditionalBlock block = this.stat.getConditionalBlock();
            graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.visual_mode").getString(), leftX + 10, conditionY, 0xFFAA00);
            int totalBlocks = block.getTotalBlockCount() - 1;
            String blockKey = totalBlocks == 1 ? "gui.beautiful_statistics_screen.block_count_singular" : "gui.beautiful_statistics_screen.block_count_plural";
            graphics.method_25303(this.field_22793, class_2561.method_43469((String)blockKey, (Object[])new Object[]{totalBlocks}).getString(), leftX + 10, conditionY += 12, 0xAAAAAA);
            conditionY += 12;
        } else if (this.stat.getConditionGroup() != null && !this.stat.getConditionGroup().isEmpty()) {
            ConditionGroup group = this.stat.getConditionGroup();
            graphics.method_25303(this.field_22793, "\u00a7aMode: List", leftX + 10, conditionY, 0x55FF55);
            graphics.method_25303(this.field_22793, "Logic: " + group.getLogicMode().getDisplayName(), leftX + 10, conditionY += 12, 0x88FF88);
            conditionY += 12;
            for (StatCondition condition : group.getConditions()) {
                String prefix = condition.isNegated() ? "NOT " : "";
                String condText = prefix + condition.getType().getDisplayName() + " " + condition.getOperator().getSymbol() + " " + condition.getValue();
                graphics.method_25303(this.field_22793, "\u2022 " + condText, leftX + 10, conditionY, 0xAAAAAA);
                conditionY += 12;
            }
        } else {
            graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.no_conditions").getString(), leftX + 10, conditionY, 0x888888);
        }
        if (this.trackingTypeButton.method_25370()) {
            String helpText = ((CustomStatDefinition.TrackingType)((Object)this.trackingTypeButton.method_32603())).getDescription();
            graphics.method_25303(this.field_22793, helpText, leftX, this.field_22790 - 60, 0x888888);
        }
        graphics.method_44380();
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.targetsField.method_25405((double)mouseX, (double)mouseY)) {
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            tooltip.add(class_2561.method_43471((String)"gui.beautiful_statistics_screen.tooltip.targets"));
            tooltip.add(class_2561.method_43471((String)"gui.beautiful_statistics_screen.tooltip.targets_example"));
            tooltip.add(class_2561.method_43471((String)"gui.beautiful_statistics_screen.tooltip.targets_wildcard"));
            graphics.method_51434(this.field_22793, tooltip, mouseX, mouseY);
        }
        if (this.errorMessage != null) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.errorMessageTime < 3000L) {
                int errorX = this.field_22789 / 2;
                int errorY = this.field_22790 - 60;
                int textWidth = this.field_22793.method_1727(this.errorMessage);
                graphics.method_25294(errorX - textWidth / 2 - 10, errorY - 5, errorX + textWidth / 2 + 10, errorY + 15, -587202560);
                graphics.method_49601(errorX - textWidth / 2 - 10, errorY - 5, textWidth + 20, 20, -65536);
                graphics.method_25300(this.field_22793, "\u00a7c" + this.errorMessage, errorX, errorY, 0xFFFFFF);
            } else {
                this.errorMessage = null;
            }
        }
    }

    private void showError(String message) {
        this.errorMessage = message;
        this.errorMessageTime = System.currentTimeMillis();
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int visibleHeight = this.field_22790 - 80;
        int maxScroll = Math.max(0, 550 - visibleHeight);
        this.scrollOffset = (int)Math.max(0.0, Math.min((double)maxScroll, (double)this.scrollOffset - delta * 10.0));
        this.method_41843();
        return true;
    }

    public void method_25419() {
        this.pendingIconValue = null;
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }
}

