/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.client.gui.AdvancedChartScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConfigScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.CustomStatScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatGridWidget;
import org.texboobcat.beautiful_statistics_screen.client.gui.TextStatsScreen;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatCategoryRegistry;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;

public class ImprovedStatsScreen
extends class_437 {
    private static final int TAB_WIDTH = 120;
    private static final int TAB_HEIGHT = 24;
    private static final int GRID_PADDING = 10;
    private static final int GRID_ITEM_SIZE = 40;
    private static final int GRID_SPACING = 5;
    private final class_437 parent;
    private StatCategory selectedCategory;
    private class_342 searchBox;
    private class_4185 hideZeroButton;
    private StatGridWidget statGrid;
    private boolean hideZero;
    private String searchQuery = "";
    private final List<StatCategory> categories;
    private int scrollOffset = 0;
    private SortMode sortMode = SortMode.NAME_ASC;
    private int tickCounter = 0;

    public ImprovedStatsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.beautiful_statistics_screen.statistics"));
        this.parent = parent;
        this.categories = StatCategoryRegistry.getAllCategories();
        this.hideZero = ModConfig.getClient().hideZeroByDefault;
        if (ModConfig.getClient().rememberLastTab) {
            String lastTab = ModConfig.getClient().lastSelectedTab;
            for (StatCategory category : this.categories) {
                if (!category.getId().method_12832().equals(lastTab)) continue;
                this.selectedCategory = category;
                break;
            }
        }
        if (this.selectedCategory == null && !this.categories.isEmpty()) {
            this.selectedCategory = this.categories.get(0);
        }
    }

    protected void method_25426() {
        super.method_25426();
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            StatDataManager.refresh();
        }
        int topRowY = 30;
        int secondRowY = 55;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        int leftMargin = 140;
        int rightMargin = 10;
        int searchBoxWidth = Math.min(300, this.field_22789 - leftMargin - rightMargin - 200);
        this.searchBox = new class_342(this.field_22793, leftMargin, topRowY, searchBoxWidth, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1852(this.searchQuery);
        this.searchBox.method_1863(this::onSearchChanged);
        this.method_37063((class_364)this.searchBox);
        int topRightX = leftMargin + searchBoxWidth + buttonSpacing;
        int smallButtonWidth = 70;
        this.hideZeroButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)((this.hideZero ? "\u2611" : "\u2610") + " Zero")), btn -> this.toggleHideZero()).method_46434(topRightX, topRowY, smallButtonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.hideZeroButton);
        class_4185 sortButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u21c5 Sort"), btn -> this.cycleSortMode()).method_46434(topRightX + smallButtonWidth + buttonSpacing, topRowY, smallButtonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)sortButton);
        int secondRowButtonWidth = 65;
        int secondRowX = leftMargin;
        class_4185 refreshButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u27f3 Refresh"), btn -> this.refreshStats()).method_46434(secondRowX, secondRowY, secondRowButtonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)refreshButton);
        class_4185 exportButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2b07 Export"), btn -> this.exportSnapshot()).method_46434(secondRowX += secondRowButtonWidth + buttonSpacing, secondRowY, secondRowButtonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)exportButton);
        class_4185 configButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2699 Config"), btn -> this.openConfig()).method_46434(secondRowX += secondRowButtonWidth + buttonSpacing, secondRowY, secondRowButtonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)configButton);
        class_4185 textStatsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2139 Text Stats"), btn -> this.openTextStats()).method_46434(secondRowX += secondRowButtonWidth + buttonSpacing, secondRowY, secondRowButtonWidth + 20, buttonHeight).method_46431();
        this.method_37063((class_364)textStatsButton);
        class_4185 customStatsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u270e Custom"), btn -> this.openCustomStats()).method_46434(secondRowX += secondRowButtonWidth + 20 + buttonSpacing, secondRowY, secondRowButtonWidth + 10, buttonHeight).method_46431();
        this.method_37063((class_364)customStatsButton);
        class_4185 categoryChartsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcca Charts"), btn -> this.openCategoryChart()).method_46434(secondRowX += secondRowButtonWidth + 10 + buttonSpacing, secondRowY, secondRowButtonWidth + 10, buttonHeight).method_46431();
        this.method_37063((class_364)categoryChartsButton);
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), btn -> this.method_25419()).method_46434((this.field_22789 - 200) / 2, this.field_22790 - 30, 200, 20).method_46431();
        this.method_37063((class_364)backButton);
        int gridX = 140;
        int gridY = 85;
        int gridWidth = this.field_22789 - gridX - 20;
        int gridHeight = this.field_22790 - gridY - 40;
        this.statGrid = new StatGridWidget(this.field_22787, gridX, gridY, gridWidth, gridHeight, this::onStatClicked, this::onStatRightClicked);
        this.method_37063((class_364)this.statGrid);
        this.updateDisplayedStats();
    }

    private void onSearchChanged(String query) {
        this.searchQuery = query;
        this.updateDisplayedStats();
    }

    private void toggleHideZero() {
        this.hideZero = !this.hideZero;
        this.hideZeroButton.method_25355((class_2561)class_2561.method_43470((String)((this.hideZero ? "\u2611" : "\u2610") + " Zero")));
        ModConfig.getClient().hideZeroByDefault = this.hideZero;
        ModConfig.saveClientConfig();
        this.updateDisplayedStats();
    }

    private void cycleSortMode() {
        this.sortMode = switch (this.sortMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> SortMode.NAME_DESC;
            case 1 -> SortMode.VALUE_ASC;
            case 2 -> SortMode.VALUE_DESC;
            case 3 -> SortMode.NAME_ASC;
        };
        this.updateDisplayedStats();
    }

    private void refreshStats() {
        StatDataManager.refresh();
        this.updateDisplayedStats();
    }

    private void exportSnapshot() {
        boolean success = SnapshotManager.exportSnapshot(null, true);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            if (success) {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43471((String)"message.beautiful_statistics_screen.snapshot_exported"));
            } else {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"Failed to export snapshot"));
            }
        }
    }

    private void openConfig() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new ConfigScreen(this));
        }
    }

    private void openTextStats() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new TextStatsScreen(this));
        }
    }

    private void openCustomStats() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new CustomStatScreen(this));
        }
    }

    private void openCategoryChart() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new AdvancedChartScreen(this));
        }
    }

    private void updateDisplayedStats() {
        List<StatEntry> stats = StatDataManager.getFilteredStats(this.selectedCategory, this.searchQuery, this.hideZero);
        stats.sort(this.getSortComparator());
        if (this.statGrid != null) {
            this.statGrid.setStats(stats);
        }
    }

    private Comparator<StatEntry> getSortComparator() {
        return switch (this.sortMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Comparator.comparing(e -> e.getDisplayName().getString());
            case 1 -> Comparator.comparing(e -> e.getDisplayName().getString()).reversed();
            case 2 -> Comparator.comparingLong(StatEntry::getValue);
            case 3 -> Comparator.comparingLong(StatEntry::getValue).reversed();
        };
    }

    private void onStatClicked(StatEntry entry) {
    }

    private void onStatRightClicked(StatEntry entry) {
        if (ModConfig.isPinned(entry.getStatId())) {
            ModConfig.removePinnedStat(entry.getStatId());
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.unpinned").method_27693(" ").method_10852(entry.getDisplayName()));
            }
        } else {
            ModConfig.addPinnedStat(entry.getStatId());
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.pinned").method_27693(" ").method_10852(entry.getDisplayName()));
            }
        }
        this.updateDisplayedStats();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        this.renderTabs(graphics, mouseX, mouseY);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.statGrid != null) {
            this.statGrid.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.field_22787 != null && this.field_22787.field_1724 != null && this.tickCounter++ % 20 == 0) {
            StatDataManager.refresh();
            this.updateDisplayedStats();
        }
    }

    private void renderTabs(class_332 graphics, int mouseX, int mouseY) {
        int tabX = 10;
        int tabY = 60;
        for (StatCategory category : this.categories) {
            boolean hovered;
            boolean selected = category.equals(this.selectedCategory);
            boolean bl = hovered = mouseX >= tabX && mouseX < tabX + 120 && mouseY >= tabY && mouseY < tabY + 24;
            int color = selected ? -2143272896 : (hovered ? 0x60404040 : 0x40404040);
            graphics.method_25294(tabX, tabY, tabX + 120, tabY + 24, color);
            if (selected) {
                graphics.method_25294(tabX, tabY, tabX + 2, tabY + 24, -16711681);
            }
            String text = category.getDisplayName().getString();
            int textColor = selected ? 0xFFFFFF : (hovered ? 0xCCCCCC : 0x999999);
            graphics.method_25303(this.field_22793, text, tabX + 5, tabY + 8, textColor);
            tabY += 26;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int tabX = 10;
        int tabY = 60;
        for (StatCategory category : this.categories) {
            if (mouseX >= (double)tabX && mouseX < (double)(tabX + 120) && mouseY >= (double)tabY && mouseY < (double)(tabY + 24)) {
                this.selectCategory(category);
                return true;
            }
            tabY += 26;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void selectCategory(StatCategory category) {
        if (!category.equals(this.selectedCategory)) {
            this.selectedCategory = category;
            this.scrollOffset = 0;
            if (ModConfig.getClient().rememberLastTab) {
                ModConfig.getClient().lastSelectedTab = category.getId().method_12832();
                ModConfig.saveClientConfig();
            }
            StatDataManager.refresh();
            this.updateDisplayedStats();
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.statGrid != null) {
            return this.statGrid.method_25401(mouseX, mouseY, delta);
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return false;
    }

    private static enum SortMode {
        NAME_ASC,
        NAME_DESC,
        VALUE_ASC,
        VALUE_DESC;

    }
}

