/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConditionDetailScreen;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class ScratchBlockEditorScreen
extends class_437 {
    private final class_437 parent;
    private final ConditionalBlock rootBlock;
    private final Consumer<ConditionalBlock> onSave;
    private BlockListWidget blockList;
    private ConditionalBlock selectedBlock;
    private ConditionalBlock draggedBlock;
    private int dragOffsetX;
    private int dragOffsetY;
    private boolean showDebugger = true;
    private class_4185 toggleDebuggerButton;
    private class_4185 addIfButton;
    private class_4185 addAndButton;
    private class_4185 addOrButton;
    private class_4185 addNotButton;
    private class_4185 addElseButton;
    private class_4185 editButton;
    private class_4185 deleteButton;
    private class_4185 doneButton;
    private int scrollOffset = 0;

    public ScratchBlockEditorScreen(class_437 parent, ConditionalBlock rootBlock, Consumer<ConditionalBlock> onSave) {
        super((class_2561)class_2561.method_43470((String)"Visual Condition Editor"));
        this.parent = parent;
        this.rootBlock = rootBlock != null ? rootBlock : new ConditionalBlock();
        this.onSave = onSave;
    }

    public static ScratchBlockEditorScreen fromConditionGroup(class_437 parent, ConditionGroup group, Consumer<ConditionGroup> onSave) {
        ConditionalBlock block = ConditionalBlock.fromConditionGroup(group);
        return new ScratchBlockEditorScreen(parent, block, resultBlock -> onSave.accept(resultBlock.toConditionGroup()));
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int topY = 40;
        String info = "Build your conditions like Scratch blocks!";
        int buttonY = topY + 20;
        int buttonWidth = 60;
        int spacing = 5;
        int startX = centerX - (buttonWidth * 5 + spacing * 4) / 2;
        this.addIfButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a79+ If"), btn -> this.addBlock(ConditionalBlock.BlockType.IF)).method_46434(startX, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.addIfButton);
        this.addAndButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7a+ And"), btn -> this.addBlock(ConditionalBlock.BlockType.AND)).method_46434(startX + (buttonWidth + spacing), buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.addAndButton);
        this.addOrButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a76+ Or"), btn -> this.addBlock(ConditionalBlock.BlockType.OR)).method_46434(startX + (buttonWidth + spacing) * 2, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.addOrButton);
        this.addNotButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7c+ Not"), btn -> this.addBlock(ConditionalBlock.BlockType.NOT)).method_46434(startX + (buttonWidth + spacing) * 3, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.addNotButton);
        this.addElseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a77+ Else"), btn -> this.addElseBlock()).method_46434(startX + (buttonWidth + spacing) * 4, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.addElseButton);
        int listTop = buttonY + 35;
        int listHeight = this.field_22790 - listTop - 60;
        this.blockList = new BlockListWidget(this.field_22787, this.field_22789 - 40, listHeight, listTop, this.field_22790 - 60, 60);
        this.blockList.setRootBlock(this.rootBlock);
        this.method_37063((class_364)this.blockList);
        int bottomY = this.field_22790 - 30;
        int bottomButtonWidth = 70;
        this.editButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit"), btn -> this.editSelectedBlock()).method_46434(centerX - bottomButtonWidth * 2 - 15, bottomY, bottomButtonWidth, 20).method_46431();
        this.method_37063((class_364)this.editButton);
        this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), btn -> this.deleteSelectedBlock()).method_46434(centerX - bottomButtonWidth - 5, bottomY, bottomButtonWidth, 20).method_46431();
        this.method_37063((class_364)this.deleteButton);
        class_4185 clearButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear All"), btn -> this.clearAll()).method_46434(centerX + 5, bottomY, bottomButtonWidth, 20).method_46431();
        this.method_37063((class_364)clearButton);
        this.doneButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), btn -> this.save()).method_46434(centerX + bottomButtonWidth + 15, bottomY, bottomButtonWidth, 20).method_46431();
        this.method_37063((class_364)this.doneButton);
        this.updateButtonStates();
    }

    private void addBlock(ConditionalBlock.BlockType type) {
        ConditionalBlock newBlock = new ConditionalBlock(type);
        if (this.selectedBlock != null) {
            this.selectedBlock.addChild(newBlock);
        } else {
            this.rootBlock.addChild(newBlock);
        }
        this.openDetailEditor(newBlock);
    }

    private void addElseBlock() {
        if (this.selectedBlock != null && this.selectedBlock.getType() == ConditionalBlock.BlockType.IF) {
            ConditionalBlock elseBlock = new ConditionalBlock(ConditionalBlock.BlockType.ELSE);
            this.selectedBlock.setElseBlock(elseBlock);
            this.refreshList();
        }
    }

    private void editSelectedBlock() {
        if (this.selectedBlock != null) {
            this.openDetailEditor(this.selectedBlock);
        }
    }

    private void openDetailEditor(ConditionalBlock block) {
        if (block.getType() != ConditionalBlock.BlockType.ELSE) {
            StatCondition condition = block.getCondition();
            if (condition == null) {
                condition = new StatCondition();
                block.setCondition(condition);
            }
            this.field_22787.method_1507((class_437)new ConditionDetailScreen(this, condition, updatedCondition -> {
                block.setCondition((StatCondition)updatedCondition);
                this.refreshList();
            }));
        }
    }

    private void deleteSelectedBlock() {
        if (this.selectedBlock != null && this.selectedBlock != this.rootBlock) {
            this.removeBlockFromTree(this.rootBlock, this.selectedBlock);
            this.selectedBlock = null;
            this.refreshList();
            this.updateButtonStates();
        }
    }

    private boolean removeBlockFromTree(ConditionalBlock parent, ConditionalBlock toRemove) {
        if (parent.getChildren().remove(toRemove)) {
            return true;
        }
        for (ConditionalBlock child : parent.getChildren()) {
            if (!this.removeBlockFromTree(child, toRemove)) continue;
            return true;
        }
        if (parent.getElseBlock() == toRemove) {
            parent.setElseBlock(null);
            return true;
        }
        return false;
    }

    private void clearAll() {
        this.rootBlock.getChildren().clear();
        this.rootBlock.setElseBlock(null);
        this.selectedBlock = null;
        this.refreshList();
        this.updateButtonStates();
    }

    private void refreshList() {
        this.blockList.setRootBlock(this.rootBlock);
    }

    private void save() {
        this.onSave.accept(this.rootBlock);
        this.field_22787.method_1507(this.parent);
    }

    private void updateButtonStates() {
        boolean hasSelection = this.selectedBlock != null;
        this.editButton.field_22763 = hasSelection && this.selectedBlock.getType() != ConditionalBlock.BlockType.ELSE;
        this.deleteButton.field_22763 = hasSelection && this.selectedBlock != this.rootBlock;
        this.addElseButton.field_22763 = hasSelection && this.selectedBlock.getType() == ConditionalBlock.BlockType.IF && !this.selectedBlock.hasElse();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        String instructions = "\u00a77Click blocks to select \u2022 Use buttons to add blocks \u2022 Nest blocks for AND/OR logic";
        graphics.method_25300(this.field_22793, instructions, this.field_22789 / 2, 30, 0x888888);
        int totalBlocks = this.rootBlock.getTotalBlockCount() - 1;
        String countText = totalBlocks + " block" + (totalBlocks == 1 ? "" : "s");
        graphics.method_25303(this.field_22793, countText, 20, 80, 0xAAAAAA);
        if (this.selectedBlock != null) {
            String selectedInfo = "\u00a7eSelected: \u00a7f" + this.selectedBlock.getType().getDisplayName();
            graphics.method_25303(this.field_22793, selectedInfo, this.field_22789 - this.field_22793.method_1727(selectedInfo) - 20, 80, 0xFFFFFF);
            if (this.selectedBlock.hasCondition()) {
                String condPreview = "\u00a77" + this.selectedBlock.getCondition().toString();
                if (condPreview.length() > 50) {
                    condPreview = condPreview.substring(0, 47) + "...";
                }
                int previewX = this.field_22789 - this.field_22793.method_1727(condPreview) - 20;
                graphics.method_25303(this.field_22793, condPreview, previewX, 95, 0xAAAAAA);
            }
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.addIfButton.method_25405((double)mouseX, (double)mouseY)) {
            graphics.method_51434(this.field_22793, List.of(class_2561.method_43470((String)"\u00a79IF Block"), class_2561.method_43470((String)"\u00a77Main condition block"), class_2561.method_43470((String)"\u00a77Can have children and ELSE")), mouseX, mouseY);
        } else if (this.addAndButton.method_25405((double)mouseX, (double)mouseY)) {
            graphics.method_51434(this.field_22793, List.of(class_2561.method_43470((String)"\u00a7aAND Block"), class_2561.method_43470((String)"\u00a77All conditions must be true")), mouseX, mouseY);
        } else if (this.addOrButton.method_25405((double)mouseX, (double)mouseY)) {
            graphics.method_51434(this.field_22793, List.of(class_2561.method_43470((String)"\u00a76OR Block"), class_2561.method_43470((String)"\u00a77At least one must be true")), mouseX, mouseY);
        } else if (this.addNotButton.method_25405((double)mouseX, (double)mouseY)) {
            graphics.method_51434(this.field_22793, List.of(class_2561.method_43470((String)"\u00a7cNOT Block"), class_2561.method_43470((String)"\u00a77Inverts the condition")), mouseX, mouseY);
        } else if (this.addElseButton.method_25405((double)mouseX, (double)mouseY)) {
            graphics.method_51434(this.field_22793, List.of(class_2561.method_43470((String)"\u00a77ELSE Block"), class_2561.method_43470((String)"\u00a77Default when IF is false")), mouseX, mouseY);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private class BlockListWidget
    extends class_4280<BlockEntry> {
        public BlockListWidget(class_310 minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
        }

        public void setRootBlock(ConditionalBlock root) {
            this.method_25339();
            this.addBlocksRecursively(root, 0);
        }

        private void addBlocksRecursively(ConditionalBlock block, int depth) {
            for (ConditionalBlock child : block.getChildren()) {
                this.method_25321((class_350.class_351)new BlockEntry(child, depth));
                if (child.hasChildren()) {
                    this.addBlocksRecursively(child, depth + 1);
                }
                if (!child.hasElse()) continue;
                this.method_25321((class_350.class_351)new BlockEntry(child.getElseBlock(), depth));
            }
        }

        public class BlockEntry
        extends class_4280.class_4281<BlockEntry> {
            private final ConditionalBlock block;
            private final int depth;

            public BlockEntry(ConditionalBlock block, int depth) {
                this.block = block;
                this.depth = depth;
            }

            public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                boolean selected = this.block == ScratchBlockEditorScreen.this.selectedBlock;
                int indent = this.depth * 30;
                int blockLeft = left + indent + 20;
                int blockWidth = width - indent - 40;
                int blockHeight = 50;
                int bgColor = this.parseColor(this.block.getColor());
                if (selected) {
                    bgColor = this.lightenColor(bgColor);
                }
                if (isHovering && !selected) {
                    bgColor = this.lightenColor(bgColor, 0.2f);
                }
                graphics.method_25294(blockLeft, top, blockLeft + blockWidth, top + blockHeight, bgColor);
                graphics.method_49601(blockLeft, top, blockWidth, blockHeight, -16777216);
                String typeText = this.block.getType().getDisplayName();
                graphics.method_25303(((BlockListWidget)BlockListWidget.this).field_22740.field_1772, "\u00a7l" + typeText, blockLeft + 10, top + 5, 0xFFFFFF);
                if (this.block.hasCondition()) {
                    StatCondition condition = this.block.getCondition();
                    String condText = condition.getType().getDisplayName() + " " + condition.getOperator().getSymbol() + " " + condition.getValue();
                    if (condText.length() > 40) {
                        condText = condText.substring(0, 37) + "...";
                    }
                    graphics.method_25303(((BlockListWidget)BlockListWidget.this).field_22740.field_1772, "\u00a77" + condText, blockLeft + 10, top + 20, 0xFFFFFF);
                }
                if (this.block.hasChildren()) {
                    String childText = "[" + this.block.getChildren().size() + " nested]";
                    graphics.method_25303(((BlockListWidget)BlockListWidget.this).field_22740.field_1772, "\u00a7e" + childText, blockLeft + 10, top + 35, 0xFFFFFF);
                }
                if (this.block.hasElse()) {
                    String elseText = "[has else]";
                    int elseX = blockLeft + blockWidth - ((BlockListWidget)BlockListWidget.this).field_22740.field_1772.method_1727(elseText) - 10;
                    graphics.method_25303(((BlockListWidget)BlockListWidget.this).field_22740.field_1772, "\u00a77" + elseText, elseX, top + 35, 0xFFFFFF);
                }
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)this.block.toString());
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                ScratchBlockEditorScreen.this.selectedBlock = this.block;
                ScratchBlockEditorScreen.this.updateButtonStates();
                return true;
            }

            private int parseColor(String hex) {
                try {
                    return (int)Long.parseLong(hex.substring(1), 16) | 0xFF000000;
                }
                catch (Exception e) {
                    return -11890462;
                }
            }

            private int lightenColor(int color) {
                return this.lightenColor(color, 0.3f);
            }

            private int lightenColor(int color, float amount) {
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                r = Math.min(255, (int)((float)r + (float)(255 - r) * amount));
                g = Math.min(255, (int)((float)g + (float)(255 - g) * amount));
                b = Math.min(255, (int)((float)b + (float)(255 - b) * amount));
                return 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
    }
}

