/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.client.gui.SnapshotDetailScreen;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;

public class SnapshotViewerScreen
extends class_437 {
    private static final int ENTRY_HEIGHT = 50;
    private static final int PADDING = 10;
    private final class_437 parent;
    private List<SnapshotManager.SnapshotInfo> snapshots;
    private int scrollOffset = 0;
    private SnapshotManager.SnapshotInfo selectedSnapshot = null;

    public SnapshotViewerScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.beautiful_statistics_screen.snapshots"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.snapshots = SnapshotManager.listSnapshots();
        class_4185 refreshButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.refresh"), btn -> this.refresh()).method_46434(this.field_22789 - 90, 10, 80, 20).method_46431();
        this.method_37063((class_364)refreshButton);
        class_4185 viewButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.view"), btn -> this.viewSelected()).method_46434(this.field_22789 / 2 - 205, this.field_22790 - 30, 100, 20).method_46431();
        this.method_37063((class_364)viewButton);
        class_4185 deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.delete"), btn -> this.deleteSelected()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 30, 100, 20).method_46431();
        this.method_37063((class_364)deleteButton);
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), btn -> this.method_25419()).method_46434(this.field_22789 / 2 + 5, this.field_22790 - 30, 100, 20).method_46431();
        this.method_37063((class_364)backButton);
        class_4185 exportButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.export_new"), btn -> this.exportNew()).method_46434(this.field_22789 / 2 + 110, this.field_22790 - 30, 100, 20).method_46431();
        this.method_37063((class_364)exportButton);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        this.renderSnapshotList(graphics, mouseX, mouseY);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void renderSnapshotList(class_332 graphics, int mouseX, int mouseY) {
        int listX = 10;
        int listY = 40;
        int listWidth = this.field_22789 - 20;
        int listHeight = this.field_22790 - 80;
        graphics.method_25294(listX, listY, listX + listWidth, listY + listHeight, Integer.MIN_VALUE);
        if (this.snapshots.isEmpty()) {
            String text = "No snapshots found";
            int textWidth = this.field_22793.method_1727(text);
            graphics.method_25303(this.field_22793, text, listX + (listWidth - textWidth) / 2, listY + listHeight / 2, 0x888888);
            return;
        }
        int entryY = listY + 10 - this.scrollOffset;
        for (SnapshotManager.SnapshotInfo snapshot : this.snapshots) {
            if (entryY + 50 < listY || entryY > listY + listHeight) {
                entryY += 60;
                continue;
            }
            boolean selected = snapshot == this.selectedSnapshot;
            boolean hovered = mouseX >= listX + 10 && mouseX < listX + listWidth - 10 && mouseY >= entryY && mouseY < entryY + 50;
            this.renderSnapshotEntry(graphics, snapshot, listX + 10, entryY, listWidth - 20, selected, hovered);
            entryY += 60;
        }
    }

    private void renderSnapshotEntry(class_332 graphics, SnapshotManager.SnapshotInfo snapshot, int x, int y, int width, boolean selected, boolean hovered) {
        int bgColor = selected ? -2141167520 : (hovered ? 0x60404040 : 0x40404040);
        graphics.method_25294(x, y, x + width, y + 50, bgColor);
        if (selected) {
            graphics.method_25294(x, y, x + width, y + 2, -16711681);
            graphics.method_25294(x, y + 50 - 2, x + width, y + 50, -16711681);
        }
        int textX = x + 5;
        int textY = y + 5;
        graphics.method_25303(this.field_22793, snapshot.filename, textX, textY, 0xFFFFFF);
        String playerText = "Player: " + snapshot.playerName;
        graphics.method_25303(this.field_22793, playerText, textX, textY += 12, 0xCCCCCC);
        String timeText = snapshot.getFormattedTimestamp();
        int timeWidth = this.field_22793.method_1727(timeText);
        graphics.method_25303(this.field_22793, timeText, x + width - timeWidth - 5, textY, 0xCCCCCC);
        String statText = snapshot.statCount + " statistics";
        graphics.method_25303(this.field_22793, statText, textX, textY += 12, 0x888888);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int listX = 10;
        int listY = 40;
        int listWidth = this.field_22789 - 20;
        int listHeight = this.field_22790 - 80;
        if (mouseX >= (double)(listX + 10) && mouseX < (double)(listX + listWidth - 10) && mouseY >= (double)(listY + 10) && mouseY < (double)(listY + listHeight - 10)) {
            int entryY = listY + 10 - this.scrollOffset;
            for (SnapshotManager.SnapshotInfo snapshot : this.snapshots) {
                if (mouseY >= (double)entryY && mouseY < (double)(entryY + 50)) {
                    if (button == 0) {
                        this.selectedSnapshot = snapshot;
                        return true;
                    }
                    if (button == 1) {
                        this.viewSnapshot(snapshot);
                        return true;
                    }
                }
                entryY += 60;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int maxScroll = Math.max(0, this.snapshots.size() * 60 - (this.field_22790 - 120));
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    private void refresh() {
        this.snapshots = SnapshotManager.listSnapshots();
        this.selectedSnapshot = null;
        this.scrollOffset = 0;
    }

    private void viewSelected() {
        if (this.selectedSnapshot != null) {
            this.viewSnapshot(this.selectedSnapshot);
        }
    }

    private void viewSnapshot(SnapshotManager.SnapshotInfo snapshot) {
        block3: {
            try {
                SnapshotManager.SnapshotData data = SnapshotManager.importSnapshot(snapshot.path);
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new SnapshotDetailScreen(this, snapshot, data));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block3;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to load snapshot: " + e.getMessage())));
            }
        }
    }

    private void deleteSelected() {
        if (this.selectedSnapshot != null) {
            if (SnapshotManager.deleteSnapshot(this.selectedSnapshot.path)) {
                this.snapshots.remove(this.selectedSnapshot);
                this.selectedSnapshot = null;
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"Snapshot deleted"));
                }
            } else if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"Failed to delete snapshot"));
            }
        }
    }

    private void exportNew() {
        boolean success = SnapshotManager.exportSnapshot(null, true);
        if (success) {
            this.refresh();
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

