/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;
import org.texboobcat.beautiful_statistics_screen.custom.StatImportExport;

public class StatImportExportScreen
extends class_437 {
    private final class_437 parent;
    private final CustomStatDefinition singleStat;
    private ImportExportListWidget listWidget;
    private class_342 filenameField;
    private String statusMessage = "";
    private long statusMessageTime = 0L;
    private boolean statusIsError = false;
    private boolean exportMode = true;

    public StatImportExportScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.beautiful_statistics_screen.import_export"));
        this.parent = parent;
        this.singleStat = null;
    }

    public StatImportExportScreen(class_437 parent, CustomStatDefinition stat) {
        super((class_2561)class_2561.method_43471((String)"screen.beautiful_statistics_screen.import_export_single"));
        this.parent = parent;
        this.singleStat = stat;
    }

    protected void method_25426() {
        super.method_25426();
        int toggleY = 40;
        int toggleWidth = 100;
        int centerX = this.field_22789 / 2;
        class_4185 exportModeButton = class_4185.method_46430((class_2561)(this.exportMode ? class_2561.method_43471((String)"gui.beautiful_statistics_screen.export.mode").method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_36139(0x55FF55)) : class_2561.method_43471((String)"gui.beautiful_statistics_screen.export.mode")), btn -> {
            this.exportMode = true;
            this.method_41843();
        }).method_46434(centerX - toggleWidth - 5, toggleY, toggleWidth, 20).method_46431();
        this.method_37063((class_364)exportModeButton);
        class_4185 importModeButton = class_4185.method_46430((class_2561)(!this.exportMode ? class_2561.method_43471((String)"gui.beautiful_statistics_screen.import.mode").method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_36139(0x55FF55)) : class_2561.method_43471((String)"gui.beautiful_statistics_screen.import.mode")), btn -> {
            this.exportMode = false;
            this.method_41843();
        }).method_46434(centerX + 5, toggleY, toggleWidth, 20).method_46431();
        this.method_37063((class_364)importModeButton);
        if (this.exportMode) {
            this.filenameField = new class_342(this.field_22793, centerX - 150, 70, 300, 20, (class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.export.filename"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            Object defaultName = this.singleStat != null ? this.singleStat.getName().replaceAll("[^a-zA-Z0-9_-]", "_") : "all_stats_" + sdf.format(new Date());
            this.filenameField.method_1852((String)defaultName);
            this.filenameField.method_1880(50);
            this.method_37063((class_364)this.filenameField);
        }
        int listTop = this.exportMode ? 100 : 70;
        int listBottom = this.field_22790 - 70;
        this.listWidget = new ImportExportListWidget(this.field_22787, this.field_22789 - 40, listBottom - listTop, listTop, listBottom, 25);
        if (this.exportMode) {
            ArrayList<CustomStatDefinition> allStats = new ArrayList<CustomStatDefinition>(CustomStatManager.getAllCustomStats());
            for (CustomStatDefinition stat : allStats) {
                this.listWidget.addExportEntry(stat);
            }
        } else {
            List<String> files = StatImportExport.getAvailableImports();
            for (String file : files) {
                this.listWidget.addImportEntry(file);
            }
        }
        this.method_37063((class_364)this.listWidget);
        int bottomY = this.field_22790 - 35;
        if (this.exportMode) {
            if (this.singleStat != null) {
                class_4185 exportButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.export.this_stat"), btn -> this.exportSingleStat()).method_46434(centerX - 160, bottomY, 150, 20).method_46431();
                this.method_37063((class_364)exportButton);
            } else {
                class_4185 exportSelectedButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.export.selected"), btn -> this.exportSelected()).method_46434(centerX - 160, bottomY, 150, 20).method_46431();
                this.method_37063((class_364)exportSelectedButton);
                class_4185 exportAllButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.export.all"), btn -> this.exportAll()).method_46434(centerX - 5, bottomY, 150, 20).method_46431();
                this.method_37063((class_364)exportAllButton);
            }
        } else {
            class_4185 importButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.import.selected"), btn -> this.importSelected()).method_46434(centerX - 75, bottomY, 150, 20).method_46431();
            this.method_37063((class_364)importButton);
        }
        class_4185 closeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.close"), btn -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 - 80, bottomY, 70, 20).method_46431();
        this.method_37063((class_364)closeButton);
    }

    private void exportSingleStat() {
        String filename = this.filenameField.method_1882().trim();
        if (filename.isEmpty()) {
            this.showError("Please enter a filename");
            return;
        }
        boolean success = StatImportExport.exportStat(this.singleStat, filename);
        if (success) {
            this.showSuccess("Exported: " + filename + ".customstat");
        } else {
            this.showError("Failed to export stat");
        }
    }

    private void exportSelected() {
        List<CustomStatDefinition> selected = this.listWidget.getSelectedStats();
        if (selected.isEmpty()) {
            this.showError("No stats selected");
            return;
        }
        String filename = this.filenameField.method_1882().trim();
        if (filename.isEmpty()) {
            this.showError("Please enter a filename");
            return;
        }
        boolean success = StatImportExport.exportStats(selected, filename);
        if (success) {
            this.showSuccess("Exported " + selected.size() + " stat(s)");
        } else {
            this.showError("Failed to export stats");
        }
    }

    private void exportAll() {
        String filename = this.filenameField.method_1882().trim();
        if (filename.isEmpty()) {
            this.showError("Please enter a filename");
            return;
        }
        boolean success = StatImportExport.exportAllStats(filename);
        if (success) {
            this.showSuccess("Exported all stats");
        } else {
            this.showError("Failed to export (no stats found?)");
        }
    }

    private void importSelected() {
        String selected = this.listWidget.getSelectedFile();
        if (selected == null) {
            this.showError("No file selected");
            return;
        }
        StatImportExport.ImportResult result = StatImportExport.importStat(selected);
        if (result.success) {
            for (CustomStatDefinition stat : result.importedStats) {
                CustomStatManager.updateCustomStat(stat);
            }
            this.showSuccess(result.message);
        } else {
            this.showError(result.message);
        }
    }

    private void showSuccess(String message) {
        this.statusMessage = message;
        this.statusMessageTime = System.currentTimeMillis();
        this.statusIsError = false;
    }

    private void showError(String message) {
        this.statusMessage = message;
        this.statusMessageTime = System.currentTimeMillis();
        this.statusIsError = true;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        String instructions = this.exportMode ? (this.singleStat != null ? class_2561.method_43471((String)"gui.beautiful_statistics_screen.export.single_instruction").getString() : class_2561.method_43471((String)"gui.beautiful_statistics_screen.export.instruction").getString()) : class_2561.method_43471((String)"gui.beautiful_statistics_screen.import.instruction").getString();
        graphics.method_25300(this.field_22793, instructions, this.field_22789 / 2, 105, 0x888888);
        if (!this.statusMessage.isEmpty() && System.currentTimeMillis() - this.statusMessageTime < 5000L) {
            int color = this.statusIsError ? 0xFF5555 : 0x55FF55;
            graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, this.field_22790 - 55, color);
        }
        if (this.exportMode && this.filenameField != null) {
            graphics.method_25303(this.field_22793, class_2561.method_43471((String)"gui.beautiful_statistics_screen.export.filename").getString(), this.field_22789 / 2 - 150, 60, 0xFFFFFF);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private class ImportExportListWidget
    extends class_4280<Entry> {
        private List<StatEntry> statEntries;
        private List<FileEntry> fileEntries;

        public ImportExportListWidget(class_310 minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.statEntries = new ArrayList<StatEntry>();
            this.fileEntries = new ArrayList<FileEntry>();
        }

        public void addExportEntry(CustomStatDefinition stat) {
            StatEntry entry = new StatEntry(stat);
            this.statEntries.add(entry);
            this.method_25321((class_350.class_351)entry);
        }

        public void addImportEntry(String filename) {
            FileEntry entry = new FileEntry(filename);
            this.fileEntries.add(entry);
            this.method_25321((class_350.class_351)entry);
        }

        public List<CustomStatDefinition> getSelectedStats() {
            ArrayList<CustomStatDefinition> selected = new ArrayList<CustomStatDefinition>();
            for (StatEntry entry : this.statEntries) {
                if (!entry.isSelected()) continue;
                selected.add(entry.stat);
            }
            return selected;
        }

        public String getSelectedFile() {
            for (FileEntry entry : this.fileEntries) {
                if (entry != this.method_25334()) continue;
                return entry.filename;
            }
            return null;
        }

        public class StatEntry
        extends Entry {
            private final CustomStatDefinition stat;
            private boolean selected;

            public StatEntry(CustomStatDefinition stat) {
                this.selected = false;
                this.stat = stat;
            }

            public boolean isSelected() {
                return this.selected;
            }

            public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                if (this.selected) {
                    graphics.method_25294(left, top, left + width, top + height, -2007629995);
                } else if (isHovering) {
                    graphics.method_25294(left, top, left + width, top + height, 0x44FFFFFF);
                }
                graphics.method_25303(StatImportExportScreen.this.field_22793, "\u00a7f" + this.stat.getName(), left + 25, top + 2, 0xFFFFFF);
                String category = this.stat.getCategory() != null ? this.stat.getCategory() : "None";
                graphics.method_25303(StatImportExportScreen.this.field_22793, "\u00a77" + category, left + 25, top + 13, 0xAAAAAA);
                if (this.stat.getConditionalBlock() != null) {
                    int blockCount = this.stat.getConditionalBlock().getTotalBlockCount() - 1;
                    String blocks = "\u00a76\u2726 " + blockCount + " blocks";
                    graphics.method_25303(StatImportExportScreen.this.field_22793, blocks, left + width - StatImportExportScreen.this.field_22793.method_1727(blocks) - 10, top + 8, 0xFFAA00);
                }
                int checkX = left + 5;
                int checkY = top + 7;
                graphics.method_25294(checkX, checkY, checkX + 10, checkY + 10, -1);
                if (this.selected) {
                    graphics.method_25294(checkX + 2, checkY + 2, checkX + 8, checkY + 8, -11141291);
                }
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)this.stat.getName());
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                this.selected = !this.selected;
                return true;
            }
        }

        public class FileEntry
        extends Entry {
            private final String filename;

            public FileEntry(String filename) {
                this.filename = filename;
            }

            public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                boolean selected;
                boolean bl = selected = this == ImportExportListWidget.this.method_25334();
                if (selected) {
                    graphics.method_25294(left, top, left + width, top + height, -2007629995);
                } else if (isHovering) {
                    graphics.method_25294(left, top, left + width, top + height, 0x44FFFFFF);
                }
                graphics.method_25303(StatImportExportScreen.this.field_22793, "\u00a7f" + this.filename, left + 10, top + 8, 0xFFFFFF);
                graphics.method_25303(StatImportExportScreen.this.field_22793, "\ud83d\udcc4", left + width - 30, top + 8, 0xFFFFFF);
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)this.filename);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                ImportExportListWidget.this.method_25313((class_350.class_351)this);
                return true;
            }
        }

        public abstract class Entry
        extends class_4280.class_4281<Entry> {
        }
    }
}

