/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;
import org.texboobcat.beautiful_statistics_screen.custom.StatTemplate;

public class StatTemplatesScreen
extends class_437 {
    private final class_437 parent;
    private TemplateListWidget templateList;
    private class_4185 createFromTemplateButton;
    private class_4185 backButton;
    private int selectedIndex = -1;
    private List<StatTemplate> templates;

    public StatTemplatesScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.beautiful_statistics_screen.templates"));
        this.parent = parent;
    }

    protected void method_25426() {
        Collection<StatTemplate> allTemplates = CustomStatManager.getAllTemplates();
        this.templates = new ArrayList<StatTemplate>(allTemplates);
        this.templateList = new TemplateListWidget(this.field_22787, this.field_22789, this.field_22790 - 96, 32, this.field_22790 - 64, 60);
        this.templateList.setTemplates(this.templates);
        this.method_37063((class_364)this.templateList);
        int buttonY = this.field_22790 - 52;
        int buttonWidth = 120;
        int spacing = 10;
        int startX = (this.field_22789 - (buttonWidth * 2 + spacing)) / 2;
        this.createFromTemplateButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.template.use"), button -> this.createFromTemplate()).method_46434(startX, buttonY, buttonWidth, 20).method_46431();
        this.createFromTemplateButton.field_22763 = false;
        this.method_37063((class_364)this.createFromTemplateButton);
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.back"), button -> this.field_22787.method_1507(this.parent)).method_46434(startX + buttonWidth + spacing, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.backButton);
    }

    private void createFromTemplate() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.templates.size()) {
            StatTemplate template = this.templates.get(this.selectedIndex);
            CustomStatManager.createFromTemplate(template.getId());
            if (this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43469((String)"message.beautiful_statistics_screen.template_created", (Object[])new Object[]{template.getName()}));
            }
            this.field_22787.method_1507(this.parent);
        }
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        boolean hasSelection;
        this.createFromTemplateButton.field_22763 = hasSelection = this.selectedIndex >= 0 && this.selectedIndex < this.templates.size();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, 0xFFFFFF);
        String infoText = class_2561.method_43469((String)"gui.beautiful_statistics_screen.templates_count", (Object[])new Object[]{this.templates.size()}).getString();
        graphics.method_25303(this.field_22793, infoText, 10, this.field_22790 - 76, 0xAAAAAA);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private class TemplateListWidget
    extends class_4280<TemplateEntry> {
        private List<StatTemplate> templates;

        public TemplateListWidget(class_310 minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.templates = new ArrayList<StatTemplate>();
        }

        public void setTemplates(List<StatTemplate> templates) {
            this.method_25339();
            this.templates = templates;
            for (int i = 0; i < templates.size(); ++i) {
                this.method_25321((class_350.class_351)new TemplateEntry(templates.get(i), i));
            }
        }

        public class TemplateEntry
        extends class_4280.class_4281<TemplateEntry> {
            private final StatTemplate template;
            private final int index;

            public TemplateEntry(StatTemplate template, int index) {
                this.template = template;
                this.index = index;
            }

            public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                boolean selected;
                boolean bl = selected = StatTemplatesScreen.this.selectedIndex == this.index;
                if (selected) {
                    graphics.method_25294(left, top, left + width, top + height, -2130706433);
                } else if (isHovering) {
                    graphics.method_25294(left, top, left + width, top + height, 0x40FFFFFF);
                }
                Object nameText = this.template.getName();
                if (this.template.isBuiltin()) {
                    nameText = "\u00a7e\u2b50 " + (String)nameText;
                }
                graphics.method_25303(StatTemplatesScreen.this.field_22793, (String)nameText, left + 5, top + 5, 0xFFFFFF);
                String desc = this.template.getDescription();
                if (desc != null && !desc.isEmpty()) {
                    graphics.method_25303(StatTemplatesScreen.this.field_22793, "\u00a77" + desc, left + 5, top + 18, 0xAAAAAA);
                }
                String typeInfo = "\u00a78" + this.template.getCategory() + " \u2022 " + this.template.getTrackingType().getDisplayName();
                graphics.method_25303(StatTemplatesScreen.this.field_22793, typeInfo, left + 5, top + 31, 0x888888);
                String icon = this.template.getIcon();
                if (icon != null && !icon.isEmpty()) {
                    graphics.method_25303(StatTemplatesScreen.this.field_22793, "Icon: " + icon, left + 5, top + 44, 0x666666);
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                StatTemplatesScreen.this.setSelectedIndex(this.index);
                return true;
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)this.template.getName());
            }
        }
    }
}

