/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.hud;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class StatHudRenderer {
    private static final int ENTRY_HEIGHT = 20;
    private static final int ENTRY_SPACING = 2;
    private static final int PADDING = 5;
    private static final int ICON_SIZE = 16;
    private static boolean visible = true;

    public static void render(class_332 graphics, float partialTick) {
        ModConfig.Client config = ModConfig.getClient();
        if (!config.enableHUD || !visible) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1690.field_1866) {
            return;
        }
        List<class_2960> pinnedStats = ModConfig.getPinnedStats();
        if (pinnedStats.isEmpty()) {
            return;
        }
        ArrayList<StatEntry> entries = new ArrayList<StatEntry>();
        for (class_2960 statId : pinnedStats) {
            StatEntry entry = StatDataManager.getStatEntry(statId);
            if (entry == null) continue;
            entries.add(entry);
        }
        if (entries.isEmpty()) {
            return;
        }
        StatHudRenderer.renderStatEntries(graphics, mc, entries, config);
    }

    private static void renderStatEntries(class_332 graphics, class_310 mc, List<StatEntry> entries, ModConfig.Client config) {
        int windowWidth = mc.method_22683().method_4486();
        int windowHeight = mc.method_22683().method_4502();
        int maxWidth = 0;
        for (StatEntry entry : entries) {
            String text = entry.getDisplayName().getString() + ": " + entry.getValue();
            int textWidth = mc.field_1772.method_1727(text);
            maxWidth = Math.max(maxWidth, textWidth);
        }
        int hudWidth = maxWidth + 10;
        if (config.hudShowIcons) {
            hudWidth += 21;
        }
        int hudHeight = entries.size() * 22 - 2 + 10;
        double scale = config.hudScale;
        hudWidth = (int)((double)hudWidth * scale);
        hudHeight = (int)((double)hudHeight * scale);
        int x = StatHudRenderer.calculateX(windowWidth, hudWidth, config);
        int y = StatHudRenderer.calculateY(windowHeight, hudHeight, config);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        graphics.method_51448().method_22905((float)scale, (float)scale, 1.0f);
        graphics.method_25294(0, 0, (int)((double)hudWidth / scale), (int)((double)hudHeight / scale), -1073741824);
        StatHudRenderer.drawBorder(graphics, 0, 0, (int)((double)hudWidth / scale), (int)((double)hudHeight / scale));
        int entryY = 5;
        for (StatEntry entry : entries) {
            StatHudRenderer.renderEntry(graphics, mc, entry, 5, entryY, config);
            entryY += 22;
        }
        graphics.method_51448().method_22909();
    }

    private static void renderEntry(class_332 graphics, class_310 mc, StatEntry entry, int x, int y, ModConfig.Client config) {
        int currentX = x;
        if (config.hudShowIcons && entry.getIconRenderer() != null) {
            entry.getIconRenderer().render(graphics, currentX, y, 16);
            currentX += 21;
        }
        String valueStr = StatFormatter.formatStatValue(entry.getStatId(), entry.getValue());
        String text = entry.getDisplayName().getString() + ": " + valueStr;
        class_327 class_3272 = mc.field_1772;
        Objects.requireNonNull(mc.field_1772);
        graphics.method_25303(class_3272, text, currentX, y + (20 - 9) / 2, 0xFFFFFF);
    }

    private static void drawBorder(class_332 graphics, int x, int y, int width, int height) {
        int color = -16711681;
        graphics.method_25294(x, y, x + width, y + 1, color);
        graphics.method_25294(x, y + height - 1, x + width, y + height, color);
        graphics.method_25294(x, y, x + 1, y + height, color);
        graphics.method_25294(x + width - 1, y, x + width, y + height, color);
    }

    private static int calculateX(int windowWidth, int hudWidth, ModConfig.Client config) {
        return switch (config.hudPosition) {
            case ModConfig.HUDPosition.TOP_LEFT, ModConfig.HUDPosition.CENTER_LEFT, ModConfig.HUDPosition.BOTTOM_LEFT -> config.hudOffsetX;
            case ModConfig.HUDPosition.TOP_RIGHT, ModConfig.HUDPosition.CENTER_RIGHT, ModConfig.HUDPosition.BOTTOM_RIGHT -> windowWidth - hudWidth - config.hudOffsetX;
            default -> (windowWidth - hudWidth) / 2;
        };
    }

    private static int calculateY(int windowHeight, int hudHeight, ModConfig.Client config) {
        return switch (config.hudPosition) {
            case ModConfig.HUDPosition.TOP_LEFT, ModConfig.HUDPosition.TOP_RIGHT -> config.hudOffsetY;
            case ModConfig.HUDPosition.BOTTOM_LEFT, ModConfig.HUDPosition.BOTTOM_RIGHT -> windowHeight - hudHeight - config.hudOffsetY;
            case ModConfig.HUDPosition.CENTER_LEFT, ModConfig.HUDPosition.CENTER_RIGHT -> (windowHeight - hudHeight) / 2;
            default -> config.hudOffsetY;
        };
    }

    public static void toggleVisibility() {
        visible = !visible;
    }

    public static void setVisible(boolean visible) {
        StatHudRenderer.visible = visible;
    }

    public static boolean isVisible() {
        return visible;
    }
}

