/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Common commonConfig = new Common();
    private static Client clientConfig = new Client();
    private static Server serverConfig = new Server();
    private static Path configDir;

    public static void initialize(Path configDirectory) {
        configDir = configDirectory;
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ModConfig.loadCommonConfig();
        ModConfig.loadClientConfig();
        ModConfig.loadServerConfig();
    }

    public static void loadCommonConfig() {
        Path configFile = configDir.resolve("beautiful_statistics_screen-common.json");
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                commonConfig = (Common)GSON.fromJson((Reader)reader, Common.class);
                if (commonConfig == null) {
                    commonConfig = new Common();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                commonConfig = new Common();
            }
        } else {
            ModConfig.saveCommonConfig();
        }
    }

    public static void loadClientConfig() {
        Path configFile = configDir.resolve("beautiful_statistics_screen-client.json");
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                clientConfig = (Client)GSON.fromJson((Reader)reader, Client.class);
                if (clientConfig == null) {
                    clientConfig = new Client();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                clientConfig = new Client();
            }
        } else {
            ModConfig.saveClientConfig();
        }
    }

    public static void loadServerConfig() {
        Path configFile = configDir.resolve("beautiful_statistics_screen-server.json");
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                serverConfig = (Server)GSON.fromJson((Reader)reader, Server.class);
                if (serverConfig == null) {
                    serverConfig = new Server();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                serverConfig = new Server();
            }
        } else {
            ModConfig.saveServerConfig();
        }
    }

    public static void saveCommonConfig() {
        Path configFile = configDir.resolve("beautiful_statistics_screen-common.json");
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            GSON.toJson((Object)commonConfig, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveClientConfig() {
        Path configFile = configDir.resolve("beautiful_statistics_screen-client.json");
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            GSON.toJson((Object)clientConfig, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveServerConfig() {
        Path configFile = configDir.resolve("beautiful_statistics_screen-server.json");
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            GSON.toJson((Object)serverConfig, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Common getCommon() {
        return commonConfig;
    }

    public static Client getClient() {
        return clientConfig;
    }

    public static Server getServer() {
        return serverConfig;
    }

    public static void addPinnedStat(class_2960 statId) {
        String id = statId.toString();
        if (!ModConfig.clientConfig.pinnedStats.contains(id)) {
            ModConfig.clientConfig.pinnedStats.add(id);
            ModConfig.saveClientConfig();
        }
    }

    public static void removePinnedStat(class_2960 statId) {
        String id = statId.toString();
        if (ModConfig.clientConfig.pinnedStats.remove(id)) {
            ModConfig.saveClientConfig();
        }
    }

    public static boolean isPinned(class_2960 statId) {
        return ModConfig.clientConfig.pinnedStats.contains(statId.toString());
    }

    public static List<class_2960> getPinnedStats() {
        ArrayList<class_2960> stats = new ArrayList<class_2960>();
        for (String id : ModConfig.clientConfig.pinnedStats) {
            try {
                stats.add(new class_2960(id));
            }
            catch (Exception exception) {}
        }
        return stats;
    }

    public static class Common {
        public boolean enableStatSharing = false;
        public boolean enableCommands = true;
        public boolean enableSnapshots = true;
        public int maxSnapshotsPerPlayer = 100;
    }

    public static class Client {
        public boolean enableHUD = true;
        public HUDPosition hudPosition = HUDPosition.TOP_RIGHT;
        public int hudOffsetX = 10;
        public int hudOffsetY = 10;
        public boolean hudShowIcons = true;
        public boolean rememberLastTab = true;
        public boolean hideZeroByDefault = false;
        public String lastSelectedTab = "general";
        public List<String> pinnedStats = new ArrayList<String>();
        public Theme theme = Theme.DARK;
        public boolean enableAnimations = true;
        public double hudScale = 1.0;
        public boolean enableSmoothStatUpdates = false;
        public int statRefreshInterval = 30;
        public boolean enableHistoryTracking = true;
        public int historyLogInterval = 300;
        public int historyRetentionDays = 30;
        public boolean autoLogOnPlay = true;
        public boolean compressHistoryFiles = true;
        public boolean enableStatsAutosave = true;
        public int statsAutosaveInterval = 30;
        public boolean enableStatsBackups = true;
        public int statsBackupInterval = 600;
        public int maxBackupsPerPlayer = 10;
        public boolean autoDetectStatReset = true;
    }

    public static class Server {
        public boolean allowStatSharing = false;
        public boolean allowStatEditing = false;
        public int statSharingCooldown = 5000;
        public boolean requireOpForCommands = true;
        public boolean logStatChanges = true;
    }

    public static enum Theme {
        DARK,
        LIGHT,
        VANILLA;

    }

    public static enum HUDPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER_LEFT,
        CENTER_RIGHT;

    }
}

