/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import com.google.gson.annotations.SerializedName;
import java.util.UUID;
import net.minecraft.class_2561;

public class StatGoal {
    @SerializedName(value="id")
    private String id = UUID.randomUUID().toString();
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="targetValue")
    private long targetValue;
    @SerializedName(value="achieved")
    private boolean achieved = false;
    @SerializedName(value="achievedTime")
    private long achievedTime;
    @SerializedName(value="rewardMessage")
    private String rewardMessage;
    @SerializedName(value="playSound")
    private boolean playSound = true;
    @SerializedName(value="showNotification")
    private boolean showNotification = true;
    @SerializedName(value="repeatableGoal")
    private boolean repeatableGoal = false;
    @SerializedName(value="timesAchieved")
    private int timesAchieved = 0;

    public StatGoal() {
    }

    public StatGoal(String name, long targetValue) {
        this();
        this.name = name;
        this.targetValue = targetValue;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getTargetValue() {
        return this.targetValue;
    }

    public boolean isAchieved() {
        return this.achieved;
    }

    public long getAchievedTime() {
        return this.achievedTime;
    }

    public String getRewardMessage() {
        return this.rewardMessage;
    }

    public boolean shouldPlaySound() {
        return this.playSound;
    }

    public boolean shouldShowNotification() {
        return this.showNotification;
    }

    public boolean isRepeatableGoal() {
        return this.repeatableGoal;
    }

    public int getTimesAchieved() {
        return this.timesAchieved;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTargetValue(long targetValue) {
        this.targetValue = targetValue;
    }

    public void setRewardMessage(String rewardMessage) {
        this.rewardMessage = rewardMessage;
    }

    public void setPlaySound(boolean playSound) {
        this.playSound = playSound;
    }

    public void setShowNotification(boolean showNotification) {
        this.showNotification = showNotification;
    }

    public void setRepeatableGoal(boolean repeatableGoal) {
        this.repeatableGoal = repeatableGoal;
    }

    public boolean checkAndMarkAchieved(long currentValue) {
        if (currentValue >= this.targetValue && (!this.achieved || this.repeatableGoal)) {
            this.achieved = true;
            this.achievedTime = System.currentTimeMillis();
            ++this.timesAchieved;
            return true;
        }
        return false;
    }

    public double getProgress(long currentValue) {
        if (this.targetValue <= 0L) {
            return 0.0;
        }
        return Math.min(100.0, (double)currentValue * 100.0 / (double)this.targetValue);
    }

    public String getProgressFraction(long currentValue) {
        return currentValue + " / " + this.targetValue;
    }

    public void reset() {
        this.achieved = false;
        this.achievedTime = 0L;
        if (!this.repeatableGoal) {
            this.timesAchieved = 0;
        }
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)(this.name != null ? this.name : "Unnamed Goal"));
    }

    public class_2561 getDescriptionComponent() {
        return class_2561.method_43470((String)(this.description != null ? this.description : ""));
    }

    public String toString() {
        return "StatGoal{name='" + this.name + "', target=" + this.targetValue + ", achieved=" + this.achieved + ", times=" + this.timesAchieved + "}";
    }
}

