/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.network;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;

public class SharedStatsCache {
    private static final Map<String, Map<String, Long>> SHARED_STATS = new ConcurrentHashMap<String, Map<String, Long>>();
    private static final Map<String, Long> LAST_REQUEST_TIME = new ConcurrentHashMap<String, Long>();

    public static void setSharedStats(String playerName, Map<String, Long> stats) {
        SHARED_STATS.put(playerName, new HashMap<String, Long>(stats));
    }

    public static Map<String, Long> getSharedStats(String playerName) {
        return SHARED_STATS.get(playerName);
    }

    public static boolean hasSharedStats(String playerName) {
        return SHARED_STATS.containsKey(playerName);
    }

    public static void clearSharedStats(String playerName) {
        SHARED_STATS.remove(playerName);
        LAST_REQUEST_TIME.remove(playerName);
    }

    public static void clearAll() {
        SHARED_STATS.clear();
        LAST_REQUEST_TIME.clear();
    }

    public static boolean canRequest(String playerName) {
        Long lastTime = LAST_REQUEST_TIME.get(playerName);
        if (lastTime == null) {
            return true;
        }
        int cooldown = ModConfig.getServer().statSharingCooldown;
        return System.currentTimeMillis() - lastTime >= (long)cooldown;
    }

    public static void recordRequest(String playerName) {
        LAST_REQUEST_TIME.put(playerName, System.currentTimeMillis());
    }

    public static int getCooldownRemaining(String playerName) {
        Long lastTime = LAST_REQUEST_TIME.get(playerName);
        if (lastTime == null) {
            return 0;
        }
        int cooldown = ModConfig.getServer().statSharingCooldown;
        long elapsed = System.currentTimeMillis() - lastTime;
        long remaining = (long)cooldown - elapsed;
        return remaining > 0L ? (int)(remaining / 1000L) : 0;
    }
}

