/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import org.texboobcat.beautiful_statistics_screen.Beautiful_statistics_screen;

public class StatUpdateTracker {
    private static final Map<UUID, Map<String, Integer>> LAST_KNOWN_VALUES = new ConcurrentHashMap<UUID, Map<String, Integer>>();
    private static final Map<UUID, Long> LAST_UPDATE_TIME = new ConcurrentHashMap<UUID, Long>();
    private static final int UPDATE_INTERVAL = 1000;

    public static void checkAndSendUpdate(class_3222 player, class_3445<?> stat, int newValue) {
        UUID playerId = player.method_5667();
        String statKey = StatUpdateTracker.getStatKey(stat);
        Map playerStats = LAST_KNOWN_VALUES.computeIfAbsent(playerId, k -> new HashMap());
        Integer lastValue = (Integer)playerStats.get(statKey);
        if (lastValue == null || lastValue != newValue) {
            playerStats.put(statKey, newValue);
            Long lastUpdate = LAST_UPDATE_TIME.get(playerId);
            long now = System.currentTimeMillis();
            if (lastUpdate == null || now - lastUpdate >= 1000L) {
                LAST_UPDATE_TIME.put(playerId, now);
                StatUpdateTracker.sendUpdateToSubscribers(player, statKey, newValue);
            }
        }
    }

    public static void subscribe(class_3222 subscriber, class_3222 target) {
        Beautiful_statistics_screen.LOGGER.info("Player {} subscribed to updates from {}", (Object)subscriber.method_5477().getString(), (Object)target.method_5477().getString());
    }

    public static void unsubscribe(class_3222 subscriber, class_3222 target) {
        Beautiful_statistics_screen.LOGGER.info("Player {} unsubscribed from updates from {}", (Object)subscriber.method_5477().getString(), (Object)target.method_5477().getString());
    }

    private static void sendUpdateToSubscribers(class_3222 player, String statKey, int value) {
        Beautiful_statistics_screen.LOGGER.debug("Stat update: {} - {} = {}", new Object[]{player.method_5477().getString(), statKey, value});
    }

    private static String getStatKey(class_3445<?> stat) {
        return stat.method_1225();
    }

    public static void clearPlayer(UUID playerId) {
        LAST_KNOWN_VALUES.remove(playerId);
        LAST_UPDATE_TIME.remove(playerId);
    }

    public static void clearAll() {
        LAST_KNOWN_VALUES.clear();
        LAST_UPDATE_TIME.clear();
    }
}

