/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressionUtil {
    public static byte[] compress(String data) throws IOException {
        if (data == null || data.isEmpty()) {
            return new byte[0];
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipStream = new GZIPOutputStream(byteStream);){
            gzipStream.write(data.getBytes(StandardCharsets.UTF_8));
        }
        return byteStream.toByteArray();
    }

    public static String decompress(byte[] compressed) throws IOException {
        if (compressed == null || compressed.length == 0) {
            return "";
        }
        ByteArrayInputStream byteStream = new ByteArrayInputStream(compressed);
        try (GZIPInputStream gzipStream = new GZIPInputStream(byteStream);){
            String string;
            try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = gzipStream.read(buffer)) > 0) {
                    outStream.write(buffer, 0, len);
                }
                string = outStream.toString(StandardCharsets.UTF_8);
            }
            return string;
        }
    }

    public static void compressStream(Reader reader, OutputStream output) throws IOException {
        try (GZIPOutputStream gzipStream = new GZIPOutputStream(output);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)gzipStream, StandardCharsets.UTF_8));){
            int len;
            char[] buffer = new char[4096];
            while ((len = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, len);
            }
        }
    }

    public static void decompressStream(InputStream input, Writer writer) throws IOException {
        try (GZIPInputStream gzipStream = new GZIPInputStream(input);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)gzipStream, StandardCharsets.UTF_8));){
            int len;
            char[] buffer = new char[4096];
            while ((len = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, len);
            }
        }
    }

    public static double getCompressionRatio(int originalSize, int compressedSize) {
        if (originalSize == 0) {
            return 0.0;
        }
        return 100.0 * (1.0 - (double)compressedSize / (double)originalSize);
    }

    public static boolean isGzipCompressed(byte[] data) {
        if (data == null || data.length < 2) {
            return false;
        }
        return data[0] == 31 && data[1] == -117;
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "KMGTPE".charAt(exp - 1) + "i";
        return String.format("%.1f %sB", (double)bytes / Math.pow(1024.0, exp), pre);
    }
}

