/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.texboobcat.beautiful_statistics_screen.backup.StatBackupManager;
import org.texboobcat.beautiful_statistics_screen.command.HistoryCommand;
import org.texboobcat.beautiful_statistics_screen.command.ShareStatsCommand;
import org.texboobcat.beautiful_statistics_screen.command.StatsCommand;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatCategoryRegistry;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;
import org.texboobcat.beautiful_statistics_screen.history.HistoryManager;
import org.texboobcat.beautiful_statistics_screen.network.NetworkHandler;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;

public final class Beautiful_statistics_screen {
    public static final String MOD_ID = "beautiful_statistics_screen";
    public static final String MOD_NAME = "Beautiful Statistics Screen";
    public static final String MOD_VERSION = "1.0.0";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Beautiful Statistics Screen");

    public static void init() {
        LOGGER.info("Initializing {} {}", (Object)MOD_NAME, (Object)MOD_VERSION);
        StatCategoryRegistry.initializeDefaults();
        LOGGER.info("Initialized stat categories");
        NetworkHandler.register();
        LOGGER.info("Registered network handlers");
        CommandRegistrationEvent.EVENT.register((dispatcher, registry, selection) -> {
            if (ModConfig.getCommon().enableCommands) {
                StatsCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
                ShareStatsCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
                HistoryCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
                LOGGER.info("Registered statistics commands");
            }
        });
        LOGGER.info("{} initialization complete", (Object)MOD_NAME);
    }

    public static void initClient() {
        LOGGER.info("Initializing {} client", (Object)MOD_NAME);
        Path configDir = Beautiful_statistics_screen.getConfigDirectory();
        ModConfig.initialize(configDir);
        LOGGER.info("Loaded configuration");
        Path gameDir = Beautiful_statistics_screen.getGameDirectory();
        SnapshotManager.initialize(gameDir);
        LOGGER.info("Initialized snapshot system");
        HistoryManager.initialize(gameDir);
        LOGGER.info("Initialized history tracking system");
        StatBackupManager.initialize(gameDir);
        LOGGER.info("Initialized stat backup system");
        CustomStatManager.initialize(configDir);
        LOGGER.info("Initialized custom statistics system");
        LOGGER.info("{} client initialization complete", (Object)MOD_NAME);
    }

    private static Path getConfigDirectory() {
        return Beautiful_statistics_screen.getGameDirectory().resolve("config");
    }

    private static Path getGameDirectory() {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null) {
                return minecraft.f_91069_.toPath();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to get game directory", (Throwable)e);
        }
        return Path.of(".", new String[0]);
    }
}

