/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.backup;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;
import org.texboobcat.beautiful_statistics_screen.util.CompressionUtil;

public class StatBackupManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path backupDirectory;
    private static long lastBackupTime;
    private static final int MAX_BACKUPS = 10;

    public static void initialize(Path gameDirectory) {
        backupDirectory = gameDirectory.resolve("beautiful_statistics_screen").resolve("backups");
        try {
            Files.createDirectories(backupDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean createBackup() {
        long currentTime;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        lastBackupTime = currentTime = System.currentTimeMillis();
        try {
            block28: {
                StatBackupData backup = new StatBackupData();
                backup.timestamp = currentTime;
                backup.playerName = player.m_7755_().getString();
                backup.playerUUID = player.m_20148_().toString();
                backup.minecraftVersion = Minecraft.m_91087_().m_91389_();
                backup.stats = new HashMap<String, Long>();
                for (StatEntry entry : StatDataManager.getAllStats()) {
                    backup.stats.put(entry.getStatId().toString(), entry.getValue());
                }
                String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date(currentTime));
                String filename = String.valueOf(player.m_20148_()) + "_" + timestamp + ".backup";
                boolean useCompression = ModConfig.getClient().compressHistoryFiles;
                if (useCompression) {
                    filename = filename + ".gz";
                }
                Path backupFile = backupDirectory.resolve(filename);
                if (useCompression) {
                    try (OutputStream fileOut = Files.newOutputStream(backupFile, new OpenOption[0]);
                         GZIPOutputStream gzipOut = new GZIPOutputStream(fileOut);
                         OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gzipOut, "UTF-8");){
                        GSON.toJson((Object)backup, (Appendable)writer);
                        break block28;
                    }
                }
                try (BufferedWriter writer = Files.newBufferedWriter(backupFile, new OpenOption[0]);){
                    GSON.toJson((Object)backup, (Appendable)writer);
                }
            }
            StatBackupManager.pruneOldBackups(player.m_20148_().toString());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static StatBackupData getLatestBackup() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return null;
        }
        List<BackupInfo> backups = StatBackupManager.listBackups(player.m_20148_().toString());
        if (backups.isEmpty()) {
            return null;
        }
        BackupInfo latest = backups.get(0);
        return StatBackupManager.loadBackup(latest.path);
    }

    public static boolean detectAndRestoreIfNeeded() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        List<StatEntry> currentStats = StatDataManager.getAllStats();
        long totalCurrent = currentStats.stream().mapToLong(StatEntry::getValue).sum();
        StatBackupData backup = StatBackupManager.getLatestBackup();
        if (backup == null) {
            return false;
        }
        long totalBackup = backup.stats.values().stream().mapToLong(Long::longValue).sum();
        if ((double)totalCurrent < (double)totalBackup * 0.5 && totalBackup > 100L) {
            return StatBackupManager.restoreFromBackup(backup);
        }
        return false;
    }

    public static boolean restoreFromBackup(StatBackupData backup) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u26a0 Stats reset detected!"));
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a77Backup available from: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(backup.timestamp)))));
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77Use /stats restore to recover your stats"));
        }
        return true;
    }

    public static List<BackupInfo> listBackups(String playerUUID) {
        ArrayList<BackupInfo> backups = new ArrayList<BackupInfo>();
        if (!Files.exists(backupDirectory, new LinkOption[0])) {
            return backups;
        }
        try {
            Files.walk(backupDirectory, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                String name = p.getFileName().toString();
                return name.startsWith(playerUUID) && (name.endsWith(".backup") || name.endsWith(".backup.gz"));
            }).forEach(path -> {
                try {
                    StatBackupData data = StatBackupManager.loadBackup(path);
                    if (data != null) {
                        backups.add(new BackupInfo((Path)path, data.timestamp, data.playerName, data.stats.size()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        backups.sort((a, b) -> Long.compare(b.timestamp, a.timestamp));
        return backups;
    }

    /*
     * Exception decompiling
     */
    private static StatBackupData loadBackup(Path file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void pruneOldBackups(String playerUUID) {
        List<BackupInfo> backups = StatBackupManager.listBackups(playerUUID);
        if (backups.size() > 10) {
            for (int i = 10; i < backups.size(); ++i) {
                try {
                    Files.deleteIfExists(backups.get((int)i).path);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static BackupStats getBackupStats() {
        if (!Files.exists(backupDirectory, new LinkOption[0])) {
            return new BackupStats(0L, 0L, 0L, 0L);
        }
        long totalSize = 0L;
        long compressedCount = 0L;
        long uncompressedCount = 0L;
        long totalBackups = 0L;
        try {
            List files = Files.walk(backupDirectory, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                String name = p.toString();
                return name.endsWith(".backup") || name.endsWith(".backup.gz");
            }).collect(Collectors.toList());
            totalBackups = files.size();
            for (Path file : files) {
                totalSize += Files.size(file);
                if (file.toString().endsWith(".gz")) {
                    ++compressedCount;
                    continue;
                }
                ++uncompressedCount;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new BackupStats(totalSize, compressedCount, uncompressedCount, totalBackups);
    }

    public static void clearBackups(String playerUUID) {
        List<BackupInfo> backups = StatBackupManager.listBackups(playerUUID);
        for (BackupInfo backup : backups) {
            try {
                Files.deleteIfExists(backup.path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static long getLastBackupTime() {
        return lastBackupTime;
    }

    public static Path getBackupDirectory() {
        return backupDirectory;
    }

    static {
        lastBackupTime = 0L;
    }

    public static class StatBackupData {
        public long timestamp;
        public String playerName;
        public String playerUUID;
        public String minecraftVersion;
        public Map<String, Long> stats = new HashMap<String, Long>();
    }

    public static class BackupInfo {
        public final Path path;
        public final long timestamp;
        public final String playerName;
        public final int statCount;

        public BackupInfo(Path path, long timestamp, String playerName, int statCount) {
            this.path = path;
            this.timestamp = timestamp;
            this.playerName = playerName;
            this.statCount = statCount;
        }

        public String getFormattedTimestamp() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.timestamp));
        }
    }

    public static class BackupStats {
        public final long totalSize;
        public final long compressedCount;
        public final long uncompressedCount;
        public final long totalBackups;

        public BackupStats(long totalSize, long compressedCount, long uncompressedCount, long totalBackups) {
            this.totalSize = totalSize;
            this.compressedCount = compressedCount;
            this.uncompressedCount = uncompressedCount;
            this.totalBackups = totalBackups;
        }

        public String getFormattedSize() {
            return CompressionUtil.formatBytes(this.totalSize);
        }
    }
}

