/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.client.gui.chart.ChartDataset;
import org.texboobcat.beautiful_statistics_screen.client.gui.chart.ChartRenderer;
import org.texboobcat.beautiful_statistics_screen.client.gui.widgets.DatasetSelectorWidget;
import org.texboobcat.beautiful_statistics_screen.client.gui.widgets.StatisticsPanel;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;
import org.texboobcat.beautiful_statistics_screen.history.HistoryManager;

public class AdvancedChartScreen
extends Screen {
    private static final int[] COLORS = new int[]{-16733441, -38037, -11613327, -6547, -30841, -9675545, -16723245, -165464, -9127425, -6120450, -11145276, -347744};
    private final Screen parent;
    private final List<ChartDataset> datasets = new ArrayList<ChartDataset>();
    private ChartRenderer chartRenderer;
    private DatasetSelectorWidget datasetSelector;
    private StatisticsPanel statisticsPanel;
    private TimeRange timeRange = TimeRange.ALL;
    private ChartDataset.ChartStyle currentChartType = ChartDataset.ChartStyle.LINE;
    private Button addDatasetButton;
    private Button timeRangeButton;
    private Button chartTypeButton;
    private Button analyzeButton;
    private boolean showStatistics = false;

    public AdvancedChartScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Advanced Chart Analytics"));
        this.parent = parent;
    }

    public AdvancedChartScreen(Screen parent, ResourceLocation initialStat, Component statName) {
        this(parent);
        this.addDataset(initialStat, statName);
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonY = 10;
        int buttonX = 10;
        int buttonW = 100;
        int spacing = 5;
        this.addDatasetButton = Button.m_253074_((Component)Component.m_237113_((String)"+ Add Dataset"), b -> this.openDatasetPicker()).m_252987_(buttonX, buttonY, buttonW, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.addDatasetButton);
        this.timeRangeButton = Button.m_253074_((Component)Component.m_237113_((String)("Range: " + this.timeRange.label)), b -> {
            this.timeRange = this.timeRange.next();
            this.timeRangeButton.m_93666_((Component)Component.m_237113_((String)("Range: " + this.timeRange.label)));
            this.reloadData();
        }).m_252987_(buttonX += buttonW + spacing, buttonY, buttonW + 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.timeRangeButton);
        this.chartTypeButton = Button.m_253074_((Component)Component.m_237113_((String)("Type: " + this.formatChartType(this.currentChartType))), b -> {
            this.currentChartType = this.getNextChartType(this.currentChartType);
            for (ChartDataset dataset : this.datasets) {
                dataset.setStyle(this.currentChartType);
            }
            this.chartTypeButton.m_93666_((Component)Component.m_237113_((String)("Type: " + this.formatChartType(this.currentChartType))));
        }).m_252987_(buttonX += buttonW + 20 + spacing, buttonY, buttonW, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.chartTypeButton);
        Button trendButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2610 Trends"), b -> {
            boolean allEnabled = this.datasets.stream().allMatch(ChartDataset::isShowTrendLine);
            for (ChartDataset dataset : this.datasets) {
                dataset.setShowTrendLine(!allEnabled);
            }
            b.m_93666_((Component)Component.m_237113_((String)((!allEnabled ? "\u2611" : "\u2610") + " Trends")));
        }).m_252987_(buttonX += buttonW + spacing, buttonY, buttonW - 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)trendButton);
        Button statsButton = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udcca Stats"), b -> {
            boolean bl = this.showStatistics = !this.showStatistics;
            if (this.statisticsPanel != null) {
                this.statisticsPanel.f_93624_ = this.showStatistics;
            }
        }).m_252987_(buttonX += buttonW - 20 + spacing, buttonY, buttonW - 30, 20).m_253136_();
        this.m_142416_((GuiEventListener)statsButton);
        this.analyzeButton = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udd0d Analyze"), b -> this.openAnalysis()).m_252987_(buttonX += buttonW - 30 + spacing, buttonY, buttonW - 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.analyzeButton);
        Button back = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.m_7379_()).m_252987_((this.f_96543_ - 200) / 2, this.f_96544_ - 28, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)back);
        int selectorWidth = 200;
        this.datasetSelector = new DatasetSelectorWidget(this.f_96541_, this.f_96543_ - selectorWidth - 10, 40, selectorWidth, this.f_96544_ - 80, this.datasets, this::onDatasetChanged);
        this.m_142416_((GuiEventListener)this.datasetSelector);
        this.statisticsPanel = new StatisticsPanel(this.f_96541_, 10, 40, 250, this.f_96544_ - 80, this.datasets);
        this.statisticsPanel.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.statisticsPanel);
        int chartX = this.showStatistics ? 270 : 10;
        int chartW = this.f_96543_ - chartX - selectorWidth - 30;
        this.chartRenderer = new ChartRenderer(this.f_96547_, chartX, 40, chartW, this.f_96544_ - 80);
        this.reloadData();
    }

    private void addDataset(ResourceLocation statId, Component displayName) {
        List<HistoryManager.DataPoint> history = HistoryManager.getHistory(statId);
        if (history.isEmpty()) {
            return;
        }
        long cutoffTime = System.currentTimeMillis() - this.timeRange.milliseconds;
        ArrayList<ChartDataset.DataPoint> filteredData = new ArrayList<ChartDataset.DataPoint>();
        for (HistoryManager.DataPoint dp : history) {
            if (this.timeRange != TimeRange.ALL && dp.timestamp < cutoffTime) continue;
            filteredData.add(new ChartDataset.DataPoint(dp.timestamp, dp.value));
        }
        if (filteredData.isEmpty()) {
            return;
        }
        int color = COLORS[this.datasets.size() % COLORS.length];
        ChartDataset dataset = new ChartDataset(statId, displayName, filteredData, color);
        dataset.setStyle(this.currentChartType);
        this.datasets.add(dataset);
    }

    private void openDatasetPicker() {
        this.f_96541_.m_91152_((Screen)new DatasetPickerScreen(this, this::onDatasetPicked));
    }

    private void onDatasetPicked(ResourceLocation statId, Component displayName) {
        this.addDataset(statId, displayName);
        if (this.datasetSelector != null) {
            this.datasetSelector.refresh();
        }
        this.f_96541_.m_91152_((Screen)this);
    }

    private void onDatasetChanged() {
    }

    private void reloadData() {
        List<ResourceLocation> statIds = this.datasets.stream().map(ChartDataset::getStatId).toList();
        List<Component> names = this.datasets.stream().map(ChartDataset::getDisplayName).toList();
        this.datasets.clear();
        if (!statIds.isEmpty()) {
            Map<ResourceLocation, List<HistoryManager.DataPoint>> historyBatch = HistoryManager.getHistoryBatch(statIds);
            long cutoffTime = System.currentTimeMillis() - this.timeRange.milliseconds;
            for (int i = 0; i < statIds.size(); ++i) {
                ResourceLocation statId = statIds.get(i);
                Component displayName = names.get(i);
                List history = historyBatch.getOrDefault(statId, new ArrayList());
                if (history.isEmpty()) continue;
                ArrayList<ChartDataset.DataPoint> filteredData = new ArrayList<ChartDataset.DataPoint>();
                for (HistoryManager.DataPoint dp : history) {
                    if (this.timeRange != TimeRange.ALL && dp.timestamp < cutoffTime) continue;
                    filteredData.add(new ChartDataset.DataPoint(dp.timestamp, dp.value));
                }
                if (filteredData.isEmpty()) continue;
                int color = COLORS[this.datasets.size() % COLORS.length];
                ChartDataset dataset = new ChartDataset(statId, displayName, filteredData, color);
                dataset.setStyle(this.currentChartType);
                this.datasets.add(dataset);
            }
        }
        if (this.datasetSelector != null) {
            this.datasetSelector.refresh();
        }
    }

    private void openAnalysis() {
        if (this.datasets.isEmpty()) {
            return;
        }
        this.f_96541_.m_91152_((Screen)new AnalysisScreen(this, this.datasets));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        if (this.chartRenderer != null) {
            int chartX = this.showStatistics && this.statisticsPanel != null && this.statisticsPanel.f_93624_ ? 270 : 10;
            int chartW = this.f_96543_ - chartX - 220;
            this.chartRenderer = new ChartRenderer(this.f_96547_, chartX, 40, chartW, this.f_96544_ - 80);
            this.chartRenderer.render(graphics, this.datasets, mouseX, mouseY);
        }
        if (!this.datasets.isEmpty()) {
            String info = this.datasets.size() + " dataset" + (this.datasets.size() > 1 ? "s" : "") + " | " + this.datasets.stream().mapToInt(d -> d.getData().size()).sum() + " data points";
            graphics.m_280488_(this.f_96547_, info, 10, this.f_96544_ - 40, 0x888888);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private String formatChartType(ChartDataset.ChartStyle style) {
        return switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case ChartDataset.ChartStyle.LINE -> "Line";
            case ChartDataset.ChartStyle.BAR -> "Bar";
            case ChartDataset.ChartStyle.AREA -> "Area";
            case ChartDataset.ChartStyle.SCATTER -> "Scatter";
            case ChartDataset.ChartStyle.STEP -> "Step";
        };
    }

    private ChartDataset.ChartStyle getNextChartType(ChartDataset.ChartStyle current) {
        ChartDataset.ChartStyle[] values = ChartDataset.ChartStyle.values();
        int nextIndex = (current.ordinal() + 1) % values.length;
        return values[nextIndex];
    }

    private static enum TimeRange {
        HOUR("1 Hour", 3600000L),
        DAY("24 Hours", 86400000L),
        WEEK("7 Days", 604800000L),
        MONTH("30 Days", 2592000000L),
        ALL("All Time", Long.MAX_VALUE);

        final String label;
        final long milliseconds;

        private TimeRange(String label, long milliseconds) {
            this.label = label;
            this.milliseconds = milliseconds;
        }

        TimeRange next() {
            return TimeRange.values()[(this.ordinal() + 1) % TimeRange.values().length];
        }
    }

    private static class DatasetPickerScreen
    extends Screen {
        private final Screen parent;
        private final BiConsumer<ResourceLocation, Component> onPick;
        private StatPickerListWidget listWidget;

        protected DatasetPickerScreen(Screen parent, BiConsumer<ResourceLocation, Component> onPick) {
            super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.select_dataset"));
            this.parent = parent;
            this.onPick = onPick;
        }

        protected void m_7856_() {
            super.m_7856_();
            List<ResourceLocation> statsWithHistory = HistoryManager.getStatsWithHistory();
            this.listWidget = new StatPickerListWidget(this.f_96541_, this.f_96543_, this.f_96544_ - 80, 40, this.f_96544_ - 40, 25);
            for (ResourceLocation statId : statsWithHistory) {
                StatEntry entry = StatDataManager.getStatEntry(statId);
                if (entry == null) continue;
                this.listWidget.addStat(statId, entry);
            }
            this.m_142416_((GuiEventListener)this.listWidget);
            Button cancel = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.cancel"), b -> {
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_(this.parent);
                }
            }).m_252987_((this.f_96543_ - 200) / 2, this.f_96544_ - 30, 200, 20).m_253136_();
            this.m_142416_((GuiEventListener)cancel);
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(graphics);
            graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }

        private class StatPickerListWidget
        extends ObjectSelectionList<StatEntry> {
            public StatPickerListWidget(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
                super(minecraft, width, height, y0, y1, itemHeight);
            }

            public void addStat(ResourceLocation statId, org.texboobcat.beautiful_statistics_screen.api.StatEntry entry) {
                this.m_7085_((AbstractSelectionList.Entry)new StatEntry(statId, entry));
            }

            public class StatEntry
            extends ObjectSelectionList.Entry<StatEntry> {
                private final ResourceLocation statId;
                private final org.texboobcat.beautiful_statistics_screen.api.StatEntry entry;

                public StatEntry(ResourceLocation statId, org.texboobcat.beautiful_statistics_screen.api.StatEntry entry) {
                    this.statId = statId;
                    this.entry = entry;
                }

                public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                    if (isHovering) {
                        graphics.m_280509_(left, top, left + width, top + height, 0x40FFFFFF);
                    }
                    Component displayName = this.entry.getDisplayName();
                    graphics.m_280430_(DatasetPickerScreen.this.f_96547_, displayName, left + 5, top + (height - 8) / 2, 0xFFFFFF);
                }

                public boolean m_6375_(double mouseX, double mouseY, int button) {
                    DatasetPickerScreen.this.onPick.accept(this.statId, this.entry.getDisplayName());
                    return true;
                }

                public Component m_142172_() {
                    return this.entry.getDisplayName();
                }
            }
        }
    }

    private static class AnalysisScreen
    extends Screen {
        private final Screen parent;
        private final List<ChartDataset> datasets;

        protected AnalysisScreen(Screen parent, List<ChartDataset> datasets) {
            super((Component)Component.m_237113_((String)"Statistical Analysis"));
            this.parent = parent;
            this.datasets = datasets;
        }

        protected void m_7856_() {
            super.m_7856_();
            Button back = Button.m_253074_((Component)Component.m_237113_((String)"Back"), b -> {
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_(this.parent);
                }
            }).m_252987_((this.f_96543_ - 200) / 2, this.f_96544_ - 30, 200, 20).m_253136_();
            this.m_142416_((GuiEventListener)back);
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(graphics);
            graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
            int y = 50;
            for (ChartDataset dataset : this.datasets) {
                if (!dataset.isVisible()) continue;
                ChartDataset.DatasetStatistics stats = dataset.getStatistics();
                ChartDataset.TrendLine trend = dataset.calculateTrendLine();
                graphics.m_280488_(this.f_96547_, dataset.getDisplayName().getString(), 20, y, dataset.getColor());
                graphics.m_280488_(this.f_96547_, "  Min: " + stats.min(), 30, y += 15, 0xCCCCCC);
                graphics.m_280488_(this.f_96547_, "  Max: " + stats.max(), 30, y += 12, 0xCCCCCC);
                graphics.m_280488_(this.f_96547_, "  Mean: " + String.format("%.2f", stats.mean()), 30, y += 12, 0xCCCCCC);
                graphics.m_280488_(this.f_96547_, "  Median: " + stats.median(), 30, y += 12, 0xCCCCCC);
                graphics.m_280488_(this.f_96547_, "  Std Dev: " + String.format("%.2f", stats.standardDeviation()), 30, y += 12, 0xCCCCCC);
                graphics.m_280488_(this.f_96547_, "  Range: " + stats.getRange(), 30, y += 12, 0xCCCCCC);
                y += 12;
                if (trend != null) {
                    String trendDirection = trend.slope() > 0.0 ? "\u2191 Increasing" : (trend.slope() < 0.0 ? "\u2193 Decreasing" : "\u2192 Stable");
                    graphics.m_280488_(this.f_96547_, "  Trend: " + trendDirection, 30, y, 0xFFAA00);
                    graphics.m_280488_(this.f_96547_, "  Slope: " + String.format("%.4f", trend.slope()), 30, y += 12, 0xCCCCCC);
                    y += 12;
                }
                y += 10;
            }
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }
}

