/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ComparisonOperator;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionType;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class ConditionDetailScreen
extends Screen {
    private final Screen parent;
    private final StatCondition condition;
    private final Consumer<StatCondition> onSave;
    private CycleButton<ConditionType> typeButton;
    private CycleButton<ComparisonOperator> operatorButton;
    private EditBox valueField;
    private CycleButton<Boolean> negatedButton;
    private Button saveButton;
    private Button cancelButton;

    public ConditionDetailScreen(Screen parent, StatCondition condition, Consumer<StatCondition> onSave) {
        super((Component)Component.m_237113_((String)"Edit Condition"));
        this.parent = parent;
        this.condition = condition;
        this.onSave = onSave;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int fieldWidth = 300;
        int currentY = 60;
        int lineHeight = 30;
        this.typeButton = CycleButton.m_168894_(type -> Component.m_237113_((String)type.getDisplayName())).m_168961_((Object[])ConditionType.values()).m_168948_((Object)this.condition.getType()).m_168936_(centerX - fieldWidth / 2, currentY, fieldWidth, 20, (Component)Component.m_237113_((String)"Condition Type"), (btn, value) -> {
            this.condition.setType((ConditionType)((Object)value));
            this.updateOperatorOptions();
            this.updateValueHint();
        });
        this.m_142416_((GuiEventListener)this.typeButton);
        this.operatorButton = CycleButton.m_168894_(op -> Component.m_237113_((String)op.getDisplayName())).m_168961_((Object[])this.condition.getType().getValidOperators()).m_168948_((Object)this.condition.getOperator()).m_168936_(centerX - fieldWidth / 2, currentY += lineHeight, fieldWidth, 20, (Component)Component.m_237113_((String)"Operator"), (btn, value) -> this.condition.setOperator((ComparisonOperator)((Object)value)));
        this.m_142416_((GuiEventListener)this.operatorButton);
        this.valueField = new EditBox(this.f_96547_, centerX - fieldWidth / 2, currentY += lineHeight, fieldWidth, 20, (Component)Component.m_237113_((String)"Value"));
        this.valueField.m_94199_(200);
        this.valueField.m_94144_(this.condition.getValue());
        this.valueField.m_257771_((Component)Component.m_237113_((String)this.condition.getType().getExampleValue()));
        this.m_142416_((GuiEventListener)this.valueField);
        this.negatedButton = CycleButton.m_168896_((Component)Component.m_237113_((String)"NOT"), (Component)Component.m_237113_((String)"Normal")).m_168948_((Object)this.condition.isNegated()).m_168936_(centerX - fieldWidth / 2, currentY += lineHeight, fieldWidth, 20, (Component)Component.m_237113_((String)"Negation"), (btn, value) -> this.condition.setNegated((boolean)value));
        this.m_142416_((GuiEventListener)this.negatedButton);
        int buttonWidth = 100;
        this.saveButton = Button.m_253074_((Component)Component.m_237113_((String)"Save"), btn -> this.save()).m_252987_(centerX - buttonWidth - 5, currentY += lineHeight + 20, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX + 5, currentY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
    }

    private void updateOperatorOptions() {
        this.m_169411_((GuiEventListener)this.operatorButton);
        ComparisonOperator[] validOps = this.condition.getType().getValidOperators();
        ComparisonOperator currentOp = this.condition.getOperator();
        boolean isValid = false;
        for (ComparisonOperator op2 : validOps) {
            if (op2 != currentOp) continue;
            isValid = true;
            break;
        }
        if (!isValid && validOps.length > 0) {
            this.condition.setOperator(validOps[0]);
        }
        int centerX = this.f_96543_ / 2;
        int fieldWidth = 300;
        int currentY = 90;
        this.operatorButton = CycleButton.m_168894_(op -> Component.m_237113_((String)op.getDisplayName())).m_168961_((Object[])validOps).m_168948_((Object)this.condition.getOperator()).m_168936_(centerX - fieldWidth / 2, currentY, fieldWidth, 20, (Component)Component.m_237113_((String)"Operator"), (btn, value) -> this.condition.setOperator((ComparisonOperator)((Object)value)));
        this.m_142416_((GuiEventListener)this.operatorButton);
    }

    private void updateValueHint() {
        this.valueField.m_257771_((Component)Component.m_237113_((String)this.condition.getType().getExampleValue()));
    }

    private void save() {
        this.condition.setValue(this.valueField.m_94155_().trim());
        if (this.condition.getValue().isEmpty()) {
            return;
        }
        this.onSave.accept(this.condition);
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        int centerX = this.f_96543_ / 2;
        int fieldWidth = 300;
        int labelX = centerX - fieldWidth / 2;
        graphics.m_280488_(this.f_96547_, "Type:", labelX, 50, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Operator:", labelX, 80, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Value:", labelX, 110, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Negation:", labelX, 140, 0xFFFFFF);
        String description = this.condition.getType().getDescription();
        graphics.m_280488_(this.f_96547_, "\u00a77" + description, labelX, 175, 0xAAAAAA);
        graphics.m_280488_(this.f_96547_, "Preview:", labelX, 195, 0xFFFFFF);
        String preview = this.condition.toString();
        graphics.m_280488_(this.f_96547_, "\u00a7e" + preview, labelX + 10, 210, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }
}

