/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.awt.Desktop;
import java.awt.HeadlessException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.texboobcat.beautiful_statistics_screen.client.gui.SnapshotViewerScreen;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.history.HistoryManager;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;

public class ConfigScreen
extends Screen {
    private final Screen parent;
    private boolean hasChanges = false;
    private double scrollOffset = 0.0;
    private static final int SCROLL_SPEED = 10;
    private int contentHeight = 0;

    public ConfigScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.config"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int leftCol = this.f_96543_ / 2 - 155;
        int rightCol = this.f_96543_ / 2 + 5;
        int startY = 40;
        int spacing = 25;
        int currentY = startY + (int)this.scrollOffset;
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"HUD Settings").m_130938_((UnaryOperator)(UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$0(net.minecraft.network.chat.Style ), (Lnet/minecraft/network/chat/Style;)Lnet/minecraft/network/chat/Style;)()), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$1(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()).m_252987_((int)leftCol, (int)currentY, (int)310, (int)20).m_253136_())).f_93623_ = false;
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)ModConfig.getClient().enableHUD).m_168936_(leftCol, currentY += spacing, 150, 20, (Component)Component.m_237115_((String)"config.beautiful_statistics_screen.enable_hud"), (btn, value) -> {
            ModConfig.getClient().enableHUD = value;
            this.hasChanges = true;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168894_(pos -> Component.m_237113_((String)pos.name())).m_168961_((Object[])ModConfig.HUDPosition.values()).m_168948_((Object)ModConfig.getClient().hudPosition).m_168936_(rightCol, currentY, 150, 20, (Component)Component.m_237115_((String)"config.beautiful_statistics_screen.hud_position"), (btn, value) -> {
            ModConfig.getClient().hudPosition = value;
            this.hasChanges = true;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)ModConfig.getClient().hudShowIcons).m_168936_(leftCol, currentY += spacing, 150, 20, (Component)Component.m_237115_((String)"config.beautiful_statistics_screen.show_icons"), (btn, value) -> {
            ModConfig.getClient().hudShowIcons = value;
            this.hasChanges = true;
        }));
        currentY += spacing;
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"UI Settings").m_130938_((UnaryOperator)(UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$6(net.minecraft.network.chat.Style ), (Lnet/minecraft/network/chat/Style;)Lnet/minecraft/network/chat/Style;)()), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$7(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()).m_252987_((int)leftCol, (int)(currentY += 10), (int)310, (int)20).m_253136_())).f_93623_ = false;
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)ModConfig.getClient().hideZeroByDefault).m_168936_(leftCol, currentY += spacing, 150, 20, (Component)Component.m_237115_((String)"config.beautiful_statistics_screen.hide_zero_default"), (btn, value) -> {
            ModConfig.getClient().hideZeroByDefault = value;
            this.hasChanges = true;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)ModConfig.getClient().rememberLastTab).m_168936_(rightCol, currentY, 150, 20, (Component)Component.m_237115_((String)"config.beautiful_statistics_screen.remember_tab"), (btn, value) -> {
            ModConfig.getClient().rememberLastTab = value;
            this.hasChanges = true;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168894_(theme -> Component.m_237113_((String)theme.name())).m_168961_((Object[])ModConfig.Theme.values()).m_168948_((Object)ModConfig.getClient().theme).m_168936_(leftCol, currentY += spacing, 150, 20, (Component)Component.m_237115_((String)"config.beautiful_statistics_screen.theme"), (btn, value) -> {
            ModConfig.getClient().theme = value;
            this.hasChanges = true;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)ModConfig.getClient().enableAnimations).m_168936_(rightCol, currentY, 150, 20, (Component)Component.m_237115_((String)"config.beautiful_statistics_screen.animations"), (btn, value) -> {
            ModConfig.getClient().enableAnimations = value;
            this.hasChanges = true;
        }));
        currentY += spacing;
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Snapshot Settings").m_130938_((UnaryOperator)(UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$13(net.minecraft.network.chat.Style ), (Lnet/minecraft/network/chat/Style;)Lnet/minecraft/network/chat/Style;)()), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$14(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()).m_252987_((int)leftCol, (int)(currentY += 10), (int)310, (int)20).m_253136_())).f_93623_ = false;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"config.beautiful_statistics_screen.open_snapshots"), btn -> this.openSnapshotsFolder()).m_252987_(leftCol, currentY += spacing, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"config.beautiful_statistics_screen.view_snapshots"), btn -> this.viewSnapshots()).m_252987_(rightCol, currentY, 150, 20).m_253136_());
        currentY += spacing;
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"History Settings").m_130938_((UnaryOperator)(UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$17(net.minecraft.network.chat.Style ), (Lnet/minecraft/network/chat/Style;)Lnet/minecraft/network/chat/Style;)()), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$18(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()).m_252987_((int)leftCol, (int)(currentY += 10), (int)310, (int)20).m_253136_())).f_93623_ = false;
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)ModConfig.getClient().enableHistoryTracking).m_168936_(leftCol, currentY += spacing, 150, 20, (Component)Component.m_237113_((String)"History Tracking"), (btn, value) -> {
            ModConfig.getClient().enableHistoryTracking = value;
            this.hasChanges = true;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)ModConfig.getClient().compressHistoryFiles).m_168936_(rightCol, currentY, 150, 20, (Component)Component.m_237113_((String)"Compress Files"), (btn, value) -> {
            ModConfig.getClient().compressHistoryFiles = value;
            this.hasChanges = true;
        }));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"History Statistics"), btn -> this.showHistoryStats()).m_252987_(leftCol, currentY += spacing, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cClear All History"), btn -> this.confirmClearHistory()).m_252987_(rightCol, currentY, 150, 20).m_253136_());
        currentY += spacing;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), btn -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 155, this.f_96544_ - 30, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"config.beautiful_statistics_screen.reset_defaults"), btn -> this.resetDefaults()).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ - 30, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"config.beautiful_statistics_screen.clear_pinned"), btn -> this.clearPinned()).m_252987_(this.f_96543_ / 2 + 55, this.f_96544_ - 30, 100, 20).m_253136_());
        this.contentHeight = currentY - startY + 50;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int scrollableArea = this.f_96544_ - 70;
        if (this.contentHeight > scrollableArea) {
            this.scrollOffset += delta * 10.0;
            double maxScroll = 0.0;
            double minScroll = -(this.contentHeight - scrollableArea);
            this.scrollOffset = Math.max(minScroll, Math.min(maxScroll, this.scrollOffset));
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int scrollableArea;
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        int scissorTop = 35;
        int scissorBottom = this.f_96544_ - 55;
        graphics.m_280588_(0, scissorTop, this.f_96543_, scissorBottom);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280618_();
        if (this.hasChanges) {
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"config.beautiful_statistics_screen.unsaved_changes"), this.f_96543_ / 2, this.f_96544_ - 45, 0xFFFF00);
        }
        if (this.contentHeight > (scrollableArea = this.f_96544_ - 70)) {
            int barHeight = Math.max(20, scrollableArea * scrollableArea / this.contentHeight);
            int barMaxY = scissorBottom - barHeight;
            double scrollProgress = -this.scrollOffset / (double)(this.contentHeight - scrollableArea);
            int barY = scissorTop + (int)((double)(scrollableArea - barHeight) * scrollProgress);
            graphics.m_280509_(this.f_96543_ - 8, scissorTop, this.f_96543_ - 2, scissorBottom, Integer.MIN_VALUE);
            graphics.m_280509_(this.f_96543_ - 8, barY, this.f_96543_ - 2, barY + barHeight, -5592406);
            if (this.scrollOffset > (double)(-(this.contentHeight - scrollableArea))) {
                graphics.m_280137_(this.f_96547_, "\u00a77Scroll for more options \u25bc", this.f_96543_ / 2, this.f_96544_ - 58, 0xFFFFFF);
            }
        }
    }

    private void openSnapshotsFolder() {
        block13: {
            try {
                Path snapshotDir = SnapshotManager.getSnapshotDirectory();
                if (snapshotDir == null) {
                    SnapshotManager.initialize(this.f_96541_.f_91069_.toPath());
                    snapshotDir = SnapshotManager.getSnapshotDirectory();
                }
                if (snapshotDir != null) {
                    Files.createDirectories(snapshotDir, new FileAttribute[0]);
                    Path finalSnapshotDir = snapshotDir;
                    boolean opened = false;
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop desktop = Desktop.getDesktop();
                            if (desktop.isSupported(Desktop.Action.OPEN)) {
                                desktop.open(finalSnapshotDir.toFile());
                                opened = true;
                            }
                        }
                        catch (HeadlessException headlessException) {
                            // empty catch block
                        }
                    }
                    if (!opened) {
                        opened = this.tryOpenWithSystemCommand(finalSnapshotDir);
                    }
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        if (opened) {
                            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aOpened snapshots folder"));
                        }
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a77Path: " + String.valueOf(finalSnapshotDir.toAbsolutePath()))));
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77(Click to copy)").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, finalSnapshotDir.toAbsolutePath().toString()))));
                    }
                    break block13;
                }
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cFailed to initialize snapshots folder"));
                }
            }
            catch (Exception e) {
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7cFailed to open snapshots folder: " + e.getClass().getSimpleName())));
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a77Error: " + e.getMessage())));
                }
                e.printStackTrace();
            }
        }
    }

    private boolean tryOpenWithSystemCommand(Path directory) {
        try {
            String os = System.getProperty("os.name").toLowerCase();
            ProcessBuilder pb = os.contains("win") ? new ProcessBuilder("explorer", directory.toAbsolutePath().toString()) : (os.contains("mac") ? new ProcessBuilder("open", directory.toAbsolutePath().toString()) : new ProcessBuilder("xdg-open", directory.toAbsolutePath().toString()));
            pb.start();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void viewSnapshots() {
        if (this.f_96541_ != null) {
            Path snapshotDir = SnapshotManager.getSnapshotDirectory();
            if (snapshotDir == null) {
                SnapshotManager.initialize(this.f_96541_.f_91069_.toPath());
            }
            this.f_96541_.m_91152_((Screen)new SnapshotViewerScreen(this));
        }
    }

    private void resetDefaults() {
        ModConfig.getClient().enableHUD = true;
        ModConfig.getClient().hudPosition = ModConfig.HUDPosition.TOP_RIGHT;
        ModConfig.getClient().hudShowIcons = true;
        ModConfig.getClient().hideZeroByDefault = false;
        ModConfig.getClient().rememberLastTab = true;
        ModConfig.getClient().theme = ModConfig.Theme.DARK;
        ModConfig.getClient().enableAnimations = true;
        this.hasChanges = true;
        this.scrollOffset = 0.0;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    private void clearPinned() {
        ModConfig.getClient().pinnedStats.clear();
        this.hasChanges = true;
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237115_((String)"config.beautiful_statistics_screen.cleared_pinned"));
        }
    }

    private void showHistoryStats() {
        HistoryManager.CompressionStats stats = HistoryManager.getCompressionStats();
        long lastLogTime = HistoryManager.getLastLogTime();
        int statsWithHistory = HistoryManager.getStatsWithHistory().size();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a76=== History Statistics ==="));
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7eStats tracked: \u00a7f" + statsWithHistory)));
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7eTotal files: \u00a7f" + stats.getTotalFileCount())));
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7eCompressed: \u00a7a" + stats.compressedFileCount)));
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7eUncompressed: \u00a77" + stats.uncompressedFileCount)));
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7eTotal size: \u00a7f" + stats.getFormattedSize())));
            if (lastLogTime > 0L) {
                long secondsSinceLog = (System.currentTimeMillis() - lastLogTime) / 1000L;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7eLast log: \u00a7f" + secondsSinceLog + "s ago")));
            } else {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7eLast log: \u00a77Never"));
            }
        }
    }

    private void confirmClearHistory() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new ConfirmClearHistoryScreen(this));
        }
    }

    public void m_7379_() {
        if (this.hasChanges) {
            ModConfig.saveClientConfig();
        }
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return true;
    }

    private static /* synthetic */ void lambda$init$18(Button btn) {
    }

    private static /* synthetic */ Style lambda$init$17(Style style) {
        return style.m_131136_(Boolean.valueOf(true));
    }

    private static /* synthetic */ void lambda$init$14(Button btn) {
    }

    private static /* synthetic */ Style lambda$init$13(Style style) {
        return style.m_131136_(Boolean.valueOf(true));
    }

    private static /* synthetic */ void lambda$init$7(Button btn) {
    }

    private static /* synthetic */ Style lambda$init$6(Style style) {
        return style.m_131136_(Boolean.valueOf(true));
    }

    private static /* synthetic */ void lambda$init$1(Button btn) {
    }

    private static /* synthetic */ Style lambda$init$0(Style style) {
        return style.m_131136_(Boolean.valueOf(true));
    }

    private static class ConfirmClearHistoryScreen
    extends Screen {
        private final Screen parent;

        public ConfirmClearHistoryScreen(Screen parent) {
            super((Component)Component.m_237113_((String)"Confirm Clear History"));
            this.parent = parent;
        }

        protected void m_7856_() {
            super.m_7856_();
            int centerX = this.f_96543_ / 2;
            int centerY = this.f_96544_ / 2;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cYes, Clear All History"), btn -> {
                HistoryManager.clearAllHistory();
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aAll history has been cleared!"));
                }
                this.f_96541_.m_91152_(this.parent);
            }).m_252987_(centerX - 100, centerY + 20, 200, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX - 100, centerY + 45, 200, 20).m_253136_());
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(graphics);
            int centerX = this.f_96543_ / 2;
            int centerY = this.f_96544_ / 2;
            graphics.m_280137_(this.f_96547_, "\u00a7c\u00a7lWarning!", centerX, centerY - 40, 0xFFFFFF);
            graphics.m_280137_(this.f_96547_, "This will permanently delete all", centerX, centerY - 20, 0xFFFFFF);
            graphics.m_280137_(this.f_96547_, "history data for all statistics.", centerX, centerY - 5, 0xFFFFFF);
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }

        public boolean m_7043_() {
            return true;
        }
    }
}

