/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.client.gui.CustomStatEditorScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.CustomStatsHelpScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatImportExportScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatTemplatesScreen;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;

public class CustomStatScreen
extends Screen {
    private final Screen parent;
    private List<CustomStatDefinition> customStats;
    private CustomStatListWidget statList;
    private Button createButton;
    private Button deleteButton;
    private Button editButton;
    private Button toggleButton;
    private Button templatesButton;
    private Button backButton;
    private EditBox searchBox;
    private int selectedIndex = -1;

    public CustomStatScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Custom Statistics"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.customStats = new ArrayList<CustomStatDefinition>(CustomStatManager.getAllCustomStats());
        this.statList = new CustomStatListWidget(this.f_96541_, this.f_96543_, this.f_96544_ - 96, 32, this.f_96544_ - 64, 36);
        this.m_7787_((GuiEventListener)this.statList);
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 8, 200, 20, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search stats..."));
        this.searchBox.m_94151_(this::onSearchChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
        int buttonY = this.f_96544_ - 52;
        int buttonWidth = 75;
        int spacing = 5;
        int totalWidth = buttonWidth * 6 + spacing * 5;
        int startX = (this.f_96543_ - totalWidth) / 2;
        this.createButton = Button.m_253074_((Component)Component.m_237113_((String)"Create"), button -> this.openCreateStatScreen()).m_252987_(startX, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.createButton);
        this.templatesButton = Button.m_253074_((Component)Component.m_237113_((String)"Templates"), button -> this.openTemplatesScreen()).m_252987_(startX + buttonWidth + spacing, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.templatesButton);
        this.editButton = Button.m_253074_((Component)Component.m_237113_((String)"Edit"), button -> this.openEditStatScreen()).m_252987_(startX + (buttonWidth + spacing) * 2, buttonY, buttonWidth, 20).m_253136_();
        this.editButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.editButton);
        this.deleteButton = Button.m_253074_((Component)Component.m_237113_((String)"Delete"), button -> this.deleteStat()).m_252987_(startX + (buttonWidth + spacing) * 3, buttonY, buttonWidth, 20).m_253136_();
        this.deleteButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.deleteButton);
        this.toggleButton = Button.m_253074_((Component)Component.m_237113_((String)"Toggle"), button -> this.toggleStat()).m_252987_(startX + (buttonWidth + spacing) * 4, buttonY, buttonWidth, 20).m_253136_();
        this.toggleButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.toggleButton);
        Button importExportButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a76Import/Export"), button -> this.openImportExportScreen()).m_252987_(startX + (buttonWidth + spacing) * 5, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)importExportButton);
        this.backButton = Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(startX + (buttonWidth + spacing) * 6, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.backButton);
        Button helpButton = Button.m_253074_((Component)Component.m_237113_((String)"?"), button -> this.openHelpScreen()).m_252987_(this.f_96543_ - 30, 8, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)helpButton);
        this.refreshList();
    }

    private void onSearchChanged(String search) {
        this.refreshList();
    }

    private void refreshList() {
        String search = this.searchBox.m_94155_().toLowerCase();
        ArrayList<CustomStatDefinition> filtered = new ArrayList<CustomStatDefinition>();
        for (CustomStatDefinition stat : CustomStatManager.getAllCustomStats()) {
            if (!search.isEmpty() && !stat.getName().toLowerCase().contains(search) && !stat.getDescription().toLowerCase().contains(search) && !stat.getCategory().toLowerCase().contains(search)) continue;
            filtered.add(stat);
        }
        this.customStats = filtered;
        this.statList.setStats(filtered);
    }

    private void openCreateStatScreen() {
        this.f_96541_.m_91152_((Screen)new CustomStatEditorScreen(this, null));
    }

    private void openEditStatScreen() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.customStats.size()) {
            CustomStatDefinition stat = this.customStats.get(this.selectedIndex);
            this.f_96541_.m_91152_((Screen)new CustomStatEditorScreen(this, stat));
        }
    }

    private void deleteStat() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.customStats.size()) {
            CustomStatDefinition stat = this.customStats.get(this.selectedIndex);
            CustomStatManager.deleteCustomStat(stat.getId());
            this.selectedIndex = -1;
            this.updateButtonStates();
            this.refreshList();
        }
    }

    private void toggleStat() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.customStats.size()) {
            CustomStatDefinition stat;
            stat.setEnabled(!(stat = this.customStats.get(this.selectedIndex)).isEnabled());
            CustomStatManager.updateCustomStat(stat);
            this.refreshList();
        }
    }

    private void openTemplatesScreen() {
        this.f_96541_.m_91152_((Screen)new StatTemplatesScreen(this));
    }

    private void openImportExportScreen() {
        this.f_96541_.m_91152_((Screen)new StatImportExportScreen(this));
    }

    private void openHelpScreen() {
        this.f_96541_.m_91152_((Screen)new CustomStatsHelpScreen(this));
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        boolean hasSelection;
        this.editButton.f_93623_ = hasSelection = this.selectedIndex >= 0 && this.selectedIndex < this.customStats.size();
        this.deleteButton.f_93623_ = hasSelection;
        this.toggleButton.f_93623_ = hasSelection;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.statList.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 12, 0xFFFFFF);
        String countText = this.customStats.size() + " custom stat" + (this.customStats.size() == 1 ? "" : "s");
        graphics.m_280488_(this.f_96547_, countText, 10, this.f_96544_ - 26, 0xAAAAAA);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.selectedIndex >= 0 && this.selectedIndex < this.customStats.size()) {
            CustomStatDefinition stat = this.customStats.get(this.selectedIndex);
            int tooltipX = 10;
            int tooltipY = this.f_96544_ - 90;
            graphics.m_280488_(this.f_96547_, "Selected: " + stat.getName(), tooltipX, tooltipY, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "Type: " + stat.getTrackingType().getDisplayName(), tooltipX, tooltipY + 12, 0xAAAAAA);
            graphics.m_280488_(this.f_96547_, "Value: " + stat.getFormattedValue(), tooltipX, tooltipY + 24, 0xAAAAAA);
            graphics.m_280488_(this.f_96547_, "Status: " + (stat.isEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"), tooltipX, tooltipY + 36, 0xAAAAAA);
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private class CustomStatListWidget
    extends ObjectSelectionList<Entry> {
        private List<CustomStatDefinition> stats;

        public CustomStatListWidget(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.stats = new ArrayList<CustomStatDefinition>();
        }

        public void setStats(List<CustomStatDefinition> stats) {
            this.m_93516_();
            this.stats = stats;
            for (int i = 0; i < stats.size(); ++i) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry(stats.get(i), i));
            }
        }

        public int m_5759_() {
            return this.f_93388_ - 20;
        }

        protected int m_5756_() {
            return this.f_93388_ - 6;
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final CustomStatDefinition stat;
            private final int index;

            public Entry(CustomStatDefinition stat, int index) {
                this.stat = stat;
                this.index = index;
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                ConditionGroup group;
                int backgroundColor = hovering ? 0x40FFFFFF : (this.stat.isEnabled() ? 0x20FFFFFF : 0x10808080);
                graphics.m_280509_(left, top, left + width, top + height, backgroundColor);
                Object name = this.stat.getName();
                if (((String)name).length() > 30) {
                    name = ((String)name).substring(0, 27) + "...";
                }
                graphics.m_280488_(((CustomStatListWidget)CustomStatListWidget.this).f_93386_.f_91062_, (String)name, left + 5, top + 2, this.stat.isEnabled() ? 0xFFFFFF : 0x808080);
                String info = this.stat.getTrackingType().getDisplayName() + " | " + this.stat.getCategory();
                graphics.m_280488_(((CustomStatListWidget)CustomStatListWidget.this).f_93386_.f_91062_, info, left + 5, top + 13, 0xAAAAAA);
                String value = this.stat.getFormattedValue();
                int valueWidth = ((CustomStatListWidget)CustomStatListWidget.this).f_93386_.f_91062_.m_92895_(value);
                graphics.m_280488_(((CustomStatListWidget)CustomStatListWidget.this).f_93386_.f_91062_, value, left + width - valueWidth - 5, top + 8, 0x55FF55);
                int targetCount = this.stat.getTargets().size();
                if (targetCount > 0) {
                    String targetsText = targetCount + " target" + (targetCount == 1 ? "" : "s");
                    graphics.m_280488_(((CustomStatListWidget)CustomStatListWidget.this).f_93386_.f_91062_, targetsText, left + 5, top + 24, 0x888888);
                }
                if ((group = this.stat.getConditionGroup()) != null && !group.isEmpty()) {
                    int conditionCount;
                    String conditionsText = conditionCount + " condition" + ((conditionCount = group.getConditions().size()) == 1 ? "" : "s");
                    int condX = left + width - ((CustomStatListWidget)CustomStatListWidget.this).f_93386_.f_91062_.m_92895_(conditionsText) - 5;
                    graphics.m_280488_(((CustomStatListWidget)CustomStatListWidget.this).f_93386_.f_91062_, conditionsText, condX, top + 24, 0x888888);
                }
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.stat.getName());
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                CustomStatScreen.this.setSelectedIndex(this.index);
                return true;
            }
        }
    }
}

