/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class CustomStatsHelpScreen
extends Screen {
    private final Screen parent;
    private int scrollOffset = 0;
    private static final int SCROLL_SPEED = 10;
    private static final String[] HELP_CONTENT = new String[]{"\u00a7lCustom Statistics Help", "", "\u00a7eWhat are Custom Stats?", "Custom statistics let you track anything in Minecraft. From basic", "block mining to complex conditions like 'mine diamonds in the Nether'.", "", "\u00a7eCreating a Custom Stat:", "1. Click \u00a7a'Create'\u00a77 to start a new custom stat", "2. Give it a \u00a7aname\u00a77 and \u00a7adescription", "3. Choose an \u00a7aicon\u00a77 by clicking the '...' button", "4. Select what to \u00a7atrack\u00a77 (blocks, items, entities, etc.)", "5. Add \u00a7atargets\u00a77 (what specific things to track)", "6. Add \u00a7aconditions\u00a77 (when to track)", "7. Click \u00a7aSave", "", "\u00a7eConditions:", "Control when your stat tracks. Examples:", "\u2022 Track only in specific biomes", "\u2022 Track only below Y level 0", "\u2022 Track only during night time", "\u2022 Track only while holding specific items", "", "You can combine multiple conditions with AND/OR logic!", "", "\u00a7eTracking Types:", "\u00a7aBlock Mined\u00a77 - Tracks when blocks are broken", "\u00a7aBlock Placed\u00a77 - Tracks when blocks are placed", "\u00a7aItem Used\u00a77 - Tracks when items are used", "\u00a7aItem Crafted\u00a77 - Tracks when items are crafted", "\u00a7aEntity Killed\u00a77 - Tracks when entities are killed", "\u00a7aDistance Traveled\u00a77 - Tracks movement", "\u00a7aTime Elapsed\u00a77 - Tracks time spent (ticks)", "\u00a7aDamage Dealt\u00a77 - Tracks damage dealt to entities", "", "\u00a7eAggregation Types:", "\u00a7aSum\u00a77 - Add all values together", "\u00a7aIndividual\u00a77 - Track each target separately", "\u00a7aAverage\u00a77 - Calculate average of all targets", "\u00a7aMax\u00a77 - Track only the highest value", "\u00a7aMin\u00a77 - Track only the lowest value", "", "\u00a7eFormat Types:", "\u00a7aNumber\u00a77 - Display as plain number (1,234)", "\u00a7aTime\u00a77 - Display as time (1h 23m 45s)", "\u00a7aDistance\u00a77 - Display as distance (123.4m)", "\u00a7aPercentage\u00a77 - Display as percentage (12.3%)", "", "\u00a7eGoals:", "Set achievement milestones for your stats!", "When you reach a goal, you'll get a notification.", "", "\u00a7eTemplates:", "Use pre-made templates to quickly create common stats.", "Templates include popular tracking scenarios like:", "\u2022 Ore mining", "\u2022 Mob hunting", "\u2022 Underground exploration", "\u2022 Nether time", "", "\u00a7eTips:", "\u2022 Use wildcards (*) to track all items/blocks", "\u2022 Combine conditions for complex tracking", "\u2022 Set goals to make stats more rewarding", "\u2022 Use colors to organize your stats", "\u2022 Pin important stats to keep them visible", "", "\u00a7eModded Content:", "Custom stats work with ANY mod!", "Just use the mod's resource IDs:", "\u2022 Items: \u00a7acreate:wrench", "\u2022 Biomes: \u00a7abiomesoplenty:lavender_field", "\u2022 Dimensions: \u00a7atwilight forest:twilight_forest", "", "\u00a77Press ESC or click Close to return"};

    public CustomStatsHelpScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Custom Stats Help"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        Button closeButton = Button.m_253074_((Component)Component.m_237113_((String)"Close"), btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ - 30, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)closeButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int contentHeight;
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int startY = 20 + this.scrollOffset;
        int lineHeight = 12;
        for (int i = 0; i < HELP_CONTENT.length; ++i) {
            int y = startY + i * lineHeight;
            if (y < 10 || y > this.f_96544_ - 50) continue;
            String line = HELP_CONTENT[i];
            if (line.startsWith("\u00a7l")) {
                graphics.m_280137_(this.f_96547_, line, centerX, y, 0xFFFFFF);
                continue;
            }
            if (line.startsWith("\u00a7e")) {
                graphics.m_280488_(this.f_96547_, line, 20, y, 0xFFFF55);
                continue;
            }
            if (line.startsWith("\u00a7a")) {
                graphics.m_280488_(this.f_96547_, line, 40, y, 0x55FF55);
                continue;
            }
            graphics.m_280488_(this.f_96547_, line, 40, y, 0xAAAAAA);
        }
        if (this.scrollOffset < 0) {
            graphics.m_280137_(this.f_96547_, "\u00a77\u25b2 Scroll up for more", centerX, 10, 0xFFFFFF);
        }
        if (this.scrollOffset > -((contentHeight = HELP_CONTENT.length * lineHeight) - this.f_96544_ + 100)) {
            graphics.m_280137_(this.f_96547_, "\u00a77\u25bc Scroll down for more", centerX, this.f_96544_ - 45, 0xFFFFFF);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollOffset += (int)(delta * 10.0);
        int contentHeight = HELP_CONTENT.length * 12;
        int maxScroll = 0;
        int minScroll = -(contentHeight - this.f_96544_ + 100);
        this.scrollOffset = Math.max(minScroll, Math.min(maxScroll, this.scrollOffset));
        return true;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }
}

