/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConditionDetailScreen;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class ScratchBlockEditorScreen
extends Screen {
    private final Screen parent;
    private final ConditionalBlock rootBlock;
    private final Consumer<ConditionalBlock> onSave;
    private BlockListWidget blockList;
    private ConditionalBlock selectedBlock;
    private ConditionalBlock draggedBlock;
    private int dragOffsetX;
    private int dragOffsetY;
    private boolean showDebugger = true;
    private Button toggleDebuggerButton;
    private Button addIfButton;
    private Button addAndButton;
    private Button addOrButton;
    private Button addNotButton;
    private Button addElseButton;
    private Button editButton;
    private Button deleteButton;
    private Button doneButton;
    private int scrollOffset = 0;

    public ScratchBlockEditorScreen(Screen parent, ConditionalBlock rootBlock, Consumer<ConditionalBlock> onSave) {
        super((Component)Component.m_237113_((String)"Visual Condition Editor"));
        this.parent = parent;
        this.rootBlock = rootBlock != null ? rootBlock : new ConditionalBlock();
        this.onSave = onSave;
    }

    public static ScratchBlockEditorScreen fromConditionGroup(Screen parent, ConditionGroup group, Consumer<ConditionGroup> onSave) {
        ConditionalBlock block = ConditionalBlock.fromConditionGroup(group);
        return new ScratchBlockEditorScreen(parent, block, resultBlock -> onSave.accept(resultBlock.toConditionGroup()));
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int topY = 40;
        String info = "Build your conditions like Scratch blocks!";
        int buttonY = topY + 20;
        int buttonWidth = 60;
        int spacing = 5;
        int startX = centerX - (buttonWidth * 5 + spacing * 4) / 2;
        this.addIfButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a79+ If"), btn -> this.addBlock(ConditionalBlock.BlockType.IF)).m_252987_(startX, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.addIfButton);
        this.addAndButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7a+ And"), btn -> this.addBlock(ConditionalBlock.BlockType.AND)).m_252987_(startX + (buttonWidth + spacing), buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.addAndButton);
        this.addOrButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a76+ Or"), btn -> this.addBlock(ConditionalBlock.BlockType.OR)).m_252987_(startX + (buttonWidth + spacing) * 2, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.addOrButton);
        this.addNotButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7c+ Not"), btn -> this.addBlock(ConditionalBlock.BlockType.NOT)).m_252987_(startX + (buttonWidth + spacing) * 3, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.addNotButton);
        this.addElseButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a77+ Else"), btn -> this.addElseBlock()).m_252987_(startX + (buttonWidth + spacing) * 4, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.addElseButton);
        int listTop = buttonY + 35;
        int listHeight = this.f_96544_ - listTop - 60;
        this.blockList = new BlockListWidget(this.f_96541_, this.f_96543_ - 40, listHeight, listTop, this.f_96544_ - 60, 60);
        this.blockList.setRootBlock(this.rootBlock);
        this.m_142416_((GuiEventListener)this.blockList);
        int bottomY = this.f_96544_ - 30;
        int bottomButtonWidth = 70;
        this.editButton = Button.m_253074_((Component)Component.m_237113_((String)"Edit"), btn -> this.editSelectedBlock()).m_252987_(centerX - bottomButtonWidth * 2 - 15, bottomY, bottomButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.editButton);
        this.deleteButton = Button.m_253074_((Component)Component.m_237113_((String)"Delete"), btn -> this.deleteSelectedBlock()).m_252987_(centerX - bottomButtonWidth - 5, bottomY, bottomButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.deleteButton);
        Button clearButton = Button.m_253074_((Component)Component.m_237113_((String)"Clear All"), btn -> this.clearAll()).m_252987_(centerX + 5, bottomY, bottomButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)clearButton);
        this.doneButton = Button.m_253074_((Component)Component.m_237113_((String)"Done"), btn -> this.save()).m_252987_(centerX + bottomButtonWidth + 15, bottomY, bottomButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.doneButton);
        this.updateButtonStates();
    }

    private void addBlock(ConditionalBlock.BlockType type) {
        ConditionalBlock newBlock = new ConditionalBlock(type);
        if (this.selectedBlock != null) {
            this.selectedBlock.addChild(newBlock);
        } else {
            this.rootBlock.addChild(newBlock);
        }
        this.openDetailEditor(newBlock);
    }

    private void addElseBlock() {
        if (this.selectedBlock != null && this.selectedBlock.getType() == ConditionalBlock.BlockType.IF) {
            ConditionalBlock elseBlock = new ConditionalBlock(ConditionalBlock.BlockType.ELSE);
            this.selectedBlock.setElseBlock(elseBlock);
            this.refreshList();
        }
    }

    private void editSelectedBlock() {
        if (this.selectedBlock != null) {
            this.openDetailEditor(this.selectedBlock);
        }
    }

    private void openDetailEditor(ConditionalBlock block) {
        if (block.getType() != ConditionalBlock.BlockType.ELSE) {
            StatCondition condition = block.getCondition();
            if (condition == null) {
                condition = new StatCondition();
                block.setCondition(condition);
            }
            this.f_96541_.m_91152_((Screen)new ConditionDetailScreen(this, condition, updatedCondition -> {
                block.setCondition((StatCondition)updatedCondition);
                this.refreshList();
            }));
        }
    }

    private void deleteSelectedBlock() {
        if (this.selectedBlock != null && this.selectedBlock != this.rootBlock) {
            this.removeBlockFromTree(this.rootBlock, this.selectedBlock);
            this.selectedBlock = null;
            this.refreshList();
            this.updateButtonStates();
        }
    }

    private boolean removeBlockFromTree(ConditionalBlock parent, ConditionalBlock toRemove) {
        if (parent.getChildren().remove(toRemove)) {
            return true;
        }
        for (ConditionalBlock child : parent.getChildren()) {
            if (!this.removeBlockFromTree(child, toRemove)) continue;
            return true;
        }
        if (parent.getElseBlock() == toRemove) {
            parent.setElseBlock(null);
            return true;
        }
        return false;
    }

    private void clearAll() {
        this.rootBlock.getChildren().clear();
        this.rootBlock.setElseBlock(null);
        this.selectedBlock = null;
        this.refreshList();
        this.updateButtonStates();
    }

    private void refreshList() {
        this.blockList.setRootBlock(this.rootBlock);
    }

    private void save() {
        this.onSave.accept(this.rootBlock);
        this.f_96541_.m_91152_(this.parent);
    }

    private void updateButtonStates() {
        boolean hasSelection = this.selectedBlock != null;
        this.editButton.f_93623_ = hasSelection && this.selectedBlock.getType() != ConditionalBlock.BlockType.ELSE;
        this.deleteButton.f_93623_ = hasSelection && this.selectedBlock != this.rootBlock;
        this.addElseButton.f_93623_ = hasSelection && this.selectedBlock.getType() == ConditionalBlock.BlockType.IF && !this.selectedBlock.hasElse();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        String instructions = "\u00a77Click blocks to select \u2022 Use buttons to add blocks \u2022 Nest blocks for AND/OR logic";
        graphics.m_280137_(this.f_96547_, instructions, this.f_96543_ / 2, 30, 0x888888);
        int totalBlocks = this.rootBlock.getTotalBlockCount() - 1;
        String countText = totalBlocks + " block" + (totalBlocks == 1 ? "" : "s");
        graphics.m_280488_(this.f_96547_, countText, 20, 80, 0xAAAAAA);
        if (this.selectedBlock != null) {
            String selectedInfo = "\u00a7eSelected: \u00a7f" + this.selectedBlock.getType().getDisplayName();
            graphics.m_280488_(this.f_96547_, selectedInfo, this.f_96543_ - this.f_96547_.m_92895_(selectedInfo) - 20, 80, 0xFFFFFF);
            if (this.selectedBlock.hasCondition()) {
                String condPreview = "\u00a77" + this.selectedBlock.getCondition().toString();
                if (condPreview.length() > 50) {
                    condPreview = condPreview.substring(0, 47) + "...";
                }
                int previewX = this.f_96543_ - this.f_96547_.m_92895_(condPreview) - 20;
                graphics.m_280488_(this.f_96547_, condPreview, previewX, 95, 0xAAAAAA);
            }
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.addIfButton.m_5953_((double)mouseX, (double)mouseY)) {
            graphics.m_280666_(this.f_96547_, List.of(Component.m_237113_((String)"\u00a79IF Block"), Component.m_237113_((String)"\u00a77Main condition block"), Component.m_237113_((String)"\u00a77Can have children and ELSE")), mouseX, mouseY);
        } else if (this.addAndButton.m_5953_((double)mouseX, (double)mouseY)) {
            graphics.m_280666_(this.f_96547_, List.of(Component.m_237113_((String)"\u00a7aAND Block"), Component.m_237113_((String)"\u00a77All conditions must be true")), mouseX, mouseY);
        } else if (this.addOrButton.m_5953_((double)mouseX, (double)mouseY)) {
            graphics.m_280666_(this.f_96547_, List.of(Component.m_237113_((String)"\u00a76OR Block"), Component.m_237113_((String)"\u00a77At least one must be true")), mouseX, mouseY);
        } else if (this.addNotButton.m_5953_((double)mouseX, (double)mouseY)) {
            graphics.m_280666_(this.f_96547_, List.of(Component.m_237113_((String)"\u00a7cNOT Block"), Component.m_237113_((String)"\u00a77Inverts the condition")), mouseX, mouseY);
        } else if (this.addElseButton.m_5953_((double)mouseX, (double)mouseY)) {
            graphics.m_280666_(this.f_96547_, List.of(Component.m_237113_((String)"\u00a77ELSE Block"), Component.m_237113_((String)"\u00a77Default when IF is false")), mouseX, mouseY);
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private class BlockListWidget
    extends ObjectSelectionList<BlockEntry> {
        public BlockListWidget(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
        }

        public void setRootBlock(ConditionalBlock root) {
            this.m_93516_();
            this.addBlocksRecursively(root, 0);
        }

        private void addBlocksRecursively(ConditionalBlock block, int depth) {
            for (ConditionalBlock child : block.getChildren()) {
                this.m_7085_((AbstractSelectionList.Entry)new BlockEntry(child, depth));
                if (child.hasChildren()) {
                    this.addBlocksRecursively(child, depth + 1);
                }
                if (!child.hasElse()) continue;
                this.m_7085_((AbstractSelectionList.Entry)new BlockEntry(child.getElseBlock(), depth));
            }
        }

        public class BlockEntry
        extends ObjectSelectionList.Entry<BlockEntry> {
            private final ConditionalBlock block;
            private final int depth;

            public BlockEntry(ConditionalBlock block, int depth) {
                this.block = block;
                this.depth = depth;
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                boolean selected = this.block == ScratchBlockEditorScreen.this.selectedBlock;
                int indent = this.depth * 30;
                int blockLeft = left + indent + 20;
                int blockWidth = width - indent - 40;
                int blockHeight = 50;
                int bgColor = this.parseColor(this.block.getColor());
                if (selected) {
                    bgColor = this.lightenColor(bgColor);
                }
                if (isHovering && !selected) {
                    bgColor = this.lightenColor(bgColor, 0.2f);
                }
                graphics.m_280509_(blockLeft, top, blockLeft + blockWidth, top + blockHeight, bgColor);
                graphics.m_280637_(blockLeft, top, blockWidth, blockHeight, -16777216);
                String typeText = this.block.getType().getDisplayName();
                graphics.m_280488_(((BlockListWidget)BlockListWidget.this).f_93386_.f_91062_, "\u00a7l" + typeText, blockLeft + 10, top + 5, 0xFFFFFF);
                if (this.block.hasCondition()) {
                    StatCondition condition = this.block.getCondition();
                    String condText = condition.getType().getDisplayName() + " " + condition.getOperator().getSymbol() + " " + condition.getValue();
                    if (condText.length() > 40) {
                        condText = condText.substring(0, 37) + "...";
                    }
                    graphics.m_280488_(((BlockListWidget)BlockListWidget.this).f_93386_.f_91062_, "\u00a77" + condText, blockLeft + 10, top + 20, 0xFFFFFF);
                }
                if (this.block.hasChildren()) {
                    String childText = "[" + this.block.getChildren().size() + " nested]";
                    graphics.m_280488_(((BlockListWidget)BlockListWidget.this).f_93386_.f_91062_, "\u00a7e" + childText, blockLeft + 10, top + 35, 0xFFFFFF);
                }
                if (this.block.hasElse()) {
                    String elseText = "[has else]";
                    int elseX = blockLeft + blockWidth - ((BlockListWidget)BlockListWidget.this).f_93386_.f_91062_.m_92895_(elseText) - 10;
                    graphics.m_280488_(((BlockListWidget)BlockListWidget.this).f_93386_.f_91062_, "\u00a77" + elseText, elseX, top + 35, 0xFFFFFF);
                }
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.block.toString());
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                ScratchBlockEditorScreen.this.selectedBlock = this.block;
                ScratchBlockEditorScreen.this.updateButtonStates();
                return true;
            }

            private int parseColor(String hex) {
                try {
                    return (int)Long.parseLong(hex.substring(1), 16) | 0xFF000000;
                }
                catch (Exception e) {
                    return -11890462;
                }
            }

            private int lightenColor(int color) {
                return this.lightenColor(color, 0.3f);
            }

            private int lightenColor(int color, float amount) {
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                r = Math.min(255, (int)((float)r + (float)(255 - r) * amount));
                g = Math.min(255, (int)((float)g + (float)(255 - g) * amount));
                b = Math.min(255, (int)((float)b + (float)(255 - b) * amount));
                return 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
    }
}

