/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;

public class SnapshotDetailScreen
extends Screen {
    private static final int ENTRY_HEIGHT = 20;
    private static final int PADDING = 10;
    private final Screen parent;
    private final SnapshotManager.SnapshotInfo info;
    private final SnapshotManager.SnapshotData data;
    private final List<Map.Entry<String, Long>> statEntries;
    private int scrollOffset = 0;
    private String searchQuery = "";

    public SnapshotDetailScreen(Screen parent, SnapshotManager.SnapshotInfo info, SnapshotManager.SnapshotData data) {
        super((Component)Component.m_237113_((String)("Snapshot: " + info.filename)));
        this.parent = parent;
        this.info = info;
        this.data = data;
        this.statEntries = new ArrayList<Map.Entry<String, Long>>(data.stats.entrySet());
        this.statEntries.sort((a, b) -> Long.compare((Long)b.getValue(), (Long)a.getValue()));
    }

    protected void m_7856_() {
        super.m_7856_();
        Button backButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), btn -> this.m_7379_()).m_252987_((this.f_96543_ - 200) / 2, this.f_96544_ - 30, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)backButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        this.renderInfoBar(graphics);
        this.renderStatList(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void renderInfoBar(GuiGraphics graphics) {
        int y = 30;
        String playerText = "Player: " + this.data.playerName;
        String timeText = "Date: " + this.info.getFormattedTimestamp();
        String countText = "Statistics: " + this.data.stats.size();
        graphics.m_280488_(this.f_96547_, playerText, 10, y, 0xCCCCCC);
        graphics.m_280488_(this.f_96547_, timeText, this.f_96543_ / 2 - this.f_96547_.m_92895_(timeText) / 2, y, 0xCCCCCC);
        graphics.m_280488_(this.f_96547_, countText, this.f_96543_ - 10 - this.f_96547_.m_92895_(countText), y, 0xCCCCCC);
    }

    private void renderStatList(GuiGraphics graphics) {
        int listX = 10;
        int listY = 50;
        int listWidth = this.f_96543_ - 20;
        int listHeight = this.f_96544_ - 90;
        graphics.m_280509_(listX, listY, listX + listWidth, listY + listHeight, Integer.MIN_VALUE);
        graphics.m_280488_(this.f_96547_, "Statistic", listX + 10, listY + 5, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Value", listX + listWidth - 10 - 60, listY + 5, 0xFFFFFF);
        graphics.m_280509_(listX, listY + 18, listX + listWidth, listY + 19, -12566464);
        int entryY = listY + 22 - this.scrollOffset;
        for (Map.Entry<String, Long> entry : this.statEntries) {
            if (entryY + 20 < listY + 22 || entryY > listY + listHeight) {
                entryY += 20;
                continue;
            }
            Object statName = entry.getKey();
            if (this.f_96547_.m_92895_((String)statName) > listWidth - 100) {
                statName = this.f_96547_.m_92834_((String)statName, listWidth - 100) + "...";
            }
            graphics.m_280488_(this.f_96547_, (String)statName, listX + 10, entryY, 0xCCCCCC);
            String value = String.valueOf(entry.getValue());
            graphics.m_280488_(this.f_96547_, value, listX + listWidth - 10 - this.f_96547_.m_92895_(value), entryY, 0xFFFFFF);
            entryY += 20;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int maxScroll = Math.max(0, this.statEntries.size() * 20 - (this.f_96544_ - 112));
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

