/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class StatComparisonScreen
extends Screen {
    private static final int COLUMN_WIDTH = 200;
    private static final int ENTRY_HEIGHT = 20;
    private static final int PADDING = 10;
    private final Screen parent;
    private final String player1Name;
    private final Map<String, Long> player1Stats;
    private final String player2Name;
    private final Map<String, Long> player2Stats;
    private int scrollOffset = 0;
    private final List<ComparisonEntry> entries;

    public StatComparisonScreen(Screen parent, String player1Name, Map<String, Long> player1Stats, String player2Name, Map<String, Long> player2Stats) {
        super((Component)Component.m_237113_((String)"Stat Comparison"));
        this.parent = parent;
        this.player1Name = player1Name;
        this.player1Stats = player1Stats;
        this.player2Name = player2Name;
        this.player2Stats = player2Stats;
        this.entries = new ArrayList<ComparisonEntry>();
        this.buildComparisonEntries();
    }

    private void buildComparisonEntries() {
        HashMap<String, Long> allStats = new HashMap<String, Long>(this.player1Stats);
        this.player2Stats.forEach(allStats::putIfAbsent);
        for (String statKey : allStats.keySet()) {
            long value1 = this.player1Stats.getOrDefault(statKey, 0L);
            long value2 = this.player2Stats.getOrDefault(statKey, 0L);
            if (value1 == 0L && value2 == 0L) continue;
            this.entries.add(new ComparisonEntry(statKey, value1, value2));
        }
        this.entries.sort((a, b) -> Long.compare(Math.abs(b.value2 - b.value1), Math.abs(a.value2 - a.value1)));
    }

    protected void m_7856_() {
        super.m_7856_();
        Button backButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), btn -> this.m_7379_()).m_252987_((this.f_96543_ - 200) / 2, this.f_96544_ - 30, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)backButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        int headerY = 30;
        int col1X = this.f_96543_ / 2 - 200 - 50;
        int col2X = this.f_96543_ / 2 + 50;
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)("\u00a7b" + this.player1Name)), col1X + 100, headerY, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)("\u00a7b" + this.player2Name)), col2X + 100, headerY, 0xFFFFFF);
        this.renderComparisonList(graphics, col1X, col2X);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void renderComparisonList(GuiGraphics graphics, int col1X, int col2X) {
        int listY = 50;
        int listHeight = this.f_96544_ - 90;
        graphics.m_280509_(col1X - 10, listY, col2X + 200 + 10, listY + listHeight, Integer.MIN_VALUE);
        int entryY = listY + 10 - this.scrollOffset;
        for (ComparisonEntry entry : this.entries) {
            if (entryY + 20 < listY || entryY > listY + listHeight) {
                entryY += 20;
                continue;
            }
            String statName = this.formatStatName(entry.statKey);
            int nameX = this.f_96543_ / 2 - this.f_96547_.m_92895_(statName) / 2;
            graphics.m_280488_(this.f_96547_, statName, nameX, entryY + 5, 0xCCCCCC);
            String value1Str = StatFormatter.formatValue(entry.value1);
            int value1Color = entry.value1 > entry.value2 ? 65280 : (entry.value1 < entry.value2 ? 0xFF0000 : 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, value1Str, col1X + 200 - this.f_96547_.m_92895_(value1Str), entryY + 5, value1Color);
            String value2Str = StatFormatter.formatValue(entry.value2);
            int value2Color = entry.value2 > entry.value1 ? 65280 : (entry.value2 < entry.value1 ? 0xFF0000 : 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, value2Str, col2X, entryY + 5, value2Color);
            long diff = entry.value2 - entry.value1;
            if (diff != 0L) {
                String diffStr = (diff > 0L ? "+" : "") + StatFormatter.formatValue(diff);
                graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)("\u00a77(" + diffStr + ")")), col2X + 200 + 10, entryY + 5, 0x888888);
            }
            entryY += 20;
        }
    }

    private String formatStatName(String statKey) {
        String[] parts = statKey.split("[:/]");
        if (parts.length > 0) {
            String name = parts[parts.length - 1];
            return name.replace("_", " ").substring(0, 1).toUpperCase() + name.replace("_", " ").substring(1);
        }
        return statKey;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int maxScroll = Math.max(0, this.entries.size() * 20 - (this.f_96544_ - 140));
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private static class ComparisonEntry {
        final String statKey;
        final long value1;
        final long value2;

        ComparisonEntry(String statKey, long value1, long value2) {
            this.statKey = statKey;
            this.value1 = value1;
            this.value2 = value2;
        }
    }
}

