/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;
import org.texboobcat.beautiful_statistics_screen.custom.StatImportExport;

public class StatImportExportScreen
extends Screen {
    private final Screen parent;
    private final CustomStatDefinition singleStat;
    private ImportExportListWidget listWidget;
    private EditBox filenameField;
    private String statusMessage = "";
    private long statusMessageTime = 0L;
    private boolean statusIsError = false;
    private boolean exportMode = true;

    public StatImportExportScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.import_export"));
        this.parent = parent;
        this.singleStat = null;
    }

    public StatImportExportScreen(Screen parent, CustomStatDefinition stat) {
        super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.import_export_single"));
        this.parent = parent;
        this.singleStat = stat;
    }

    protected void m_7856_() {
        super.m_7856_();
        int toggleY = 40;
        int toggleWidth = 100;
        int centerX = this.f_96543_ / 2;
        Button exportModeButton = Button.m_253074_((Component)(this.exportMode ? Component.m_237115_((String)"gui.beautiful_statistics_screen.export.mode").m_6881_().m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_178520_(0x55FF55)) : Component.m_237115_((String)"gui.beautiful_statistics_screen.export.mode")), btn -> {
            this.exportMode = true;
            this.m_232761_();
        }).m_252987_(centerX - toggleWidth - 5, toggleY, toggleWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)exportModeButton);
        Button importModeButton = Button.m_253074_((Component)(!this.exportMode ? Component.m_237115_((String)"gui.beautiful_statistics_screen.import.mode").m_6881_().m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_178520_(0x55FF55)) : Component.m_237115_((String)"gui.beautiful_statistics_screen.import.mode")), btn -> {
            this.exportMode = false;
            this.m_232761_();
        }).m_252987_(centerX + 5, toggleY, toggleWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)importModeButton);
        if (this.exportMode) {
            this.filenameField = new EditBox(this.f_96547_, centerX - 150, 70, 300, 20, (Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.export.filename"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            Object defaultName = this.singleStat != null ? this.singleStat.getName().replaceAll("[^a-zA-Z0-9_-]", "_") : "all_stats_" + sdf.format(new Date());
            this.filenameField.m_94144_((String)defaultName);
            this.filenameField.m_94199_(50);
            this.m_142416_((GuiEventListener)this.filenameField);
        }
        int listTop = this.exportMode ? 100 : 70;
        int listBottom = this.f_96544_ - 70;
        this.listWidget = new ImportExportListWidget(this.f_96541_, this.f_96543_ - 40, listBottom - listTop, listTop, listBottom, 25);
        if (this.exportMode) {
            ArrayList<CustomStatDefinition> allStats = new ArrayList<CustomStatDefinition>(CustomStatManager.getAllCustomStats());
            for (CustomStatDefinition stat : allStats) {
                this.listWidget.addExportEntry(stat);
            }
        } else {
            List<String> files = StatImportExport.getAvailableImports();
            for (String file : files) {
                this.listWidget.addImportEntry(file);
            }
        }
        this.m_142416_((GuiEventListener)this.listWidget);
        int bottomY = this.f_96544_ - 35;
        if (this.exportMode) {
            if (this.singleStat != null) {
                Button exportButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.export.this_stat"), btn -> this.exportSingleStat()).m_252987_(centerX - 160, bottomY, 150, 20).m_253136_();
                this.m_142416_((GuiEventListener)exportButton);
            } else {
                Button exportSelectedButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.export.selected"), btn -> this.exportSelected()).m_252987_(centerX - 160, bottomY, 150, 20).m_253136_();
                this.m_142416_((GuiEventListener)exportSelectedButton);
                Button exportAllButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.export.all"), btn -> this.exportAll()).m_252987_(centerX - 5, bottomY, 150, 20).m_253136_();
                this.m_142416_((GuiEventListener)exportAllButton);
            }
        } else {
            Button importButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.import.selected"), btn -> this.importSelected()).m_252987_(centerX - 75, bottomY, 150, 20).m_253136_();
            this.m_142416_((GuiEventListener)importButton);
        }
        Button closeButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.close"), btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ - 80, bottomY, 70, 20).m_253136_();
        this.m_142416_((GuiEventListener)closeButton);
    }

    private void exportSingleStat() {
        String filename = this.filenameField.m_94155_().trim();
        if (filename.isEmpty()) {
            this.showError("Please enter a filename");
            return;
        }
        boolean success = StatImportExport.exportStat(this.singleStat, filename);
        if (success) {
            this.showSuccess("Exported: " + filename + ".customstat");
        } else {
            this.showError("Failed to export stat");
        }
    }

    private void exportSelected() {
        List<CustomStatDefinition> selected = this.listWidget.getSelectedStats();
        if (selected.isEmpty()) {
            this.showError("No stats selected");
            return;
        }
        String filename = this.filenameField.m_94155_().trim();
        if (filename.isEmpty()) {
            this.showError("Please enter a filename");
            return;
        }
        boolean success = StatImportExport.exportStats(selected, filename);
        if (success) {
            this.showSuccess("Exported " + selected.size() + " stat(s)");
        } else {
            this.showError("Failed to export stats");
        }
    }

    private void exportAll() {
        String filename = this.filenameField.m_94155_().trim();
        if (filename.isEmpty()) {
            this.showError("Please enter a filename");
            return;
        }
        boolean success = StatImportExport.exportAllStats(filename);
        if (success) {
            this.showSuccess("Exported all stats");
        } else {
            this.showError("Failed to export (no stats found?)");
        }
    }

    private void importSelected() {
        String selected = this.listWidget.getSelectedFile();
        if (selected == null) {
            this.showError("No file selected");
            return;
        }
        StatImportExport.ImportResult result = StatImportExport.importStat(selected);
        if (result.success) {
            for (CustomStatDefinition stat : result.importedStats) {
                CustomStatManager.updateCustomStat(stat);
            }
            this.showSuccess(result.message);
        } else {
            this.showError(result.message);
        }
    }

    private void showSuccess(String message) {
        this.statusMessage = message;
        this.statusMessageTime = System.currentTimeMillis();
        this.statusIsError = false;
    }

    private void showError(String message) {
        this.statusMessage = message;
        this.statusMessageTime = System.currentTimeMillis();
        this.statusIsError = true;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        String instructions = this.exportMode ? (this.singleStat != null ? Component.m_237115_((String)"gui.beautiful_statistics_screen.export.single_instruction").getString() : Component.m_237115_((String)"gui.beautiful_statistics_screen.export.instruction").getString()) : Component.m_237115_((String)"gui.beautiful_statistics_screen.import.instruction").getString();
        graphics.m_280137_(this.f_96547_, instructions, this.f_96543_ / 2, 105, 0x888888);
        if (!this.statusMessage.isEmpty() && System.currentTimeMillis() - this.statusMessageTime < 5000L) {
            int color = this.statusIsError ? 0xFF5555 : 0x55FF55;
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, this.f_96544_ - 55, color);
        }
        if (this.exportMode && this.filenameField != null) {
            graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.export.filename").getString(), this.f_96543_ / 2 - 150, 60, 0xFFFFFF);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private class ImportExportListWidget
    extends ObjectSelectionList<Entry> {
        private List<StatEntry> statEntries;
        private List<FileEntry> fileEntries;

        public ImportExportListWidget(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.statEntries = new ArrayList<StatEntry>();
            this.fileEntries = new ArrayList<FileEntry>();
        }

        public void addExportEntry(CustomStatDefinition stat) {
            StatEntry entry = new StatEntry(stat);
            this.statEntries.add(entry);
            this.m_7085_((AbstractSelectionList.Entry)entry);
        }

        public void addImportEntry(String filename) {
            FileEntry entry = new FileEntry(filename);
            this.fileEntries.add(entry);
            this.m_7085_((AbstractSelectionList.Entry)entry);
        }

        public List<CustomStatDefinition> getSelectedStats() {
            ArrayList<CustomStatDefinition> selected = new ArrayList<CustomStatDefinition>();
            for (StatEntry entry : this.statEntries) {
                if (!entry.isSelected()) continue;
                selected.add(entry.stat);
            }
            return selected;
        }

        public String getSelectedFile() {
            for (FileEntry entry : this.fileEntries) {
                if (entry != this.m_93511_()) continue;
                return entry.filename;
            }
            return null;
        }

        public class StatEntry
        extends Entry {
            private final CustomStatDefinition stat;
            private boolean selected;

            public StatEntry(CustomStatDefinition stat) {
                this.selected = false;
                this.stat = stat;
            }

            public boolean isSelected() {
                return this.selected;
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                if (this.selected) {
                    graphics.m_280509_(left, top, left + width, top + height, -2007629995);
                } else if (isHovering) {
                    graphics.m_280509_(left, top, left + width, top + height, 0x44FFFFFF);
                }
                graphics.m_280488_(StatImportExportScreen.this.f_96547_, "\u00a7f" + this.stat.getName(), left + 25, top + 2, 0xFFFFFF);
                String category = this.stat.getCategory() != null ? this.stat.getCategory() : "None";
                graphics.m_280488_(StatImportExportScreen.this.f_96547_, "\u00a77" + category, left + 25, top + 13, 0xAAAAAA);
                if (this.stat.getConditionalBlock() != null) {
                    int blockCount = this.stat.getConditionalBlock().getTotalBlockCount() - 1;
                    String blocks = "\u00a76\u2726 " + blockCount + " blocks";
                    graphics.m_280488_(StatImportExportScreen.this.f_96547_, blocks, left + width - StatImportExportScreen.this.f_96547_.m_92895_(blocks) - 10, top + 8, 0xFFAA00);
                }
                int checkX = left + 5;
                int checkY = top + 7;
                graphics.m_280509_(checkX, checkY, checkX + 10, checkY + 10, -1);
                if (this.selected) {
                    graphics.m_280509_(checkX + 2, checkY + 2, checkX + 8, checkY + 8, -11141291);
                }
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.stat.getName());
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                this.selected = !this.selected;
                return true;
            }
        }

        public class FileEntry
        extends Entry {
            private final String filename;

            public FileEntry(String filename) {
                this.filename = filename;
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                boolean selected;
                boolean bl = selected = this == ImportExportListWidget.this.m_93511_();
                if (selected) {
                    graphics.m_280509_(left, top, left + width, top + height, -2007629995);
                } else if (isHovering) {
                    graphics.m_280509_(left, top, left + width, top + height, 0x44FFFFFF);
                }
                graphics.m_280488_(StatImportExportScreen.this.f_96547_, "\u00a7f" + this.filename, left + 10, top + 8, 0xFFFFFF);
                graphics.m_280488_(StatImportExportScreen.this.f_96547_, "\ud83d\udcc4", left + width - 30, top + 8, 0xFFFFFF);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.filename);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                ImportExportListWidget.this.m_6987_((AbstractSelectionList.Entry)this);
                return true;
            }
        }

        public abstract class Entry
        extends ObjectSelectionList.Entry<Entry> {
        }
    }
}

