/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;

public class StatPreviewScreen
extends Screen {
    private final Screen parent;
    private final CustomStatDefinition stat;
    private Button closeButton;
    private static final long[] SAMPLE_VALUES = new long[]{0L, 42L, 1337L, 99999L, 1000000L};
    private int currentSampleIndex = 0;

    public StatPreviewScreen(Screen parent, CustomStatDefinition stat) {
        super((Component)Component.m_237113_((String)"Stat Preview"));
        this.parent = parent;
        this.stat = stat;
        stat.increment(SAMPLE_VALUES[this.currentSampleIndex]);
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int bottomY = this.f_96544_ - 30;
        Button nextValueButton = Button.m_253074_((Component)Component.m_237113_((String)"Next Value"), btn -> this.cycleSampleValue()).m_252987_(centerX - 110, bottomY, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)nextValueButton);
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"Close"), btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX + 10, bottomY, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.closeButton);
    }

    private void cycleSampleValue() {
        this.currentSampleIndex = (this.currentSampleIndex + 1) % SAMPLE_VALUES.length;
        this.stat.reset();
        this.stat.increment(SAMPLE_VALUES[this.currentSampleIndex]);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2 - 60;
        graphics.m_280653_(this.f_96547_, this.f_96539_, centerX, 20, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77How your stat will appear", centerX, 35, 0x888888);
        int boxWidth = 400;
        int boxHeight = 200;
        int boxX = centerX - boxWidth / 2;
        int boxY = centerY - boxHeight / 2;
        graphics.m_280509_(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -14013910);
        graphics.m_280637_(boxX, boxY, boxWidth, boxHeight, -11184811);
        int iconX = boxX + 20;
        int iconY = boxY + 20;
        int iconSize = 48;
        graphics.m_280509_(iconX, iconY, iconX + iconSize, iconY + iconSize, -15066598);
        if (this.stat.getIcon() != null && !this.stat.getIcon().isEmpty()) {
            try {
                ResourceLocation iconRes = new ResourceLocation(this.stat.getIcon());
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(iconRes);
                if (item != null && item != Items.f_41852_) {
                    ItemStack stack = new ItemStack((ItemLike)item);
                    int itemX = iconX + (iconSize - 16) / 2;
                    int itemY = iconY + (iconSize - 16) / 2;
                    graphics.m_280480_(stack, itemX, itemY);
                }
            }
            catch (Exception e) {
                graphics.m_280488_(this.f_96547_, "?", iconX + 20, iconY + 20, 0x888888);
            }
        }
        int textX = iconX + iconSize + 15;
        int textY = iconY;
        String name = this.stat.getName() != null && !this.stat.getName().isEmpty() ? this.stat.getName() : "\u00a77Unnamed Stat";
        graphics.m_280488_(this.f_96547_, "\u00a7l" + name, textX, textY, 0xFFFFFF);
        String description = this.stat.getDescription() != null && !this.stat.getDescription().isEmpty() ? this.stat.getDescription() : "\u00a77No description";
        graphics.m_280488_(this.f_96547_, "\u00a77" + description, textX, textY + 15, 0xAAAAAA);
        String formattedValue = this.stat.getFormattedValue();
        graphics.m_280488_(this.f_96547_, "\u00a7eValue: \u00a7f" + formattedValue, textX, textY + 35, 0xFFFFFF);
        String category = this.stat.getCategory() != null ? this.stat.getCategory() : "custom";
        graphics.m_280488_(this.f_96547_, "\u00a77Category: \u00a7f" + category, boxX + 20, boxY + boxHeight - 90, 0xAAAAAA);
        String trackingType = this.stat.getTrackingType() != null ? this.stat.getTrackingType().getDisplayName() : "Unknown";
        graphics.m_280488_(this.f_96547_, "\u00a77Tracks: \u00a7f" + trackingType, boxX + 20, boxY + boxHeight - 70, 0xAAAAAA);
        String aggregationType = this.stat.getAggregationType() != null ? this.stat.getAggregationType().getDisplayName() : "Unknown";
        graphics.m_280488_(this.f_96547_, "\u00a77Aggregation: \u00a7f" + aggregationType, boxX + 20, boxY + boxHeight - 50, 0xAAAAAA);
        String formatType = this.stat.getFormatType() != null ? this.stat.getFormatType().getDisplayName() : "Unknown";
        graphics.m_280488_(this.f_96547_, "\u00a77Format: \u00a7f" + formatType, boxX + 20, boxY + boxHeight - 30, 0xAAAAAA);
        if (this.stat.getConditionGroup() != null && !this.stat.getConditionGroup().isEmpty()) {
            int conditionCount;
            String condText = "\u00a7e\u2713 " + conditionCount + " condition" + ((conditionCount = this.stat.getConditionGroup().getConditions().size()) == 1 ? "" : "s");
            graphics.m_280488_(this.f_96547_, condText, boxX + boxWidth - this.f_96547_.m_92895_(condText) - 20, boxY + boxHeight - 30, 0xFFAA00);
        }
        graphics.m_280137_(this.f_96547_, "\u00a77Sample value: " + SAMPLE_VALUES[this.currentSampleIndex], centerX, boxY + boxHeight + 15, 0x888888);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }
}

