/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;
import org.texboobcat.beautiful_statistics_screen.custom.StatTemplate;

public class StatTemplatesScreen
extends Screen {
    private final Screen parent;
    private TemplateListWidget templateList;
    private Button createFromTemplateButton;
    private Button backButton;
    private int selectedIndex = -1;
    private List<StatTemplate> templates;

    public StatTemplatesScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.templates"));
        this.parent = parent;
    }

    protected void m_7856_() {
        Collection<StatTemplate> allTemplates = CustomStatManager.getAllTemplates();
        this.templates = new ArrayList<StatTemplate>(allTemplates);
        this.templateList = new TemplateListWidget(this.f_96541_, this.f_96543_, this.f_96544_ - 96, 32, this.f_96544_ - 64, 60);
        this.templateList.setTemplates(this.templates);
        this.m_142416_((GuiEventListener)this.templateList);
        int buttonY = this.f_96544_ - 52;
        int buttonWidth = 120;
        int spacing = 10;
        int startX = (this.f_96543_ - (buttonWidth * 2 + spacing)) / 2;
        this.createFromTemplateButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.template.use"), button -> this.createFromTemplate()).m_252987_(startX, buttonY, buttonWidth, 20).m_253136_();
        this.createFromTemplateButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.createFromTemplateButton);
        this.backButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(startX + buttonWidth + spacing, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.backButton);
    }

    private void createFromTemplate() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.templates.size()) {
            StatTemplate template = this.templates.get(this.selectedIndex);
            CustomStatManager.createFromTemplate(template.getId());
            if (this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237110_((String)"message.beautiful_statistics_screen.template_created", (Object[])new Object[]{template.getName()}));
            }
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        boolean hasSelection;
        this.createFromTemplateButton.f_93623_ = hasSelection = this.selectedIndex >= 0 && this.selectedIndex < this.templates.size();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 12, 0xFFFFFF);
        String infoText = Component.m_237110_((String)"gui.beautiful_statistics_screen.templates_count", (Object[])new Object[]{this.templates.size()}).getString();
        graphics.m_280488_(this.f_96547_, infoText, 10, this.f_96544_ - 76, 0xAAAAAA);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private class TemplateListWidget
    extends ObjectSelectionList<TemplateEntry> {
        private List<StatTemplate> templates;

        public TemplateListWidget(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.templates = new ArrayList<StatTemplate>();
        }

        public void setTemplates(List<StatTemplate> templates) {
            this.m_93516_();
            this.templates = templates;
            for (int i = 0; i < templates.size(); ++i) {
                this.m_7085_((AbstractSelectionList.Entry)new TemplateEntry(templates.get(i), i));
            }
        }

        public class TemplateEntry
        extends ObjectSelectionList.Entry<TemplateEntry> {
            private final StatTemplate template;
            private final int index;

            public TemplateEntry(StatTemplate template, int index) {
                this.template = template;
                this.index = index;
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                boolean selected;
                boolean bl = selected = StatTemplatesScreen.this.selectedIndex == this.index;
                if (selected) {
                    graphics.m_280509_(left, top, left + width, top + height, -2130706433);
                } else if (isHovering) {
                    graphics.m_280509_(left, top, left + width, top + height, 0x40FFFFFF);
                }
                Object nameText = this.template.getName();
                if (this.template.isBuiltin()) {
                    nameText = "\u00a7e\u2b50 " + (String)nameText;
                }
                graphics.m_280488_(StatTemplatesScreen.this.f_96547_, (String)nameText, left + 5, top + 5, 0xFFFFFF);
                String desc = this.template.getDescription();
                if (desc != null && !desc.isEmpty()) {
                    graphics.m_280488_(StatTemplatesScreen.this.f_96547_, "\u00a77" + desc, left + 5, top + 18, 0xAAAAAA);
                }
                String typeInfo = "\u00a78" + this.template.getCategory() + " \u2022 " + this.template.getTrackingType().getDisplayName();
                graphics.m_280488_(StatTemplatesScreen.this.f_96547_, typeInfo, left + 5, top + 31, 0x888888);
                String icon = this.template.getIcon();
                if (icon != null && !icon.isEmpty()) {
                    graphics.m_280488_(StatTemplatesScreen.this.f_96547_, "Icon: " + icon, left + 5, top + 44, 0x666666);
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                StatTemplatesScreen.this.setSelectedIndex(this.index);
                return true;
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.template.getName());
            }
        }
    }
}

