/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui.chart;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ChartDataset {
    private final ResourceLocation statId;
    private final Component displayName;
    private final List<DataPoint> data;
    private int color;
    private boolean visible;
    private ChartStyle style;
    private boolean showTrendLine;
    private int trendLineColor;

    public ChartDataset(ResourceLocation statId, Component displayName, List<DataPoint> data, int color) {
        this.statId = statId;
        this.displayName = displayName;
        this.data = new ArrayList<DataPoint>(data);
        this.color = color;
        this.visible = true;
        this.style = ChartStyle.LINE;
        this.showTrendLine = false;
        this.trendLineColor = this.adjustColorAlpha(color, 128);
    }

    public ResourceLocation getStatId() {
        return this.statId;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public List<DataPoint> getData() {
        return this.data;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.trendLineColor = this.adjustColorAlpha(color, 128);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public ChartStyle getStyle() {
        return this.style;
    }

    public void setStyle(ChartStyle style) {
        this.style = style;
    }

    public boolean isShowTrendLine() {
        return this.showTrendLine;
    }

    public void setShowTrendLine(boolean showTrendLine) {
        this.showTrendLine = showTrendLine;
    }

    public int getTrendLineColor() {
        return this.trendLineColor;
    }

    public void setTrendLineColor(int trendLineColor) {
        this.trendLineColor = trendLineColor;
    }

    public TrendLine calculateTrendLine() {
        if (this.data.isEmpty()) {
            return null;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumX2 = 0.0;
        int n = this.data.size();
        for (DataPoint point : this.data) {
            double x = point.timestamp;
            double y = point.value;
            sumX += x;
            sumY += y;
            sumXY += x * y;
            sumX2 += x * x;
        }
        double slope = ((double)n * sumXY - sumX * sumY) / ((double)n * sumX2 - sumX * sumX);
        double intercept = (sumY - slope * sumX) / (double)n;
        return new TrendLine(slope, intercept);
    }

    public DatasetStatistics getStatistics() {
        if (this.data.isEmpty()) {
            return new DatasetStatistics(0L, 0L, 0.0, 0L, 0.0, 0L);
        }
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long sum = 0L;
        for (DataPoint point : this.data) {
            min = Math.min(min, point.value);
            max = Math.max(max, point.value);
            sum += point.value;
        }
        double mean = (double)sum / (double)this.data.size();
        double variance = 0.0;
        for (DataPoint point : this.data) {
            double diff = (double)point.value - mean;
            variance += diff * diff;
        }
        double stdDev = Math.sqrt(variance /= (double)this.data.size());
        List<Long> sortedValues = this.data.stream().map(p -> p.value).sorted().toList();
        long median = sortedValues.get(sortedValues.size() / 2);
        return new DatasetStatistics(min, max, mean, median, stdDev, sum);
    }

    private int adjustColorAlpha(int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static enum ChartStyle {
        LINE,
        BAR,
        AREA,
        SCATTER,
        STEP;

    }

    public record DataPoint(long timestamp, long value) {
        public DataPoint normalize(long minTime, long maxTime, long minVal, long maxVal) {
            long normTime = maxTime == minTime ? 0L : this.timestamp - minTime;
            long normVal = maxVal == minVal ? 0L : this.value - minVal;
            return new DataPoint(normTime, normVal);
        }
    }

    public record TrendLine(double slope, double intercept) {
        public long getValueAt(long timestamp) {
            return (long)(this.slope * (double)timestamp + this.intercept);
        }
    }

    public record DatasetStatistics(long min, long max, double mean, long median, double standardDeviation, long total) {
        public long getRange() {
            return this.max - this.min;
        }

        public double getCoefficientOfVariation() {
            return this.mean == 0.0 ? 0.0 : this.standardDeviation / this.mean * 100.0;
        }
    }
}

