/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui.widgets;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.client.gui.chart.ChartDataset;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class StatisticsPanel
extends AbstractWidget {
    private final Minecraft minecraft;
    private final List<ChartDataset> datasets;
    private int scrollOffset = 0;

    public StatisticsPanel(Minecraft minecraft, int x, int y, int width, int height, List<ChartDataset> datasets) {
        super(x, y, width, height, (Component)Component.m_237113_((String)"Statistics"));
        this.minecraft = minecraft;
        this.datasets = datasets;
    }

    protected void m_168797_(NarrationElementOutput output) {
        output.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237113_((String)"Statistics Panel"));
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.f_93624_) {
            return;
        }
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -805306368);
        graphics.m_280488_(this.minecraft.f_91062_, "Statistics", this.m_252754_() + 6, this.m_252907_() + 6, 0xFFFFFF);
        int y = this.m_252907_() + 20 - this.scrollOffset;
        int x = this.m_252754_() + 10;
        for (ChartDataset dataset : this.datasets) {
            ChartDataset.TrendLine trend;
            if (!dataset.isVisible()) continue;
            if (y > this.m_252907_() + this.f_93619_ || y < this.m_252907_() + 20) {
                y += this.calculateDatasetHeight(dataset);
                continue;
            }
            graphics.m_280509_(x - 4, y, x - 2, y + 10, dataset.getColor());
            Object name = dataset.getDisplayName().getString();
            if (((String)name).length() > 25) {
                name = ((String)name).substring(0, 22) + "...";
            }
            graphics.m_280488_(this.minecraft.f_91062_, (String)name, x, y, 0xFFFFFF);
            ChartDataset.DatasetStatistics stats = dataset.getStatistics();
            this.drawStat(graphics, x, y += 12, "Min", StatFormatter.formatValue(stats.min()));
            this.drawStat(graphics, x, y += 10, "Max", StatFormatter.formatValue(stats.max()));
            this.drawStat(graphics, x, y += 10, "Mean", String.format("%.2f", stats.mean()));
            this.drawStat(graphics, x, y += 10, "Median", StatFormatter.formatValue(stats.median()));
            this.drawStat(graphics, x, y += 10, "StdDev", String.format("%.2f", stats.standardDeviation()));
            this.drawStat(graphics, x, y += 10, "Range", StatFormatter.formatValue(stats.getRange()));
            y += 10;
            if (dataset.isShowTrendLine() && (trend = dataset.calculateTrendLine()) != null) {
                String direction = trend.slope() > 0.0 ? "\u2191" : (trend.slope() < 0.0 ? "\u2193" : "\u2192");
                String trendStr = direction + " " + String.format("%.4f", Math.abs(trend.slope()));
                graphics.m_280488_(this.minecraft.f_91062_, "Trend: " + trendStr, x, y, 0xFFAA00);
                y += 10;
            }
            y += 8;
        }
        if (this.getMaxScroll() > 0) {
            int scrollBarHeight = Math.max(20, this.f_93619_ * this.f_93619_ / this.getTotalHeight());
            int scrollBarY = this.m_252907_() + 20 + (int)((float)this.scrollOffset / (float)this.getMaxScroll() * (float)(this.f_93619_ - 20 - scrollBarHeight));
            graphics.m_280509_(this.m_252754_() + this.f_93618_ - 4, scrollBarY, this.m_252754_() + this.f_93618_ - 2, scrollBarY + scrollBarHeight, -16733441);
        }
    }

    private void drawStat(GuiGraphics graphics, int x, int y, String label, String value) {
        graphics.m_280488_(this.minecraft.f_91062_, label + ":", x, y, 0x888888);
        graphics.m_280488_(this.minecraft.f_91062_, value, x + 60, y, 0xCCCCCC);
    }

    private int calculateDatasetHeight(ChartDataset dataset) {
        int height = 72;
        if (dataset.isShowTrendLine()) {
            height += 10;
        }
        return height + 8;
    }

    private int getTotalHeight() {
        return this.datasets.stream().filter(ChartDataset::isVisible).mapToInt(this::calculateDatasetHeight).sum() + 20;
    }

    private int getMaxScroll() {
        return Math.max(0, this.getTotalHeight() - this.f_93619_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.f_93624_) {
            return false;
        }
        this.scrollOffset = Math.max(0, Math.min(this.getMaxScroll(), this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }
}

